/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import mapwriter.Mw;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;

public class MwGuiOptionSlot
extends GuiSlot {
    private Minecraft mc;
    private Mw mw;
    private int mouseX = 0;
    private int mouseY = 0;
    private int miniMapPositionIndex = 0;
    private static final String[] miniMapPositionStringArray = new String[]{"unchanged", "top right", "top left", "bottom right", "bottom left"};
    private static final String[] coordsModeStringArray = new String[]{"disabled", "small", "large"};
    private static final String[] backgroundModeStringArray = new String[]{"none", "static", "panning"};
    private GuiButton[] buttons = new GuiButton[12];
    static final ResourceLocation WIDGET_TEXTURE_LOC = new ResourceLocation("textures/gui/widgets.png");

    public void updateButtonLabel(int i) {
        switch (i) {
            case 0: {
                this.buttons[i].field_146126_j = "Draw coords: " + coordsModeStringArray[this.mw.coordsMode];
                break;
            }
            case 1: {
                this.buttons[i].field_146126_j = "Circular mode: " + this.mw.miniMap.smallMapMode.circular;
                break;
            }
            case 2: {
                this.buttons[i].field_146126_j = "Texture size: " + this.mw.configTextureSize;
                break;
            }
            case 3: {
                this.buttons[i].field_146126_j = "Texture scaling: " + (this.mw.linearTextureScalingEnabled ? "linear" : "nearest");
                break;
            }
            case 4: {
                this.buttons[i].field_146126_j = "Trail markers: " + this.mw.playerTrail.enabled;
                break;
            }
            case 5: {
                this.buttons[i].field_146126_j = "Map colours: " + (this.mw.useSavedBlockColours ? "frozen" : "auto");
                break;
            }
            case 6: {
                this.buttons[i].field_146126_j = "Max draw distance: " + Math.round(Math.sqrt(this.mw.maxChunkSaveDistSq));
                break;
            }
            case 7: {
                this.buttons[i].field_146126_j = "Mini map size: " + this.mw.miniMap.smallMapMode.heightPercent;
                break;
            }
            case 8: {
                this.buttons[i].field_146126_j = "Mini map position: " + miniMapPositionStringArray[this.miniMapPositionIndex];
                break;
            }
            case 9: {
                this.buttons[i].field_146126_j = "Map pixel snapping: " + (this.mw.mapPixelSnapEnabled ? "enabled" : "disabled");
                break;
            }
            case 10: {
                this.buttons[i].field_146126_j = "Max death markers: " + this.mw.maxDeathMarkers;
                break;
            }
            case 11: {
                this.buttons[i].field_146126_j = "Background mode: " + backgroundModeStringArray[this.mw.backgroundTextureMode];
                break;
            }
        }
    }

    public MwGuiOptionSlot(GuiScreen parentScreen, Minecraft mc, Mw mw) {
        super(mc, parentScreen.field_146294_l, parentScreen.field_146295_m, 16, parentScreen.field_146295_m - 32, 25);
        this.mw = mw;
        this.mc = mc;
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new GuiButton(300 + i, 0, 0, "");
            this.updateButtonLabel(i);
        }
    }

    protected boolean keyTyped(char c, int k) {
        return false;
    }

    protected int func_148127_b() {
        return this.buttons.length;
    }

    protected void func_148144_a(int i, boolean doubleClicked, int x, int y) {
        switch (i) {
            case 0: {
                this.mw.toggleCoords();
                break;
            }
            case 1: {
                this.mw.miniMap.toggleRotating();
                break;
            }
            case 2: {
                this.mw.configTextureSize *= 2;
                if (this.mw.configTextureSize <= 4096) break;
                this.mw.configTextureSize = 1024;
                break;
            }
            case 3: {
                this.mw.linearTextureScalingEnabled = !this.mw.linearTextureScalingEnabled;
                this.mw.mapTexture.setLinearScaling(this.mw.linearTextureScalingEnabled);
                break;
            }
            case 4: {
                this.mw.playerTrail.enabled = !this.mw.playerTrail.enabled;
                break;
            }
            case 5: {
                this.mw.useSavedBlockColours = !this.mw.useSavedBlockColours;
                this.mw.reloadBlockColours();
                break;
            }
            case 6: {
                int d = Math.round((float)Math.sqrt(this.mw.maxChunkSaveDistSq));
                if ((d += 32) > 256) {
                    d = 64;
                }
                this.mw.maxChunkSaveDistSq = d * d;
                break;
            }
            case 7: {
                this.mw.miniMap.smallMapMode.toggleHeightPercent();
                break;
            }
            case 8: {
                ++this.miniMapPositionIndex;
                if (this.miniMapPositionIndex >= miniMapPositionStringArray.length) {
                    this.miniMapPositionIndex = 1;
                }
                switch (this.miniMapPositionIndex) {
                    case 1: {
                        this.mw.miniMap.smallMapMode.setMargins(10, -1, -1, 10);
                        break;
                    }
                    case 2: {
                        this.mw.miniMap.smallMapMode.setMargins(10, -1, 10, -1);
                        break;
                    }
                    case 3: {
                        this.mw.miniMap.smallMapMode.setMargins(-1, 40, -1, 10);
                        break;
                    }
                    case 4: {
                        this.mw.miniMap.smallMapMode.setMargins(-1, 40, 10, -1);
                        break;
                    }
                }
            }
            case 9: {
                this.mw.mapPixelSnapEnabled = !this.mw.mapPixelSnapEnabled;
                break;
            }
            case 10: {
                ++this.mw.maxDeathMarkers;
                if (this.mw.maxDeathMarkers <= 10) break;
                this.mw.maxDeathMarkers = 0;
                break;
            }
            case 11: {
                this.mw.backgroundTextureMode = (this.mw.backgroundTextureMode + 1) % 3;
                break;
            }
        }
        this.updateButtonLabel(i);
    }

    public void func_148128_a(int mouseX, int mouseY, float f) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        super.func_148128_a(mouseX, mouseY, f);
    }

    protected boolean func_148131_a(int i) {
        return false;
    }

    protected void func_148123_a() {
    }

    protected void func_148126_a(int i, int x, int y, int i4, Tessellator tessellator, int i5, int i6) {
        GuiButton button = this.buttons[i];
        button.field_146128_h = x;
        button.field_146129_i = y;
        button.func_146112_a(this.mc, this.mouseX, this.mouseY);
    }
}

