/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.statues.EntityStatuePlayer;
import info.jbcs.minecraft.statues.EntityTextureFX;
import info.jbcs.minecraft.statues.TileEntityStatue;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GeneralStatueClient {
    static Random rand = new Random();

    public static EntityDiggingFX addBlockHitEffects(World world, int x, int y, int z, Block block, int meta, int side) {
        EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
        if (block == null) {
            return null;
        }
        float f = 0.1f;
        double d0 = (double)x + rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
        double d1 = (double)y + rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
        double d2 = (double)z + rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
        switch (side) {
            case 0: {
                d1 = (double)y + block.func_149665_z() - (double)f;
                break;
            }
            case 1: {
                d1 = (double)y + block.func_149669_A() + (double)f;
                break;
            }
            case 2: {
                d2 = (double)z + block.func_149706_B() - (double)f;
                break;
            }
            case 3: {
                d2 = (double)z + block.func_149693_C() + (double)f;
                break;
            }
            case 4: {
                d0 = (double)x + block.func_149704_x() - (double)f;
                break;
            }
            case 5: {
                d0 = (double)x + block.func_149753_y() + (double)f;
            }
        }
        EntityDiggingFX res = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, block, meta, side);
        res.field_70159_w = d0 - ((double)x + 0.5);
        res.field_70181_x = d1 - ((double)y + 0.5);
        res.field_70179_y = d2 - ((double)z + 0.5);
        renderer.func_78873_a((EntityFX)res);
        return res;
    }

    public static void spawnSculptEffect(int x, int y, int z, Block block, byte meta) {
        if (block == null) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (int side = 0; side < 6; ++side) {
            for (int j = 0; j < 32; ++j) {
                EntityDiggingFX fx = GeneralStatueClient.addBlockHitEffects((World)Minecraft.func_71410_x().field_71441_e, x, y, z, block, meta, side);
                if (fx == null) {
                    return;
                }
                fx.func_70541_f(0.25f + 0.5f * rand.nextFloat());
                fx.func_70543_e(0.3f * rand.nextFloat());
            }
        }
        Minecraft.func_71410_x().field_71441_e.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_149762_H.func_150495_a(), 1.0f, 0.6f + 0.4f * rand.nextFloat(), true);
    }

    public static ResourceLocation getBlockIcon(Block block, int side, int meta) {
        String textureName = block.func_149691_a(side, meta).func_94215_i();
        String domain = "";
        int index = textureName.indexOf(":");
        if (index != -1) {
            domain = textureName.substring(0, index + 1).toLowerCase();
            textureName = textureName.substring(index + 1);
        }
        return new ResourceLocation(domain + "textures/blocks/" + textureName + ".png");
    }

    public static EntityTextureFX addTextureEffects(World world, int x, int y, int z, AbstractTexture texture, int side, float u, float v) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return null;
        }
        double w = block.func_149753_y() - block.func_149704_x();
        double h = block.func_149669_A() - block.func_149665_z();
        double l = block.func_149693_C() - block.func_149706_B();
        double px = rand.nextDouble() * w;
        double py = rand.nextDouble() * h;
        double pz = rand.nextDouble() * l;
        float f = 0.25f;
        double d0 = (double)x + block.func_149704_x() + px;
        double d1 = (double)y + block.func_149665_z() + py;
        double d2 = (double)z + block.func_149706_B() + pz;
        switch (side) {
            case 0: {
                d1 = (double)y + block.func_149665_z() - (double)f;
                break;
            }
            case 1: {
                d1 = (double)y + block.func_149669_A() + (double)f;
                break;
            }
            case 2: {
                d2 = (double)z + block.func_149706_B() - (double)f;
                break;
            }
            case 3: {
                d2 = (double)z + block.func_149693_C() + (double)f;
                break;
            }
            case 4: {
                d0 = (double)x + block.func_149704_x() - (double)f;
                break;
            }
            case 5: {
                d0 = (double)x + block.func_149753_y() + (double)f;
            }
        }
        double motion = 0.5;
        EntityTextureFX res = new EntityTextureFX(world, d0, d1, d2, motion * (px / w - 0.5), motion * (py / h - 0.5), motion * (pz / l - 0.5), texture, u, v);
        return res;
    }

    public static void spawnPaintEffect(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityStatue)) {
            return;
        }
        TileEntityStatue statue = (TileEntityStatue)te;
        EntityStatuePlayer player = statue.getStatue();
        AbstractTexture tex = player.getTextureSkin();
        for (int side = 2; side < 6; ++side) {
            for (int i = 0; i < 80; ++i) {
                EntityTextureFX p = GeneralStatueClient.addTextureEffects(world, x, y + i % 2, z, tex, side, 0.05f, 0.1f);
                if (p == null) continue;
                world.func_72838_d((Entity)p);
            }
        }
    }

    public static void spawnCopyEffect(World world, int x, int y, int z, int side, float hx, float hy, float hz, TileEntityStatue statue) {
        world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "statues:copy", 2.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f, false);
        for (int i = 0; i < 8; ++i) {
            EntityDiggingFX fx = GeneralStatueClient.addBlockHitEffects((World)Minecraft.func_71410_x().field_71441_e, x, y, z, statue.block, statue.meta, side);
            if (fx == null) {
                return;
            }
            fx.func_70107_b((double)((float)x + hx), (double)((float)y + hy), (double)((float)z + hz));
            fx.func_70541_f(0.15f + 0.7f * rand.nextFloat());
            fx.func_70543_e(0.3f * rand.nextFloat());
        }
    }
}

