/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.decor.IFloatingFlower;
import vazkii.botania.common.item.ItemMod;

public class ItemGrassSeeds
extends ItemMod {
    private static Map<Integer, List<BlockSwapper>> blockSwappers = new HashMap<Integer, List<BlockSwapper>>();
    private static final IFloatingFlower.IslandType[] ISLAND_TYPES = new IFloatingFlower.IslandType[]{IFloatingFlower.IslandType.GRASS, IFloatingFlower.IslandType.PODZOL, IFloatingFlower.IslandType.MYCEL};
    private static final int types = 3;
    IIcon[] icons;

    public ItemGrassSeeds() {
        this.func_77655_b("grassSeeds");
        this.func_77627_a(true);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void func_150895_a(Item par1, CreativeTabs par2, List par3) {
        for (int i = 0; i < 3; ++i) {
            par3.add(new ItemStack(par1, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.icons = new IIcon[3];
        for (int i = 0; i < 3; ++i) {
            this.icons[i] = IconHelper.forItem(par1IconRegister, (Item)this, i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.icons[Math.min(this.icons.length - 1, par1)];
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + stack.func_77960_j();
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        Block block = par3World.func_147439_a(par4, par5, par6);
        int bmeta = par3World.func_72805_g(par4, par5, par6);
        if (block == Blocks.field_150346_d && bmeta == 0) {
            int meta = par1ItemStack.func_77960_j();
            BlockSwapper swapper = ItemGrassSeeds.addBlockSwapper(par3World, par4, par5, par6, meta);
            par3World.func_147465_d(par4, par5, par6, swapper.blockToSet, swapper.metaToSet, 3);
            for (int i = 0; i < 50; ++i) {
                double x = (Math.random() - 0.5) * 3.0;
                double y = Math.random() - 0.5 + 1.0;
                double z = (Math.random() - 0.5) * 3.0;
                float r = 0.0f;
                float g = 0.4f;
                float b = 0.0f;
                if (meta == 1) {
                    r = 0.5f;
                    g = 0.37f;
                    b = 0.0f;
                } else if (meta == 2) {
                    r = 0.27f;
                    g = 0.0f;
                    b = 0.33f;
                }
                float velMul = 0.025f;
                Botania.proxy.wispFX(par3World, (double)par4 + 0.5 + x, (double)par5 + 0.5 + y, (double)par6 + 0.5 + z, r, g, b, (float)Math.random() * 0.15f + 0.15f, (float)(-x) * velMul, (float)(-y) * velMul, (float)(-z) * velMul);
            }
            --par1ItemStack.field_77994_a;
        }
        return true;
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.WorldTickEvent event) {
        int dim;
        if (event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.field_73011_w.field_76574_g)) {
            List<BlockSwapper> swappers = blockSwappers.get(dim);
            ArrayList<BlockSwapper> swappersSafe = new ArrayList<BlockSwapper>(swappers);
            for (BlockSwapper s : swappersSafe) {
                s.tick(swappers);
            }
        }
    }

    private static BlockSwapper addBlockSwapper(World world, int x, int y, int z, int meta) {
        BlockSwapper swapper = ItemGrassSeeds.swapperFromMeta(world, x, y, z, meta);
        int dim = world.field_73011_w.field_76574_g;
        if (!blockSwappers.containsKey(dim)) {
            blockSwappers.put(dim, new ArrayList());
        }
        blockSwappers.get(dim).add(swapper);
        return swapper;
    }

    private static BlockSwapper swapperFromMeta(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 1: {
                return new BlockSwapper(world, new ChunkCoordinates(x, y, z), Blocks.field_150346_d, 2);
            }
            case 2: {
                return new BlockSwapper(world, new ChunkCoordinates(x, y, z), (Block)Blocks.field_150391_bh, 0);
            }
        }
        return new BlockSwapper(world, new ChunkCoordinates(x, y, z), (Block)Blocks.field_150349_c, 0);
    }

    public static IFloatingFlower.IslandType getIslandType(ItemStack stack) {
        return ISLAND_TYPES[Math.min(stack.func_77960_j(), ISLAND_TYPES.length - 1)];
    }

    private static class BlockSwapper {
        final World world;
        final Random rand;
        final Block blockToSet;
        final int metaToSet;
        ChunkCoordinates startCoords;
        int ticksExisted = 0;

        BlockSwapper(World world, ChunkCoordinates coords, Block block, int meta) {
            this.world = world;
            this.blockToSet = block;
            this.metaToSet = meta;
            this.rand = new Random(coords.field_71574_a ^ coords.field_71572_b ^ coords.field_71573_c);
            this.startCoords = coords;
        }

        void tick(List<BlockSwapper> list) {
            ++this.ticksExisted;
            int range = 3;
            for (int i = -range; i < range + 1; ++i) {
                for (int j = -range; j < range + 1; ++j) {
                    int x = this.startCoords.field_71574_a + i;
                    int y = this.startCoords.field_71572_b;
                    int z = this.startCoords.field_71573_c + j;
                    Block block = this.world.func_147439_a(x, y, z);
                    int meta = this.world.func_72805_g(x, y, z);
                    if (block != this.blockToSet || meta != this.metaToSet || this.ticksExisted % 20 != 0) continue;
                    ArrayList<ChunkCoordinates> validCoords = new ArrayList<ChunkCoordinates>();
                    for (int k = -1; k < 2; ++k) {
                        for (int l = -1; l < 2; ++l) {
                            int x1 = x + k;
                            int z1 = z + l;
                            Block block1 = this.world.func_147439_a(x1, y, z1);
                            int meta1 = this.world.func_72805_g(x1, y, z1);
                            if (block1 != Blocks.field_150346_d || meta1 != 0) continue;
                            validCoords.add(new ChunkCoordinates(x1, y, z1));
                        }
                    }
                    if (validCoords.isEmpty() || this.world.field_72995_K) continue;
                    ChunkCoordinates coords = (ChunkCoordinates)validCoords.get(this.rand.nextInt(validCoords.size()));
                    this.world.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, this.blockToSet, this.metaToSet, 3);
                }
            }
            if (this.ticksExisted >= 80) {
                list.remove(this);
            }
        }
    }
}

