/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.bag.Group;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.items.ItemBag;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiReward
extends GuiBase {
    private Group group;
    private int lines;
    private List<Reward> rewards;
    private String statisticsText;
    private static final int ITEMS_PER_LINE = 7;
    private static final int ITEM_SIZE = 16;
    private static final int ITEM_MARGIN = 5;
    private static final int TOP_HEIGHT = 52;
    private static final int MIDDLE_HEIGHT = 22;
    private static final int BOTTOM_HEIGHT = 24;
    private static final int TITLE_HEIGHT = 25;
    private static final int TOP_SRC_Y = 0;
    private static final int MIDDLE_SRC_Y = 67;
    private static final int BOTTOM_SRC_Y = 107;
    private static final int TEXTURE_WIDTH = 170;
    public static final ResourceLocation TEXTURE = ResourceHelper.getResource("reward");
    public static final ResourceLocation C_TEXTURE = ResourceHelper.getResource("c_reward");

    public GuiReward(Group group, int bagTier, EntityPlayer player) {
        this.group = group;
        this.rewards = new ArrayList<Reward>();
        int totalWeight = 0;
        for (Group other : Group.getGroups()) {
            if (!other.isValid(player)) continue;
            totalWeight += other.getTier().getWeights()[bagTier];
        }
        int myWeight = group.getTier().getWeights()[bagTier];
        float chance = (float)myWeight / (float)totalWeight;
        this.statisticsText = (float)((int)(chance * 10000.0f)) / 100.0f + "% chance to get this reward";
        this.lines = (int)Math.ceil((float)group.getItems().size() / 7.0f);
        for (int i = 0; i < this.lines; ++i) {
            int y = 52 + 22 * i + 3;
            int itemsInLine = Math.min(group.getItems().size() - i * 7, 7);
            for (int j = 0; j < itemsInLine; ++j) {
                int x = (170 - (itemsInLine * 16 + (itemsInLine - 1) * 5)) / 2 + j * 21;
                ItemStack item = group.getItems().get(i * 7 + j);
                if (item == null || item.func_77973_b() == null) continue;
                this.rewards.add(new Reward(item, x, y));
            }
        }
    }

    public void func_73863_a(int mX0, int mY0, float f) {
        this.applyColor(-1);
        ResourceHelper.bindResource(TEXTURE);
        int height = 52 + 22 * this.lines + 24;
        this.left = (this.field_146294_l - 170) / 2;
        this.top = (this.field_146295_m - height) / 2;
        this.drawRect(0, 0, 0, 0, 170, 52);
        for (int i = 0; i < this.lines; ++i) {
            this.drawRect(0, 52 + i * 22, 0, 67, 170, 22);
        }
        this.drawRect(0, 52 + this.lines * 22, 0, 107, 170, 24);
        int mX = mX0 - this.left;
        int mY = mY0 - this.top;
        this.drawCenteredString((Object)((Object)this.group.getTier().getColor()) + this.group.getTier().getName() + " Reward", 0, 0, 1.0f, 170, 25, 0x404040);
        this.drawCenteredString(this.statisticsText, 0, 25, 0.7f, 170, 27, 0x707070);
        this.drawCenteredString("Click to close", 0, 52 + this.lines * 22, 0.7f, 170, 24, 0x707070);
        for (Reward reward : this.rewards) {
            try {
                this.drawItem(reward.item, reward.x, reward.y, true);
                itemRenderer.func_77021_b(this.field_146289_q, Minecraft.func_71410_x().func_110434_K(), reward.item, reward.x + this.left + 1, reward.y + this.top + 1);
            }
            catch (Throwable ignored) {}
        }
        for (Reward reward : this.rewards) {
            if (!this.inBounds(reward.x, reward.y, 16, 16, mX, mY)) continue;
            try {
                if (GuiScreen.func_146272_n()) {
                    this.drawMouseOver(reward.item.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x), mX0, mY0);
                    continue;
                }
                ArrayList<String> str = new ArrayList<String>();
                try {
                    List info = reward.item.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                    if (info.size() > 0) {
                        str.add((String)info.get(0));
                        if (info.size() > 1) {
                            str.add((Object)((Object)GuiColor.GRAY) + "Hold shift for more info");
                        }
                    }
                    this.drawMouseOver(str, mX0, mY0);
                }
                catch (Throwable ignored) {
                }
            }
            catch (Throwable ignored) {}
        }
    }

    protected void func_73864_a(int mX0, int mY0, int b) {
        int mX = mX0 - this.left;
        int mY = mY0 - this.top;
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public boolean func_73868_f() {
        return false;
    }

    public static void open(EntityPlayer player, DataReader dr) {
        Group rewardGroup = Group.getGroups().get(dr.readData(DataBitHelper.GROUP_COUNT));
        int bagTier = dr.readData(DataBitHelper.BAG_TIER);
        for (Group group : Group.getGroups()) {
            if (group.getLimit() == 0) continue;
            group.setRetrievalCount(player, dr.readData(DataBitHelper.LIMIT));
        }
        if (ItemBag.displayGui) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiReward(rewardGroup, bagTier, player));
        }
    }

    private class Reward {
        private ItemStack item;
        private int x;
        private int y;

        private Reward(ItemStack item, int x, int y) {
            this.item = item;
            this.x = x;
            this.y = y;
        }
    }
}

