/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.commands;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import hardcorequesting.QuestingData;
import hardcorequesting.config.ModConfig;
import hardcorequesting.items.ItemQuestBook;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandHandler
extends CommandBase {
    public int lives;
    public int amount;
    public String player;

    public String func_71517_b() {
        return "hqm";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/" + this.func_71517_b() + " help";
    }

    public boolean func_71519_b(ICommandSender par1ICommandSender) {
        return true;
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new WrongUsageException("Type '" + this.func_71518_a(sender) + "' for help.", new Object[0]);
        }
        if (arguments[0].matches("edit") && sender instanceof EntityPlayer && CommandHandler.isOwnerOrOp(sender)) {
            String name;
            EntityPlayer player = (EntityPlayer)sender;
            String string = name = arguments.length == 2 ? arguments[1] : QuestingData.getUserName(player);
            if (QuestingData.hasData(name)) {
                player.field_71071_by.func_70441_a(ItemQuestBook.getOPBook(name));
            } else {
                this.sendChat((ICommandSender)player, "That player does no exist.");
            }
            return;
        }
        if (arguments[0].matches("lives")) {
            if (!QuestingData.isHardcoreActive()) {
                this.sendChat(sender, "Hardcore Mode isn't enabled yet. use '/hqm hardcore' to enable it.");
                return;
            }
            if (arguments.length == 1) {
                if (sender instanceof EntityPlayer) {
                    this.currentLives((EntityPlayer)sender);
                }
                return;
            }
            if (arguments.length == 2) {
                if (arguments[1].matches("remove") && this.isPlayerOp(sender)) {
                    if (sender instanceof EntityPlayer) {
                        this.removeLive((EntityPlayer)sender);
                    }
                    return;
                }
                if (arguments[1].matches("add") && this.isPlayerOp(sender)) {
                    if (sender instanceof EntityPlayer) {
                        this.addLive((EntityPlayer)sender);
                    }
                    return;
                }
            }
            if (arguments.length == 3) {
                if (arguments[1].matches("remove") && this.isPlayerOp(sender)) {
                    try {
                        this.amount = Integer.parseInt(arguments[2]);
                        if (sender instanceof EntityPlayer) {
                            this.removeLives((EntityPlayer)sender, this.amount);
                        }
                    }
                    catch (Exception e) {
                        throw new WrongUsageException("Please use only positive numbers.", new Object[0]);
                    }
                    return;
                }
                if (arguments[1].matches("remove") && this.isPlayerOp(sender)) {
                    try {
                        this.amount = 1;
                        this.removeLivesFrom(sender, arguments[2], this.amount);
                    }
                    catch (Exception e) {
                        throw new WrongUsageException("Please use only positive numbers.", new Object[0]);
                    }
                    return;
                }
                if (arguments[1].matches("add") && this.isPlayerOp(sender)) {
                    try {
                        this.amount = Integer.parseInt(arguments[2]);
                        if (sender instanceof EntityPlayer) {
                            this.addLives((EntityPlayer)sender, this.amount);
                        }
                    }
                    catch (Exception e) {
                        throw new WrongUsageException("Please use only positive numbers.", new Object[0]);
                    }
                    return;
                }
                if (arguments[1].matches("add") && this.isPlayerOp(sender)) {
                    try {
                        this.amount = 1;
                        this.addLivesTo(sender, arguments[2], this.amount);
                    }
                    catch (Exception e) {
                        throw new WrongUsageException("Please use only positive numbers.", new Object[0]);
                    }
                    return;
                }
                if (arguments[1].matches("playercheck") && this.isPlayerOp(sender)) {
                    this.getPlayerLives(sender, arguments[2]);
                    return;
                }
            }
            if (arguments.length == 4) {
                if (arguments[1].matches("remove") && this.isPlayerOp(sender)) {
                    try {
                        this.amount = Integer.parseInt(arguments[3]);
                        this.removeLivesFrom(sender, arguments[2], this.amount);
                    }
                    catch (Exception e) {
                        throw new WrongUsageException("Please use only positive numbers and / or a correct Playername.", new Object[0]);
                    }
                    return;
                }
                if (arguments[1].matches("add") && this.isPlayerOp(sender)) {
                    try {
                        this.amount = Integer.parseInt(arguments[3]);
                        this.addLivesTo(sender, arguments[2], this.amount);
                    }
                    catch (Exception e) {
                        throw new WrongUsageException("Please use only positive numbers and / or a correct Playername.", new Object[0]);
                    }
                    return;
                }
            }
        }
        if (arguments[0].matches("help") && this.isPlayerOp(sender)) {
            this.sendChat(sender, "Format: '" + this.func_71517_b() + " <command> <arguments>'");
            this.sendChat(sender, "Available commands:");
            this.sendChat(sender, "- version : Version information.");
            this.sendChat(sender, "- hardcore : Enable Hardcore mode.");
            this.sendChat(sender, "- quest : Enable Questing mode.");
            this.sendChat(sender, "- enable : Enable both Questing and Hardcore mode.");
            this.sendChat(sender, "- edit [<playername>] : Give yourself a book in edit mode, playername optional.");
            this.sendChat(sender, "- lives : Check your current lives remaining.");
            this.sendChat(sender, "- lives playercheck <playername>: Check current lives remaining of playername.");
            this.sendChat(sender, "- lives add : 1 live added to your lifepool to <playername>.");
            this.sendChat(sender, "- lives add <amount>: amount of lives added to your lifepool.");
            this.sendChat(sender, "- lives add <playername> <amount>: amount of lives added to lifepool of <playername>.");
            this.sendChat(sender, "- lives remove : 1 live removed from your lifepool.");
            this.sendChat(sender, "- lives remove <amount>: amount of lives remove from your lifepool.");
            this.sendChat(sender, "- lives remove <playername> <amount>: amount of lives removed from lifepool of <playername>.");
            return;
        }
        if (arguments[0].matches("help")) {
            this.sendChat(sender, "Format: '" + this.func_71517_b() + " <command> <arguments>'");
            this.sendChat(sender, "Available commands:");
            this.sendChat(sender, "- version : Version information.");
            this.sendChat(sender, "- lives : Check your current lives remaining.");
            this.sendChat(sender, "- hardcore : Enable Hardcore mode.");
            this.sendChat(sender, "- quest : Enable Questing mode.");
            this.sendChat(sender, "- enable : Enable both Questing and Hardcore mode.");
            return;
        }
        if (arguments[0].matches("version")) {
            this.commandVersion(sender, arguments);
            return;
        }
        if (arguments[0].matches("hardcore") && CommandHandler.isOwnerOrOp(sender)) {
            QuestingData.disableHardcore(sender);
            if (MinecraftServer.func_71276_C().func_130014_f_().func_72912_H().func_76093_s()) {
                this.sendChat(sender, "Vanilla hardcore mode is already enabled. Can't enable Hardcore Mode.");
            } else if (!QuestingData.isHardcoreActive()) {
                this.sendChat(sender, "Hardcore Mode has been activated. Enjoy!");
                QuestingData.activateHardcore();
                if (sender instanceof EntityPlayer) {
                    this.currentLives((EntityPlayer)sender);
                }
            } else {
                this.sendChat(sender, "Hardcore Mode is already activated.");
                if (sender instanceof EntityPlayer) {
                    this.currentLives((EntityPlayer)sender);
                }
            }
            return;
        }
        if (arguments[0].matches("quest") && CommandHandler.isOwnerOrOp(sender)) {
            if (!QuestingData.isQuestActive()) {
                this.sendChat(sender, "Questing mode has been activated. Enjoy!");
                QuestingData.activateQuest();
            } else {
                this.sendChat(sender, "Questing mode is already activated.");
            }
            return;
        }
        if (arguments[0].matches("enable") && CommandHandler.isOwnerOrOp(sender)) {
            System.out.println("ENABLE");
            QuestingData.disableHardcore(sender);
            if (MinecraftServer.func_71276_C().func_130014_f_().func_72912_H().func_76093_s() && !QuestingData.isQuestActive()) {
                this.sendChat(sender, "Vanilla hardcore mode is already enabled. Can't enable Hardcore Mode.");
                this.sendChat(sender, "Questing mode has been activated. Enjoy!");
                QuestingData.activateQuest();
            } else if (MinecraftServer.func_71276_C().func_130014_f_().func_72912_H().func_76093_s() && QuestingData.isQuestActive()) {
                this.sendChat(sender, "Vanilla hardcore mode is already enabled. Can't enable Hardcore Mode.");
                this.sendChat(sender, "Questing mode is already activated.");
            } else if (!QuestingData.isHardcoreActive() && !QuestingData.isQuestActive()) {
                this.sendChat(sender, "Hardcore Mode has been activated. Enjoy!");
                this.sendChat(sender, "Questing mode has been activated. Enjoy!");
                QuestingData.activateHardcore();
                QuestingData.activateQuest();
                if (sender instanceof EntityPlayer) {
                    this.currentLives((EntityPlayer)sender);
                }
            } else if (!QuestingData.isHardcoreActive() && QuestingData.isQuestActive()) {
                this.sendChat(sender, "Hardcore Mode has been activated. Enjoy!");
                QuestingData.activateHardcore();
                if (sender instanceof EntityPlayer) {
                    this.currentLives((EntityPlayer)sender);
                }
                this.sendChat(sender, "Questing mode is already activated.");
            } else if (QuestingData.isHardcoreActive() && !QuestingData.isQuestActive()) {
                this.sendChat(sender, "Questing mode has been activated. Enjoy!");
                QuestingData.activateQuest();
                this.sendChat(sender, "Hardcore Mode is already activated.");
                if (sender instanceof EntityPlayer) {
                    this.currentLives((EntityPlayer)sender);
                }
            } else {
                this.sendChat(sender, "Hardcore Mode is already activated.");
                if (sender instanceof EntityPlayer) {
                    this.currentLives((EntityPlayer)sender);
                }
                this.sendChat(sender, "Questing mode is already activated.");
            }
            return;
        }
        throw new CommandException("commands.generic.permission", new Object[0]);
    }

    private void removeLive(EntityPlayer player) {
        if (QuestingData.getQuestingData(player).getLives() <= QuestingData.getQuestingData(player).getLivesToStayAlive()) {
            this.sendChat((ICommandSender)player, "You currently have " + QuestingData.getQuestingData(player).getLives() + " live remaining, you can't remove any lives.");
        } else {
            QuestingData.getQuestingData(player).removeLives((EntityPlayer)((EntityPlayerMP)player), 1);
            this.sendChat((ICommandSender)player, "You have removed 1 life from your lifepool.");
            this.currentLives(player);
        }
    }

    private void removeLives(EntityPlayer player, int amount) {
        if (QuestingData.getQuestingData(player).getLives() - amount < QuestingData.getQuestingData(player).getLivesToStayAlive()) {
            this.sendChat((ICommandSender)player, "You currently have " + QuestingData.getQuestingData(player).getLives() + " live remaining, you can't remove any lives.");
        } else {
            QuestingData.getQuestingData(player).removeLives((EntityPlayer)((EntityPlayerMP)player), amount);
            this.sendChat((ICommandSender)player, "You have removed " + amount + " live(s) from your lifepool");
            this.currentLives(player);
        }
    }

    private void removeLivesFrom(ICommandSender sender, String playerName, int amount) {
        String playername = playerName;
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(playername);
        QuestingData.getQuestingData((EntityPlayer)player).removeLives((EntityPlayer)((EntityPlayerMP)sender), amount);
        this.sendChat(sender, "You have removed " + amount + " live(s) from " + playerName + "");
        this.sendChat((ICommandSender)player, "You had " + amount + " live(s) removed by " + sender.func_70005_c_() + "");
        this.currentLives((EntityPlayer)player);
    }

    private void addLive(EntityPlayer player) {
        int Max = ModConfig.MAXLIVES;
        if (QuestingData.getQuestingData(player).getRawLives() + 1 <= Max) {
            QuestingData.getQuestingData(player).addLives(player, 1);
            this.sendChat((ICommandSender)player, "You have added 1 life to your lifepool.");
            this.currentLives(player);
        } else {
            QuestingData.getQuestingData(player).addLives(player, 1);
            this.sendChat((ICommandSender)player, "You can't have more than " + Max + " lives.");
            this.currentLives(player);
        }
    }

    private void addLives(EntityPlayer player, int amount) {
        int Max = ModConfig.MAXLIVES;
        if (QuestingData.getQuestingData(player).getRawLives() + amount <= Max) {
            QuestingData.getQuestingData(player).addLives(player, amount);
            this.sendChat((ICommandSender)player, "You have added " + amount + " live(s) to your lifepool");
            this.currentLives(player);
        } else {
            QuestingData.getQuestingData(player).addLives(player, amount);
            this.sendChat((ICommandSender)player, "You can't have more than " + Max + " lives.");
            this.currentLives(player);
        }
    }

    private void addLivesTo(ICommandSender sender, String playerName, int amount) {
        String playername = playerName;
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(playername);
        int Max = ModConfig.MAXLIVES;
        if (QuestingData.getQuestingData((EntityPlayer)player).getRawLives() + amount <= Max) {
            QuestingData.getQuestingData((EntityPlayer)player).addLives((EntityPlayer)player, amount);
            this.sendChat(sender, "You have added " + amount + " live(s) to " + playerName + "");
            this.sendChat((ICommandSender)player, "You had " + amount + " live(s) added by " + sender.func_70005_c_() + "");
            this.currentLives((EntityPlayer)player);
        } else {
            QuestingData.getQuestingData((EntityPlayer)player).addLives((EntityPlayer)player, amount);
            this.sendChat(sender, "You can't give " + playerName + " more than " + Max + " lives.");
            this.sendChat(sender, "Setting " + playerName + " to " + Max + " lives instead.");
            this.sendChat((ICommandSender)player, "You have got your lives set to " + Max + " by " + sender.func_70005_c_() + "");
            this.currentLives((EntityPlayer)player);
        }
    }

    private void getPlayerLives(ICommandSender sender, String playerName) {
        String playername = playerName;
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(playername);
        int lives = QuestingData.getQuestingData((EntityPlayer)player).getLives();
        this.sendChat(sender, "" + playerName + " has " + lives + " live(s) remaining");
    }

    private void sendChat(ICommandSender sender, String string) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(string));
    }

    public boolean isPlayerOp(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(CommandHandler.func_71521_c((ICommandSender)sender).func_146103_bH());
        }
        return true;
    }

    public static boolean isOwnerOrOp(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            GameProfile username = player.func_146103_bH();
            return CommandHandler.isCommandsAllowedOrOwner(username);
        }
        return true;
    }

    public static boolean isCommandsAllowedOrOwner(GameProfile username) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(username) || MinecraftServer.func_71276_C().func_71264_H() && MinecraftServer.func_71276_C().func_71214_G().equals(username);
    }

    private void commandVersion(ICommandSender sender, String[] arguments) {
        String colour = "\u00a7a";
        sender.func_145747_a((IChatComponent)new ChatComponentText(String.format(colour + "Hardcore Questing Mode - Version : %s", "The Journey (4.2.2)")));
    }

    private void currentLives(EntityPlayer player) {
        this.sendChat((ICommandSender)player, "You currently have " + QuestingData.getQuestingData(player).getLives() + " live(s) left.");
    }

    public int compareTo(Object obj) {
        if (obj instanceof ICommand) {
            return this.compareTo((ICommand)obj);
        }
        return 0;
    }
}

