/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.waila;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.blocks.BlockDelivery;
import hardcorequesting.blocks.BlockPortal;
import hardcorequesting.blocks.ModBlocks;
import hardcorequesting.quests.QuestTask;
import hardcorequesting.tileentity.PortalType;
import hardcorequesting.tileentity.TileEntityBarrel;
import hardcorequesting.tileentity.TileEntityPortal;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class Provider
implements IWailaDataProvider {
    private static final String MOD_NAME = "HQM";
    private static final String IS_REMOTE_AVAILABLE = "HQM.showQDS";

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te;
        if (accessor.getBlock() == ModBlocks.itemPortal && (te = accessor.getTileEntity()) instanceof TileEntityPortal) {
            TileEntityPortal portal = (TileEntityPortal)te;
            if (portal.hasTexture(this.getPlayer())) {
                if (portal.getType().isPreset()) {
                    return new ItemStack(ModBlocks.itemPortal, 1, portal.getType() == PortalType.TECH ? 1 : 2);
                }
                return portal.getItem();
            }
            return new ItemStack((Block)null);
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te;
        if (config.getConfig(IS_REMOTE_AVAILABLE) && itemStack != null && itemStack.func_77973_b() == Item.func_150898_a((Block)accessor.getBlock()) && (te = accessor.getTileEntity()) != null && te instanceof TileEntityBarrel) {
            TileEntityBarrel qds = (TileEntityBarrel)te;
            qds.func_145839_a(accessor.getNBTData());
            QuestTask task = qds.getCurrentTask();
            if (task != null && te.func_145832_p() == 1) {
                currenttip.add(qds.getPlayer());
                currenttip.add(task.getParent().getName());
                currenttip.add(task.getDescription());
                currenttip.add((int)(task.getCompletedRatio(qds.getPlayer()) * 100.0f) + "% completed");
            }
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isShiftDown() {
        return GuiScreen.func_146272_n();
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (itemStack.func_77973_b() != Item.func_150898_a((Block)ModBlocks.itemPortal) || itemStack.func_77960_j() > 0) {
            // empty if block
        }
        return currenttip;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        Provider instance = new Provider();
        registrar.registerStackProvider((IWailaDataProvider)instance, BlockPortal.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockDelivery.class);
        registrar.registerSyncedNBTKey("*", BlockDelivery.class);
        registrar.addConfigRemote(MOD_NAME, IS_REMOTE_AVAILABLE, "Show QDS data");
    }
}

