/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.core;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.common.configuration.BOPConfigurationIDs;
import biomesoplenty.common.entities.EntityBird;
import biomesoplenty.common.entities.EntityGlob;
import biomesoplenty.common.entities.EntityJungleSpider;
import biomesoplenty.common.entities.EntityPhantom;
import biomesoplenty.common.entities.EntityPixie;
import biomesoplenty.common.entities.EntityRosester;
import biomesoplenty.common.entities.EntityWasp;
import biomesoplenty.common.entities.projectiles.EntityDart;
import biomesoplenty.common.entities.projectiles.EntityMudball;
import cpw.mods.fml.common.registry.EntityRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;

public class BOPEntities {
    public static int eggIdCounter = 300;

    public static void init() {
        BOPEntities.registerEntities();
    }

    private static void registerEntities() {
        EntityRegistry.registerModEntity(EntityDart.class, (String)"dart", (int)BOPConfigurationIDs.entityDartID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityMudball.class, (String)"mudball", (int)BOPConfigurationIDs.entityMudballID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        if (BOPConfigurationIDs.jungleSpiderID > 0) {
            EntityRegistry.registerModEntity(EntityJungleSpider.class, (String)"JungleSpider", (int)BOPConfigurationIDs.jungleSpiderID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityJungleSpider.class, 5147192, 11013646);
            EntityRegistry.addSpawn(EntityJungleSpider.class, (int)8, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.bambooForest, BiomeGenBase.field_76782_w, BOPCBiomes.tropicalRainforest, BOPCBiomes.oasis, BOPCBiomes.tropics, BOPCBiomes.mangrove, BOPCBiomes.sacredSprings, BOPCBiomes.rainforest});
        }
        if (BOPConfigurationIDs.rosesterID > 0) {
            EntityRegistry.registerModEntity(EntityRosester.class, (String)"Rosester", (int)BOPConfigurationIDs.rosesterID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityRosester.class, 14831439, 16756224);
            EntityRegistry.addSpawn(EntityRosester.class, (int)10, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.garden});
        }
        if (BOPConfigurationIDs.globID > 0) {
            EntityRegistry.registerModEntity(EntityGlob.class, (String)"Glob", (int)BOPConfigurationIDs.globID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityGlob.class, 6836276, 8414787);
            EntityRegistry.addSpawn(EntityGlob.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.deadSwamp, BOPCBiomes.fen, BOPCBiomes.moor, BOPCBiomes.quagmire, BOPCBiomes.sludgepit, BiomeGenBase.field_76780_h});
        }
        if (BOPConfigurationIDs.phantomID > 0) {
            EntityRegistry.registerModEntity(EntityPhantom.class, (String)"Phantom", (int)BOPConfigurationIDs.phantomID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityPhantom.class, 4472140, 2499368);
            if (BOPCBiomes.boneyard != null && BOPCBiomes.corruptedSands != null) {
                EntityRegistry.addSpawn(EntityPhantom.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.boneyard, BOPCBiomes.corruptedSands});
            }
        }
        if (BOPConfigurationIDs.waspID > 0) {
            EntityRegistry.registerModEntity(EntityWasp.class, (String)"Wasp", (int)BOPConfigurationIDs.waspID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityWasp.class, 16434729, 0x262627);
        }
        if (BOPConfigurationIDs.birdID > 0) {
            EntityRegistry.registerModEntity(EntityBird.class, (String)"Bird", (int)BOPConfigurationIDs.birdID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityBird.class, 5277691, 16772788);
        }
        if (BOPConfigurationIDs.pixieID > 0) {
            EntityRegistry.registerModEntity(EntityPixie.class, (String)"Pixie", (int)BOPConfigurationIDs.pixieID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
            BOPEntities.registerEntityEgg(EntityPixie.class, 0xFF77DD, 16645116);
            EntityRegistry.addSpawn(EntityPixie.class, (int)8, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.ambient, (BiomeGenBase[])new BiomeGenBase[]{BOPCBiomes.mysticGrove});
        }
    }

    public static void registerEntityEgg(Class<? extends Entity> entity, int primaryColor, int secondaryColor) {
        int id = BOPEntities.getUniqueEntityEggId();
        EntityList.field_75623_d.put(id, entity);
        EntityList.field_75627_a.put(id, new EntityList.EntityEggInfo(id, primaryColor, secondaryColor));
    }

    public static int getUniqueEntityEggId() {
        while (EntityList.func_75617_a((int)(++eggIdCounter)) != null) {
        }
        return eggIdCounter;
    }
}

