/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.utils.remote;

import biomesoplenty.common.utils.BOPLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

public abstract class RemoteIdentifierManager {
    protected String serverLocation;
    protected HashMap<String, String> identifierMap = new HashMap();
    protected final int timeout = 1000;

    protected RemoteIdentifierManager(String serverLocation) {
        this.serverLocation = serverLocation;
        this.retrieve();
    }

    protected void retrieve() {
        try {
            String line;
            URL url = new URL(this.serverLocation);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(1000);
            InputStream io = connection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(io));
            int linetracker = 1;
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.startsWith("//") && !line.isEmpty()) {
                    if (line.contains(":")) {
                        String key = line.substring(0, line.indexOf(":"));
                        String value = line.substring(line.indexOf(":") + 1);
                        this.identifierMap.put(key, value);
                    } else {
                        BOPLogger.log(Level.WARN, "[" + this.getFileName() + ".txt] Syntax error on line " + linetracker + ": " + line, new Object[0]);
                    }
                }
                ++linetracker;
            }
            bufferedReader.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFileName() {
        return FilenameUtils.getBaseName((String)this.serverLocation);
    }
}

