/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat;

import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.core.BCLog;
import buildcraft.compat.CompatModuleBase;
import buildcraft.compat.CompatUtils;
import buildcraft.compat.immibis.FakeWorldIMTesting;
import buildcraft.compat.immibis.SchematicTileMicroblocks;
import buildcraft.compat.immibis.SchematicTileMicroblocksBase;
import buildcraft.core.blueprints.SchematicRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import java.util.Set;
import mods.immibis.core.api.multipart.ICoverableTile;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class CompatModuleImmibisMicroblocks
extends CompatModuleBase {
    @Override
    public String name() {
        return "ImmibisMicroblocks";
    }

    @Override
    public boolean canLoad() {
        return super.canLoad() && Loader.isModLoaded((String)"BuildCraft|Builders");
    }

    @Override
    public void init() {
        if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
            CompatUtils.registerSchematic("ImmibisMicroblocks:MicroblockContainer", SchematicTileMicroblocksBase.class, new Object[0]);
        }
    }

    @Override
    public void postInit() {
        if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
            this.patchBuilders();
        }
    }

    @Optional.Method(modid="BuildCraft|Builders")
    private void patchBuilders() {
        FakeWorldIMTesting test = new FakeWorldIMTesting();
        Set ss = SchematicRegistry.INSTANCE.schematicBlocks.keySet();
        for (String s : ss.toArray(new String[ss.size()])) {
            Class clazz = ((SchematicRegistry.SchematicConstructor)SchematicRegistry.INSTANCE.schematicBlocks.get((Object)s)).clazz;
            if (clazz == SchematicTileMicroblocks.class || !SchematicTile.class.isAssignableFrom(clazz)) continue;
            String name = s.substring(0, s.lastIndexOf(":"));
            int meta = new Integer(s.substring(s.lastIndexOf(":") + 1));
            Block b = Block.func_149684_b((String)name);
            if (b == null || meta < 0 || meta >= 16) continue;
            boolean isImmibis = false;
            if (b.hasTileEntity(meta)) {
                try {
                    isImmibis = b.createTileEntity((World)test, meta) instanceof ICoverableTile;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isImmibis) continue;
            BCLog.logger.info("[BCCompat|ImmibisMicroblocks] Patching " + s);
            SchematicRegistry.SchematicConstructor c = (SchematicRegistry.SchematicConstructor)SchematicRegistry.INSTANCE.schematicBlocks.get(s);
            SchematicRegistry.INSTANCE.schematicBlocks.remove(s);
            SchematicRegistry.INSTANCE.registerSchematicBlock(b, meta, SchematicTileMicroblocks.class, new Object[]{c});
        }
    }
}

