/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.IWorldProperty;
import buildcraft.api.crops.CropManager;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.api.tablet.TabletAPI;
import buildcraft.api.tiles.IControllable;
import buildcraft.core.AchievementManager;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.BlockBuildTool;
import buildcraft.core.BlockEngine;
import buildcraft.core.BlockSpring;
import buildcraft.core.CompatHooks;
import buildcraft.core.CoreGuiHandler;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.CoreSiliconRecipes;
import buildcraft.core.InterModComms;
import buildcraft.core.ItemDebugger;
import buildcraft.core.ItemGear;
import buildcraft.core.ItemList;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.ItemPaintbrush;
import buildcraft.core.ItemSpring;
import buildcraft.core.ItemWrench;
import buildcraft.core.SchematicEngine;
import buildcraft.core.SpringPopulate;
import buildcraft.core.TickHandlerCore;
import buildcraft.core.TileEngineWood;
import buildcraft.core.Version;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.builders.patterns.FillerRegistry;
import buildcraft.core.builders.patterns.PatternBox;
import buildcraft.core.builders.patterns.PatternClear;
import buildcraft.core.builders.patterns.PatternCylinder;
import buildcraft.core.builders.patterns.PatternFill;
import buildcraft.core.builders.patterns.PatternFlatten;
import buildcraft.core.builders.patterns.PatternFrame;
import buildcraft.core.builders.patterns.PatternHorizon;
import buildcraft.core.builders.patterns.PatternParameterCenter;
import buildcraft.core.builders.patterns.PatternParameterHollow;
import buildcraft.core.builders.patterns.PatternParameterXZDir;
import buildcraft.core.builders.patterns.PatternParameterYDir;
import buildcraft.core.builders.patterns.PatternPyramid;
import buildcraft.core.builders.patterns.PatternStairs;
import buildcraft.core.command.SubCommandChangelog;
import buildcraft.core.command.SubCommandVersion;
import buildcraft.core.config.BuildCraftConfiguration;
import buildcraft.core.config.ConfigManager;
import buildcraft.core.crops.CropHandlerPlantable;
import buildcraft.core.crops.CropHandlerReeds;
import buildcraft.core.lib.commands.RootCommand;
import buildcraft.core.lib.engines.ItemEngine;
import buildcraft.core.lib.network.ChannelHandler;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.lib.utils.XorShift128Random;
import buildcraft.core.network.PacketHandlerCore;
import buildcraft.core.properties.WorldPropertyIsDirt;
import buildcraft.core.properties.WorldPropertyIsFarmland;
import buildcraft.core.properties.WorldPropertyIsFluidSource;
import buildcraft.core.properties.WorldPropertyIsHarvestable;
import buildcraft.core.properties.WorldPropertyIsLeaf;
import buildcraft.core.properties.WorldPropertyIsOre;
import buildcraft.core.properties.WorldPropertyIsShoveled;
import buildcraft.core.properties.WorldPropertyIsSoft;
import buildcraft.core.properties.WorldPropertyIsWood;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.core.recipes.IntegrationRecipeManager;
import buildcraft.core.recipes.ProgrammingRecipeManager;
import buildcraft.core.recipes.RefineryRecipeManager;
import buildcraft.core.render.BlockHighlightHandler;
import buildcraft.core.render.RenderLEDTile;
import buildcraft.core.statements.ActionMachineControl;
import buildcraft.core.statements.ActionRedstoneOutput;
import buildcraft.core.statements.DefaultActionProvider;
import buildcraft.core.statements.DefaultTriggerProvider;
import buildcraft.core.statements.StatementParameterDirection;
import buildcraft.core.statements.StatementParameterRedstoneGateSideOnly;
import buildcraft.core.statements.TriggerEnergy;
import buildcraft.core.statements.TriggerFluidContainer;
import buildcraft.core.statements.TriggerFluidContainerLevel;
import buildcraft.core.statements.TriggerInventory;
import buildcraft.core.statements.TriggerInventoryLevel;
import buildcraft.core.statements.TriggerMachine;
import buildcraft.core.statements.TriggerRedstoneInput;
import buildcraft.core.tablet.ItemTablet;
import buildcraft.core.tablet.PacketTabletMessage;
import buildcraft.core.tablet.TabletProgramMenuFactory;
import buildcraft.core.tablet.manager.TabletManagerClient;
import buildcraft.core.tablet.manager.TabletManagerServer;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.oredict.OreDictionary;

@Mod(name="BuildCraft", version="7.0.21", useMetadata=false, modid="BuildCraft|Core", acceptedMinecraftVersions="[1.7.10,1.8)", dependencies="required-after:Forge@[10.13.2.1236,)", guiFactory="buildcraft.core.config.ConfigManager")
public class BuildCraftCore
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Core")
    public static BuildCraftCore instance;
    public static final boolean NONRELEASED_BLOCKS = true;
    public static final boolean TABLET_TESTING = false;
    public static RootCommand commandBuildcraft;
    public static XorShift128Random random;
    public static RenderMode render;
    public static boolean debugWorldgen;
    public static boolean modifyWorld;
    public static boolean colorBlindMode;
    public static boolean hidePowerNumbers;
    public static boolean hideFluidNumbers;
    public static boolean canEnginesExplode;
    public static int itemLifespan;
    public static int updateFactor;
    public static long longUpdateFactor;
    public static BuildCraftConfiguration mainConfiguration;
    public static ConfigManager mainConfigManager;
    public static BlockEngine engineBlock;
    public static Block springBlock;
    public static BlockBuildTool buildToolBlock;
    public static Item woodenGearItem;
    public static Item stoneGearItem;
    public static Item ironGearItem;
    public static Item goldGearItem;
    public static Item diamondGearItem;
    public static Item wrenchItem;
    public static Item mapLocationItem;
    public static Item debuggerItem;
    public static Item paintbrushItem;
    public static ItemList listItem;
    public static ItemTablet tabletItem;
    @SideOnly(value=Side.CLIENT)
    public static IIcon redLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon blueLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon stripesLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon transparentTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIconProvider iconProvider;
    public static int blockByEntityModel;
    public static int complexBlockModel;
    public static int legacyPipeModel;
    public static int markerModel;
    public static ITriggerExternal triggerMachineActive;
    public static ITriggerExternal triggerMachineInactive;
    public static IStatement triggerEnergyHigh;
    public static IStatement triggerEnergyLow;
    public static ITriggerExternal triggerEmptyInventory;
    public static ITriggerExternal triggerContainsInventory;
    public static ITriggerExternal triggerSpaceInventory;
    public static ITriggerExternal triggerFullInventory;
    public static ITriggerExternal triggerEmptyFluid;
    public static ITriggerExternal triggerContainsFluid;
    public static ITriggerExternal triggerSpaceFluid;
    public static ITriggerExternal triggerFullFluid;
    public static ITriggerInternal triggerRedstoneActive;
    public static ITriggerInternal triggerRedstoneInactive;
    public static ITriggerExternal triggerInventoryBelow25;
    public static ITriggerExternal triggerInventoryBelow50;
    public static ITriggerExternal triggerInventoryBelow75;
    public static ITriggerExternal triggerFluidContainerBelow25;
    public static ITriggerExternal triggerFluidContainerBelow50;
    public static ITriggerExternal triggerFluidContainerBelow75;
    public static IActionInternal actionRedstone;
    public static IActionExternal[] actionControl;
    public static boolean loadDefaultRecipes;
    public static boolean consumeWaterSources;
    public static float miningMultiplier;
    public static AchievementManager achievementManager;
    public static Achievement woodenGearAchievement;
    public static Achievement stoneGearAchievement;
    public static Achievement ironGearAchievement;
    public static Achievement goldGearAchievement;
    public static Achievement diamondGearAchievement;
    public static Achievement wrenchAchievement;
    public static Achievement engineRedstoneAchievement;
    public static float diffX;
    public static float diffY;
    public static float diffZ;
    public static GameProfile gameProfile;
    private static FloatBuffer modelviewF;
    private static FloatBuffer projectionF;
    private static IntBuffer viewport;
    private static FloatBuffer pos;

    @Mod.EventHandler
    public void loadConfiguration(FMLPreInitializationEvent evt) {
        BCLog.initLog();
        new BCCreativeTab("main");
        commandBuildcraft.addAlias("bc");
        commandBuildcraft.addChildCommand(new SubCommandVersion());
        commandBuildcraft.addChildCommand(new SubCommandChangelog());
        BuildcraftRecipeRegistry.assemblyTable = AssemblyRecipeManager.INSTANCE;
        BuildcraftRecipeRegistry.integrationTable = IntegrationRecipeManager.INSTANCE;
        BuildcraftRecipeRegistry.refinery = RefineryRecipeManager.INSTANCE;
        BuildcraftRecipeRegistry.programmingTable = ProgrammingRecipeManager.INSTANCE;
        BuilderAPI.schematicRegistry = SchematicRegistry.INSTANCE;
        mainConfiguration = new BuildCraftConfiguration(new File(evt.getModConfigurationDirectory(), "buildcraft/main.cfg"));
        mainConfigManager = new ConfigManager(mainConfiguration);
        mainConfiguration.load();
        mainConfigManager.getCat("debug").setShowInGui(false);
        mainConfigManager.getCat("vars").setShowInGui(false);
        mainConfigManager.register("general.updateCheck", true, "Should I check the BuildCraft version on startup?", ConfigManager.RestartRequirement.NONE);
        mainConfigManager.register("display.hidePowerValues", false, "Should all power values (RF, RF/t) be hidden?", ConfigManager.RestartRequirement.NONE);
        mainConfigManager.register("display.hideFluidValues", false, "Should all fluid values (mB, mB/t) be hidden?", ConfigManager.RestartRequirement.NONE);
        mainConfigManager.register("general.itemLifespan", 60, "How long, in seconds, should items stay on the ground? (Vanilla = 300, default = 60)", ConfigManager.RestartRequirement.NONE).setMinValue(5);
        mainConfigManager.register("network.updateFactor", 10, "How often, in ticks, should network update packets be sent? Increasing this might help network performance.", ConfigManager.RestartRequirement.GAME).setMinValue(1);
        mainConfigManager.register("network.longUpdateFactor", 40, "How often, in ticks, should full network sync packets be sent? Increasing this might help network performance.", ConfigManager.RestartRequirement.GAME).setMinValue(1);
        mainConfigManager.register("general.canEnginesExplode", false, "Should engines explode upon overheat?", ConfigManager.RestartRequirement.NONE);
        mainConfigManager.register("worldgen.enable", true, "Should BuildCraft generate anything in the world?", ConfigManager.RestartRequirement.GAME);
        mainConfigManager.register("general.pumpsConsumeWater", false, "Should pumps consume water? Enabling this might cause performance issues!", ConfigManager.RestartRequirement.NONE);
        mainConfigManager.register("power.miningUsageMultiplier", 1.0, "What should the multiplier of all mining-related power usage be?", ConfigManager.RestartRequirement.NONE);
        mainConfigManager.register("display.colorBlindMode", false, "Should I enable colorblind mode?", ConfigManager.RestartRequirement.GAME);
        mainConfigManager.register("worldgen.generateWaterSprings", true, "Should BuildCraft generate water springs?", ConfigManager.RestartRequirement.GAME);
        this.reloadConfig(ConfigManager.RestartRequirement.GAME);
        wrenchItem = new ItemWrench().func_77655_b("wrenchItem");
        CoreProxy.proxy.registerItem(wrenchItem);
        mapLocationItem = new ItemMapLocation().func_77655_b("mapLocation");
        CoreProxy.proxy.registerItem(mapLocationItem);
        listItem = (ItemList)new ItemList().func_77655_b("list");
        CoreProxy.proxy.registerItem(listItem);
        debuggerItem = new ItemDebugger().func_77655_b("debugger");
        CoreProxy.proxy.registerItem(debuggerItem);
        if (modifyWorld) {
            BlockSpring.EnumSpring.WATER.canGen = mainConfigManager.get("worldgen.generateWaterSprings").getBoolean();
            springBlock = new BlockSpring().func_149663_c("eternalSpring");
            CoreProxy.proxy.registerBlock(springBlock, ItemSpring.class);
        }
        woodenGearItem = new ItemGear().func_77655_b("woodenGearItem");
        CoreProxy.proxy.registerItem(woodenGearItem);
        OreDictionary.registerOre((String)"gearWood", (ItemStack)new ItemStack(woodenGearItem));
        stoneGearItem = new ItemGear().func_77655_b("stoneGearItem");
        CoreProxy.proxy.registerItem(stoneGearItem);
        OreDictionary.registerOre((String)"gearStone", (ItemStack)new ItemStack(stoneGearItem));
        ironGearItem = new ItemGear().func_77655_b("ironGearItem");
        CoreProxy.proxy.registerItem(ironGearItem);
        OreDictionary.registerOre((String)"gearIron", (ItemStack)new ItemStack(ironGearItem));
        goldGearItem = new ItemGear().func_77655_b("goldGearItem");
        CoreProxy.proxy.registerItem(goldGearItem);
        OreDictionary.registerOre((String)"gearGold", (ItemStack)new ItemStack(goldGearItem));
        diamondGearItem = new ItemGear().func_77655_b("diamondGearItem");
        CoreProxy.proxy.registerItem(diamondGearItem);
        OreDictionary.registerOre((String)"gearDiamond", (ItemStack)new ItemStack(diamondGearItem));
        paintbrushItem = new ItemPaintbrush().func_77655_b("paintbrush");
        CoreProxy.proxy.registerItem(paintbrushItem);
        buildToolBlock = new BlockBuildTool();
        buildToolBlock.func_149663_c("buildToolBlock");
        CoreProxy.proxy.registerBlock(buildToolBlock);
        engineBlock = (BlockEngine)CompatHooks.INSTANCE.getBlock(BlockEngine.class);
        CoreProxy.proxy.registerBlock((Block)engineBlock, ItemEngine.class);
        engineBlock.registerTile(CompatHooks.INSTANCE.getTile(TileEngineWood.class), "tile.engineWood");
        CoreProxy.proxy.registerTileEntity(TileEngineWood.class, "net.minecraft.src.buildcraft.energy.TileEngineWood");
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new BlockHighlightHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        BuildCraftAPI.proxy = CoreProxy.proxy;
        ChannelHandler coreChannelHandler = new ChannelHandler();
        coreChannelHandler.registerPacketType(PacketTabletMessage.class);
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-CORE", new io.netty.channel.ChannelHandler[]{coreChannelHandler, new PacketHandlerCore()});
        achievementManager = new AchievementManager("BuildCraft");
        FMLCommonHandler.instance().bus().register((Object)achievementManager);
        woodenGearAchievement = achievementManager.registerAchievement(new Achievement("achievement.woodenGear", "woodenGearAchievement", 0, 0, woodenGearItem, null));
        stoneGearAchievement = achievementManager.registerAchievement(new Achievement("achievement.stoneGear", "stoneGearAchievement", 2, 0, stoneGearItem, woodenGearAchievement));
        ironGearAchievement = achievementManager.registerAchievement(new Achievement("achievement.ironGear", "ironGearAchievement", 4, 0, ironGearItem, stoneGearAchievement));
        goldGearAchievement = achievementManager.registerAchievement(new Achievement("achievement.goldGear", "goldGearAchievement", 6, 0, goldGearItem, ironGearAchievement));
        diamondGearAchievement = achievementManager.registerAchievement(new Achievement("achievement.diamondGear", "diamondGearAchievement", 8, 0, diamondGearItem, goldGearAchievement));
        wrenchAchievement = achievementManager.registerAchievement(new Achievement("achievement.wrench", "wrenchAchievement", 3, 2, wrenchItem, stoneGearAchievement));
        engineRedstoneAchievement = achievementManager.registerAchievement(new Achievement("achievement.redstoneEngine", "engineAchievement1", 1, -2, new ItemStack((Block)engineBlock, 1, 0), woodenGearAchievement));
        StatementManager.registerParameterClass("buildcraft:stackTrigger", StatementParameterItemStack.class);
        StatementManager.registerParameterClass("buildcraft:stackAction", StatementParameterItemStack.class);
        StatementManager.registerParameterClass(StatementParameterItemStack.class);
        StatementManager.registerParameterClass(StatementParameterDirection.class);
        StatementManager.registerParameterClass(StatementParameterRedstoneGateSideOnly.class);
        StatementManager.registerTriggerProvider(new DefaultTriggerProvider());
        StatementManager.registerActionProvider(new DefaultActionProvider());
        if (modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)new SpringPopulate());
        }
        if (mainConfiguration.hasChanged()) {
            mainConfiguration.save();
        }
        if (loadDefaultRecipes) {
            this.loadRecipes();
        }
        BCCreativeTab.get("main").setIcon(new ItemStack(wrenchItem, 1));
        EntityList.field_75625_b.remove("BuildCraft|Core.bcLaser");
        EntityList.field_75625_b.remove("BuildCraft|Core.bcEnergyLaser");
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)engineBlock, SchematicEngine.class, new Object[0]);
        CoreProxy.proxy.initializeRendering();
        CoreProxy.proxy.initializeEntityRendering();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new CoreGuiHandler());
        FMLCommonHandler.instance().bus().register((Object)TabletManagerClient.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)TabletManagerServer.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TabletManagerClient.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TabletManagerServer.INSTANCE);
        TabletAPI.registerProgram(new TabletProgramMenuFactory());
        try {
            FillerManager.registry = new FillerRegistry();
            FillerManager.registry.addPattern(PatternFill.INSTANCE);
            FillerManager.registry.addPattern(new PatternFlatten());
            FillerManager.registry.addPattern(new PatternHorizon());
            FillerManager.registry.addPattern(new PatternClear());
            FillerManager.registry.addPattern(new PatternBox());
            FillerManager.registry.addPattern(new PatternPyramid());
            FillerManager.registry.addPattern(new PatternStairs());
            FillerManager.registry.addPattern(new PatternCylinder());
            FillerManager.registry.addPattern(new PatternFrame());
        }
        catch (Error error) {
            BCLog.logErrorAPI("Buildcraft", error, IFillerPattern.class);
            throw error;
        }
        StatementManager.registerParameterClass(PatternParameterYDir.class);
        StatementManager.registerParameterClass(PatternParameterXZDir.class);
        StatementManager.registerParameterClass(PatternParameterCenter.class);
        StatementManager.registerParameterClass(PatternParameterHollow.class);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        BCLog.logger.info("BuildCraft's fake player: UUID = " + gameProfile.getId().toString() + ", name = '" + gameProfile.getName() + "'!");
        for (Object o : Block.field_149771_c) {
            Block block = (Block)o;
            if (!(block instanceof BlockFluidBase) && !(block instanceof BlockLiquid) && !(block instanceof IPlantable)) continue;
            BuildCraftAPI.softBlocks.add(block);
        }
        BuildCraftAPI.softBlocks.add(Blocks.field_150433_aE);
        BuildCraftAPI.softBlocks.add(Blocks.field_150395_bd);
        BuildCraftAPI.softBlocks.add((Block)Blocks.field_150480_ab);
        FMLCommonHandler.instance().bus().register((Object)new TickHandlerCore());
        CropManager.setDefaultHandler(new CropHandlerPlantable());
        CropManager.registerHandler(new CropHandlerReeds());
        BuildCraftAPI.registerWorldProperty("soft", new WorldPropertyIsSoft());
        BuildCraftAPI.registerWorldProperty("wood", new WorldPropertyIsWood());
        BuildCraftAPI.registerWorldProperty("leaves", new WorldPropertyIsLeaf());
        for (int i = 0; i < 4; ++i) {
            BuildCraftAPI.registerWorldProperty("ore@hardness=" + i, new WorldPropertyIsOre(i));
        }
        BuildCraftAPI.registerWorldProperty("harvestable", new WorldPropertyIsHarvestable());
        BuildCraftAPI.registerWorldProperty("farmland", new WorldPropertyIsFarmland());
        BuildCraftAPI.registerWorldProperty("shoveled", new WorldPropertyIsShoveled());
        BuildCraftAPI.registerWorldProperty("dirt", new WorldPropertyIsDirt());
        BuildCraftAPI.registerWorldProperty("fluidSource", new WorldPropertyIsFluidSource());
        ColorUtils.initialize();
        actionControl = new IActionExternal[IControllable.Mode.values().length];
        for (IControllable.Mode mode : IControllable.Mode.values()) {
            if (mode == IControllable.Mode.Unknown || mode == IControllable.Mode.Mode) continue;
            BuildCraftCore.actionControl[mode.ordinal()] = new ActionMachineControl(mode);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)commandBuildcraft);
        if (Utils.CAULDRON_DETECTED) {
            BCLog.logger.warn("############################################");
            BCLog.logger.warn("#                                          #");
            BCLog.logger.warn("#  Cauldron has been detected! Please keep #");
            BCLog.logger.warn("# in mind that BuildCraft does NOT support #");
            BCLog.logger.warn("#   Cauldron and we do not promise to fix  #");
            BCLog.logger.warn("#  bugs caused by its modifications to the #");
            BCLog.logger.warn("#   Minecraft engine. Please reconsider.   #");
            BCLog.logger.warn("#                                          #");
            BCLog.logger.warn("#  Any lag caused by BuildCraft on top of  #");
            BCLog.logger.warn("# Cauldron likely arises from our fixes to #");
            BCLog.logger.warn("#  their bugs, so please don't report that #");
            BCLog.logger.warn("#  either. Thanks for your attention! ~BC  #");
            BCLog.logger.warn("#                                          #");
            BCLog.logger.warn("############################################");
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        TabletManagerClient.INSTANCE.onServerStopping();
        TabletManagerServer.INSTANCE.onServerStopping();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        for (FillerPattern pattern : FillerPattern.patterns.values()) {
            pattern.registerIcons((IIconRegister)event.map);
        }
        if (event.map.func_130086_a() == 1) {
            iconProvider = new CoreIconProvider();
            iconProvider.registerIcons((IIconRegister)event.map);
            StatementManager.registerIcons((IIconRegister)event.map);
        } else if (event.map.func_130086_a() == 0) {
            redLaserTexture = event.map.func_94245_a("buildcraftcore:laserBox/blockRedLaser");
            blueLaserTexture = event.map.func_94245_a("buildcraftcore:laserBox/blockBlueLaser");
            stripesLaserTexture = event.map.func_94245_a("buildcraftcore:laserBox/blockStripesLaser");
            transparentTexture = event.map.func_94245_a("buildcraftcore:misc/transparent");
            RenderLEDTile.registerBlockIcons((IIconRegister)event.map);
        }
    }

    public void reloadConfig(ConfigManager.RestartRequirement restartType) {
        if (restartType == ConfigManager.RestartRequirement.GAME) {
            modifyWorld = mainConfigManager.get("worldgen.enable").getBoolean();
            updateFactor = mainConfigManager.get("network.updateFactor").getInt();
            longUpdateFactor = mainConfigManager.get("network.longUpdateFactor").getInt();
            colorBlindMode = mainConfigManager.get("display.colorBlindMode").getBoolean();
            this.reloadConfig(ConfigManager.RestartRequirement.WORLD);
        } else if (restartType == ConfigManager.RestartRequirement.WORLD) {
            this.reloadConfig(ConfigManager.RestartRequirement.NONE);
        } else {
            hideFluidNumbers = mainConfigManager.get("display.hideFluidValues").getBoolean();
            hidePowerNumbers = mainConfigManager.get("display.hidePowerValues").getBoolean();
            itemLifespan = mainConfigManager.get("general.itemLifespan").getInt();
            canEnginesExplode = mainConfigManager.get("general.canEnginesExplode").getBoolean();
            consumeWaterSources = mainConfigManager.get("general.pumpsConsumeWater").getBoolean();
            miningMultiplier = (float)mainConfigManager.get("power.miningUsageMultiplier").getDouble();
            if (mainConfigManager.get("general.updateCheck").getBoolean(true)) {
                Version.check();
            }
            if (mainConfiguration.hasChanged()) {
                mainConfiguration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("BuildCraft|Core".equals(event.modID)) {
            this.reloadConfig(event.isWorldRunning ? ConfigManager.RestartRequirement.NONE : ConfigManager.RestartRequirement.WORLD);
        }
    }

    public void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(wrenchItem), "I I", " G ", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gearStone");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(woodenGearItem), " S ", "S S", " S ", Character.valueOf('S'), "stickWood");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(stoneGearItem), " I ", "IGI", " I ", Character.valueOf('I'), "cobblestone", Character.valueOf('G'), "gearWood");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(ironGearItem), " I ", "IGI", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "gearStone");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(goldGearItem), " I ", "IGI", " I ", Character.valueOf('I'), "ingotGold", Character.valueOf('G'), "gearIron");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(diamondGearItem), " I ", "IGI", " I ", Character.valueOf('I'), "gemDiamond", Character.valueOf('G'), "gearGold");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(mapLocationItem), "ppp", "pYp", "ppp", Character.valueOf('p'), Items.field_151121_aF, Character.valueOf('Y'), "dyeYellow");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 0), "www", " g ", "GpG", Character.valueOf('w'), "plankWood", Character.valueOf('g'), "blockGlass", Character.valueOf('G'), "gearWood", Character.valueOf('p'), Blocks.field_150331_J);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(paintbrushItem), " iw", " gi", "s  ", Character.valueOf('s'), "stickWood", Character.valueOf('g'), "gearWood", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, 0), Character.valueOf('i'), Items.field_151007_F);
        ItemStack anyPaintbrush = new ItemStack(paintbrushItem, 1, Short.MAX_VALUE);
        for (int i = 0; i < 16; ++i) {
            ItemStack outputStack = new ItemStack(paintbrushItem);
            NBTUtils.getItemData(outputStack).func_74774_a("color", (byte)i);
            CoreProxy.proxy.addShapelessRecipe(outputStack, anyPaintbrush, EnumColor.fromId(i).getDye());
        }
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            CoreSiliconRecipes.loadSiliconRecipes();
        } else {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)listItem), "ppp", "pYp", "ppp", Character.valueOf('p'), Items.field_151121_aF, Character.valueOf('Y'), "dyeGreen");
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderLast(RenderWorldLastEvent evt) {
    }

    @SubscribeEvent
    public void cleanRegistries(WorldEvent.Unload unload) {
        for (IWorldProperty property : BuildCraftAPI.worldProperties.values()) {
            property.clear();
        }
    }

    static {
        commandBuildcraft = new RootCommand("buildcraft");
        random = new XorShift128Random();
        render = RenderMode.Full;
        debugWorldgen = false;
        modifyWorld = false;
        colorBlindMode = false;
        hidePowerNumbers = false;
        hideFluidNumbers = false;
        canEnginesExplode = false;
        itemLifespan = 1200;
        updateFactor = 10;
        longUpdateFactor = 40L;
        triggerMachineActive = new TriggerMachine(true);
        triggerMachineInactive = new TriggerMachine(false);
        triggerEnergyHigh = new TriggerEnergy(true);
        triggerEnergyLow = new TriggerEnergy(false);
        triggerEmptyInventory = new TriggerInventory(TriggerInventory.State.Empty);
        triggerContainsInventory = new TriggerInventory(TriggerInventory.State.Contains);
        triggerSpaceInventory = new TriggerInventory(TriggerInventory.State.Space);
        triggerFullInventory = new TriggerInventory(TriggerInventory.State.Full);
        triggerEmptyFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Empty);
        triggerContainsFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Contains);
        triggerSpaceFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Space);
        triggerFullFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Full);
        triggerRedstoneActive = new TriggerRedstoneInput(true);
        triggerRedstoneInactive = new TriggerRedstoneInput(false);
        triggerInventoryBelow25 = new TriggerInventoryLevel(TriggerInventoryLevel.TriggerType.BELOW25);
        triggerInventoryBelow50 = new TriggerInventoryLevel(TriggerInventoryLevel.TriggerType.BELOW50);
        triggerInventoryBelow75 = new TriggerInventoryLevel(TriggerInventoryLevel.TriggerType.BELOW75);
        triggerFluidContainerBelow25 = new TriggerFluidContainerLevel(TriggerFluidContainerLevel.TriggerType.BELOW25);
        triggerFluidContainerBelow50 = new TriggerFluidContainerLevel(TriggerFluidContainerLevel.TriggerType.BELOW50);
        triggerFluidContainerBelow75 = new TriggerFluidContainerLevel(TriggerFluidContainerLevel.TriggerType.BELOW75);
        actionRedstone = new ActionRedstoneOutput();
        loadDefaultRecipes = true;
        consumeWaterSources = false;
        gameProfile = new GameProfile(UUID.nameUUIDFromBytes("buildcraft.core".getBytes()), "[BuildCraft]");
        pos = ByteBuffer.allocateDirect(12).asFloatBuffer();
    }

    public static enum RenderMode {
        Full,
        NoDynamic;

    }
}

