/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.builders.blueprints.RecursiveBlueprintReader;
import buildcraft.core.Box;
import buildcraft.core.LaserData;
import buildcraft.core.blueprints.BlueprintReadConfiguration;
import buildcraft.core.internal.IBoxProvider;
import buildcraft.core.internal.ILEDProvider;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileArchitect
extends TileBuildCraft
implements IInventory,
IBoxProvider,
ICommandReceiver,
ILEDProvider {
    public String currentAuthorName = "";
    public Box box = new Box();
    public String name = "";
    public BlueprintReadConfiguration readConfiguration = new BlueprintReadConfiguration();
    public LinkedList<LaserData> subLasers = new LinkedList();
    public ArrayList<BlockIndex> subBlueprints = new ArrayList();
    private SimpleInventory inv = new SimpleInventory(2, "Architect", 1);
    private RecursiveBlueprintReader reader;
    private boolean isProcessing;

    public TileArchitect() {
        this.box.kind = Box.Kind.BLUE_STRIPES;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.reader != null) {
            this.reader.iterate();
            if (this.reader.isDone()) {
                this.reader = null;
                this.isProcessing = false;
                this.sendNetworkUpdate();
            }
        }
    }

    @Override
    public void initialize() {
        IAreaProvider a;
        super.initialize();
        if (!this.field_145850_b.field_72995_K && !this.box.isInitialized() && (a = Utils.getNearbyAreaProvider(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) != null) {
            this.box.initialize(a);
            a.removeFromWorld();
            this.sendNetworkUpdate();
        }
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = this.inv.func_70298_a(i, j);
        if (i == 0) {
            this.initializeComputing();
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        if (i == 0) {
            this.initializeComputing();
        }
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "Template";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("box")) {
            this.box.initialize(nbt.func_74775_l("box"));
        }
        this.inv.readFromNBT(nbt);
        this.name = nbt.func_74779_i("name");
        this.currentAuthorName = nbt.func_74779_i("lastAuthor");
        if (nbt.func_74764_b("readConfiguration")) {
            this.readConfiguration.readFromNBT(nbt.func_74775_l("readConfiguration"));
        }
        NBTTagList subBptList = nbt.func_150295_c("subBlueprints", 10);
        for (int i = 0; i < subBptList.func_74745_c(); ++i) {
            BlockIndex index = new BlockIndex(subBptList.func_150305_b(i));
            this.addSubBlueprint(index);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbt.func_74782_a("box", (NBTBase)boxStore);
        }
        this.inv.writeToNBT(nbt);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("lastAuthor", this.currentAuthorName);
        NBTTagCompound readConf = new NBTTagCompound();
        this.readConfiguration.writeToNBT(readConf);
        nbt.func_74782_a("readConfiguration", (NBTBase)readConf);
        NBTTagList subBptList = new NBTTagList();
        for (BlockIndex b : this.subBlueprints) {
            NBTTagCompound subBpt = new NBTTagCompound();
            b.writeTo(subBpt);
            subBptList.func_74742_a((NBTBase)subBpt);
        }
        nbt.func_74782_a("subBlueprints", (NBTBase)subBptList);
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.box.writeData(stream);
        NetworkUtils.writeUTF(stream, this.name);
        this.readConfiguration.writeData(stream);
        stream.writeBoolean(this.reader != null);
        stream.writeShort(this.subLasers.size());
        for (LaserData ld : this.subLasers) {
            ld.writeData(stream);
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        this.box.readData(stream);
        this.name = NetworkUtils.readUTF(stream);
        this.readConfiguration.readData(stream);
        boolean newIsProcessing = stream.readBoolean();
        if (newIsProcessing != this.isProcessing) {
            this.isProcessing = newIsProcessing;
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        int size = stream.readUnsignedShort();
        this.subLasers.clear();
        for (int i = 0; i < size; ++i) {
            LaserData ld = new LaserData();
            ld.readData(stream);
            this.subLasers.add(ld);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    private void initializeComputing() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.reader = new RecursiveBlueprintReader(this);
        this.sendNetworkUpdate();
    }

    public int getComputingProgressScaled(int scale) {
        if (this.reader != null) {
            return (int)(this.reader.getComputingProgressScaled() * (float)scale);
        }
        return 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box completeBox = new Box(this).extendToEncompass(this.box);
        for (LaserData d : this.subLasers) {
            completeBox.extendToEncompass(d.tail);
        }
        return completeBox.getBoundingBox();
    }

    public Packet getPacketSetName() {
        return new PacketCommand(this, "setName", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NetworkUtils.writeUTF(data, TileArchitect.this.name);
            }
        });
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if ("setName".equals(command)) {
            this.name = NetworkUtils.readUTF(stream);
            if (side.isServer()) {
                BuildCraftCore.instance.sendToPlayersNear(this.getPacketSetName(), this);
            }
        } else if (side.isServer() && "setReadConfiguration".equals(command)) {
            this.readConfiguration.readData(stream);
            this.sendNetworkUpdate();
        }
    }

    public void rpcSetConfiguration(BlueprintReadConfiguration conf) {
        this.readConfiguration = conf;
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setReadConfiguration", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                TileArchitect.this.readConfiguration.writeData(data);
            }
        }));
    }

    public void addSubBlueprint(TileEntity sub) {
        this.addSubBlueprint(new BlockIndex(sub));
        this.sendNetworkUpdate();
    }

    private void addSubBlueprint(BlockIndex index) {
        this.subBlueprints.add(index);
        LaserData laser = new LaserData(new Position(index), new Position(this));
        laser.head.x += 0.5;
        laser.head.y += 0.5;
        laser.head.z += 0.5;
        laser.tail.x += 0.5;
        laser.tail.y += 0.5;
        laser.tail.z += 0.5;
        this.subLasers.add(laser);
    }

    @Override
    public int getLEDLevel(int led) {
        return (led == 0 ? this.isProcessing : this.box != null && this.box.isInitialized()) ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }
}

