/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.engines;

import buildcraft.BuildCraftCore;
import buildcraft.api.power.IEngine;
import buildcraft.api.tiles.IHeatable;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.CompatHooks;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.utils.MathUtils;
import buildcraft.core.lib.utils.ResourceUtils;
import buildcraft.core.lib.utils.Utils;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEngineBase
extends TileBuildCraft
implements IPipeConnection,
IEnergyHandler,
IEngine,
IHeatable {
    public static final ResourceLocation TRUNK_BLUE_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_blue.png");
    public static final ResourceLocation TRUNK_GREEN_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_green.png");
    public static final ResourceLocation TRUNK_YELLOW_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_yellow.png");
    public static final ResourceLocation TRUNK_RED_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_red.png");
    public static final ResourceLocation TRUNK_OVERHEAT_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_overheat.png");
    public static final float MIN_HEAT = 20.0f;
    public static final float IDEAL_HEAT = 100.0f;
    public static final float MAX_HEAT = 250.0f;
    public int currentOutput = 0;
    public boolean isRedstonePowered = false;
    public float progress;
    public int energy;
    public float heat = 20.0f;
    public EnergyStage energyStage = EnergyStage.BLUE;
    public ForgeDirection orientation = ForgeDirection.UP;
    protected int progressPart = 0;
    private boolean checkOrientation = false;
    private boolean isPumping = false;

    @Override
    public void initialize() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkRedstonePower();
        }
    }

    public abstract String getResourcePrefix();

    public ResourceLocation getBaseTexture() {
        return new ResourceLocation(this.getResourcePrefix() + "/base.png");
    }

    public ResourceLocation getChamberTexture() {
        return new ResourceLocation(this.getResourcePrefix() + "/chamber.png");
    }

    public ResourceLocation getTrunkTexture(EnergyStage stage) {
        if (ResourceUtils.resourceExists(this.getResourcePrefix() + "/trunk.png")) {
            return new ResourceLocation(this.getResourcePrefix() + "/trunk.png");
        }
        switch (stage) {
            case BLUE: {
                return TRUNK_BLUE_TEXTURE;
            }
            case GREEN: {
                return TRUNK_GREEN_TEXTURE;
            }
            case YELLOW: {
                return TRUNK_YELLOW_TEXTURE;
            }
            case RED: {
                return TRUNK_RED_TEXTURE;
            }
            case OVERHEAT: {
                return TRUNK_OVERHEAT_TEXTURE;
            }
        }
        return TRUNK_RED_TEXTURE;
    }

    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        IToolWrench wrench;
        if (!player.field_70170_p.field_72995_K && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IToolWrench && (wrench = (IToolWrench)player.func_71045_bC().func_77973_b()).canWrench(player, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.getEnergyStage() == EnergyStage.OVERHEAT && !Utils.isFakePlayer(player)) {
                this.energyStage = this.computeEnergyStage();
                this.sendNetworkUpdate();
            }
            this.checkOrientation = true;
            wrench.wrenchUsed(player, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public double getEnergyLevel() {
        return (double)this.energy / (double)this.getMaxEnergy();
    }

    protected EnergyStage computeEnergyStage() {
        float energyLevel = this.getHeatLevel();
        if (energyLevel < 0.25f) {
            return EnergyStage.BLUE;
        }
        if (energyLevel < 0.5f) {
            return EnergyStage.GREEN;
        }
        if (energyLevel < 0.75f) {
            return EnergyStage.YELLOW;
        }
        if (energyLevel < 1.0f) {
            return EnergyStage.RED;
        }
        return EnergyStage.OVERHEAT;
    }

    public final EnergyStage getEnergyStage() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.energyStage == EnergyStage.OVERHEAT) {
                return this.energyStage;
            }
            EnergyStage newStage = this.computeEnergyStage();
            if (this.energyStage != newStage) {
                this.energyStage = newStage;
                if (this.energyStage == EnergyStage.OVERHEAT) {
                    this.overheat();
                }
                this.sendNetworkUpdate();
            }
        }
        return this.energyStage;
    }

    public void overheat() {
        this.isPumping = false;
        if (BuildCraftCore.canEnginesExplode) {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 3.0f, true);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void updateHeat() {
        this.heat = (float)(230.0 * this.getEnergyLevel()) + 20.0f;
    }

    public float getHeatLevel() {
        return (this.heat - 20.0f) / 230.0f;
    }

    public float getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.16f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.02f;
            }
            case GREEN: {
                return 0.04f;
            }
            case YELLOW: {
                return 0.08f;
            }
            case RED: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.progressPart != 0) {
                this.progress += this.getPistonSpeed();
                if (this.progress > 1.0f) {
                    this.progressPart = 0;
                    this.progress = 0.0f;
                }
            } else if (this.isPumping) {
                this.progressPart = 1;
            }
            return;
        }
        if (this.checkOrientation) {
            this.checkOrientation = false;
            if (!this.isOrientationValid()) {
                this.switchOrientation(true);
            }
        }
        this.updateHeat();
        this.getEnergyStage();
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.energy = Math.max(this.energy - 50, 0);
            return;
        }
        this.engineUpdate();
        Object tile = this.getEnergyProvider(this.orientation);
        if (this.progressPart != 0) {
            this.progress += this.getPistonSpeed();
            if ((double)this.progress > 0.5 && this.progressPart == 1) {
                this.progressPart = 2;
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isRedstonePowered && this.isActive()) {
            if (this.isPoweredTile(tile, this.orientation)) {
                this.progressPart = 1;
                this.setPumping(true);
                if (this.getPowerToExtract() > 0) {
                    this.progressPart = 1;
                    this.setPumping(true);
                } else {
                    this.setPumping(false);
                }
            } else {
                this.setPumping(false);
            }
        } else {
            this.setPumping(false);
        }
        this.burn();
        if (!this.isRedstonePowered) {
            this.currentOutput = 0;
        } else if (this.isRedstonePowered && this.isActive()) {
            this.sendPower();
        }
    }

    public Object getEnergyProvider(ForgeDirection orientation) {
        return CompatHooks.INSTANCE.getEnergyProvider(this.getTile(orientation));
    }

    private int getPowerToExtract() {
        Object tile = this.getEnergyProvider(this.orientation);
        if (tile instanceof IEngine) {
            IEngine engine = (IEngine)tile;
            int maxEnergy = engine.receiveEnergyFromEngine(this.orientation.getOpposite(), this.energy, true);
            return this.extractEnergy(maxEnergy, false);
        }
        if (tile instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tile;
            int maxEnergy = handler.receiveEnergy(this.orientation.getOpposite(), this.energy, true);
            return this.extractEnergy(maxEnergy, false);
        }
        if (tile instanceof IEnergyReceiver) {
            IEnergyReceiver handler = (IEnergyReceiver)tile;
            int maxEnergy = handler.receiveEnergy(this.orientation.getOpposite(), this.energy, true);
            return this.extractEnergy(maxEnergy, false);
        }
        return 0;
    }

    protected void sendPower() {
        Object tile = this.getEnergyProvider(this.orientation);
        if (this.isPoweredTile(tile, this.orientation)) {
            int extracted = this.getPowerToExtract();
            if (extracted <= 0) {
                this.setPumping(false);
                return;
            }
            this.setPumping(true);
            if (tile instanceof IEngine) {
                IEngine engine = (IEngine)tile;
                int neededRF = engine.receiveEnergyFromEngine(this.orientation.getOpposite(), extracted, false);
                this.extractEnergy(neededRF, true);
            } else if (tile instanceof IEnergyHandler) {
                IEnergyHandler handler = (IEnergyHandler)tile;
                int neededRF = handler.receiveEnergy(this.orientation.getOpposite(), extracted, false);
                this.extractEnergy(neededRF, true);
            } else if (tile instanceof IEnergyReceiver) {
                IEnergyReceiver handler = (IEnergyReceiver)tile;
                int neededRF = handler.receiveEnergy(this.orientation.getOpposite(), extracted, false);
                this.extractEnergy(neededRF, true);
            }
        }
    }

    protected void burn() {
    }

    protected void engineUpdate() {
        if (!this.isRedstonePowered) {
            if (this.energy >= 10) {
                this.energy -= 10;
            } else if (this.energy < 10) {
                this.energy = 0;
            }
        }
    }

    public boolean isActive() {
        return true;
    }

    protected final void setPumping(boolean isActive) {
        if (this.isPumping == isActive) {
            return;
        }
        this.isPumping = isActive;
        this.sendNetworkUpdate();
    }

    public boolean isOrientationValid() {
        Object tile = this.getEnergyProvider(this.orientation);
        return this.isPoweredTile(tile, this.orientation);
    }

    public boolean switchOrientation(boolean preferPipe) {
        if (preferPipe && this.switchOrientationDo(true)) {
            return true;
        }
        return this.switchOrientationDo(false);
    }

    private boolean switchOrientationDo(boolean pipesOnly) {
        for (int i = this.orientation.ordinal() + 1; i <= this.orientation.ordinal() + 6; ++i) {
            ForgeDirection o = ForgeDirection.VALID_DIRECTIONS[i % 6];
            Object tile = this.getEnergyProvider(o);
            if (pipesOnly && !(tile instanceof IPipeTile) || !this.isPoweredTile(tile, o)) continue;
            this.orientation = o;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            return true;
        }
        return false;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.checkOrientation = true;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.checkOrientation = true;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.orientation = ForgeDirection.getOrientation((int)data.func_74771_c("orientation"));
        this.progress = data.func_74760_g("progress");
        this.energy = data.func_74762_e("energy");
        this.heat = data.func_74760_g("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("orientation", (byte)this.orientation.ordinal());
        data.func_74776_a("progress", this.progress);
        data.func_74768_a("energy", this.energy);
        data.func_74776_a("heat", this.heat);
    }

    @Override
    public void readData(ByteBuf stream) {
        short flags = stream.readUnsignedByte();
        this.energyStage = EnergyStage.values()[flags & 7];
        this.isPumping = (flags & 8) != 0;
        this.orientation = ForgeDirection.getOrientation((int)stream.readByte());
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeByte(this.energyStage.ordinal() | (this.isPumping ? 8 : 0));
        stream.writeByte(this.orientation.ordinal());
    }

    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.energy = this.energy & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 1: {
                this.energy = this.energy & 0xFFFF | (value & 0xFFFF) << 16;
                break;
            }
            case 2: {
                this.currentOutput = value;
                break;
            }
            case 3: {
                this.heat = (float)value / 100.0f;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.energy & 0xFFFF);
        iCrafting.func_71112_a(container, 1, (this.energy & 0xFFFF0000) >> 16);
        iCrafting.func_71112_a(container, 2, this.currentOutput);
        iCrafting.func_71112_a(container, 3, Math.round(this.heat * 100.0f));
    }

    public abstract boolean isBurning();

    public void addEnergy(int addition) {
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            return;
        }
        this.energy += addition;
        if (this.energy > this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    public int extractEnergy(int energyMax, boolean doExtract) {
        int extracted;
        int max = Math.min(energyMax, this.maxEnergyExtracted());
        if (this.energy >= max) {
            extracted = max;
            if (doExtract) {
                this.energy -= max;
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0;
            }
        }
        return extracted;
    }

    public boolean isPoweredTile(Object tile, ForgeDirection side) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IEngine) {
            return ((IEngine)tile).canReceiveFromEngine(side.getOpposite());
        }
        if (tile instanceof IEnergyHandler || tile instanceof IEnergyReceiver) {
            return ((IEnergyConnection)tile).canConnectEnergy(side.getOpposite());
        }
        return false;
    }

    public abstract int getMaxEnergy();

    public int minEnergyReceived() {
        return 20;
    }

    public abstract int maxEnergyReceived();

    public abstract int maxEnergyExtracted();

    public int getEnergyStored() {
        return this.energy;
    }

    public abstract int calculateCurrentOutput();

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.DEFAULT;
        }
        if (with == this.orientation) {
            return IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    public void checkRedstonePower() {
        this.isRedstonePowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onNeighborUpdate() {
        this.checkRedstonePower();
        this.checkOrientation = true;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (from != this.orientation) {
            return 0;
        }
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergy();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.orientation;
    }

    @Override
    public boolean canReceiveFromEngine(ForgeDirection side) {
        return side == this.orientation.getOpposite();
    }

    @Override
    public int receiveEnergyFromEngine(ForgeDirection side, int amount, boolean simulate) {
        if (this.canReceiveFromEngine(side)) {
            int targetEnergy = Math.min(this.getMaxEnergy() - this.energy, amount);
            if (!simulate) {
                this.energy += targetEnergy;
            }
            return targetEnergy;
        }
        return 0;
    }

    @Override
    public double getMinHeatValue() {
        return 20.0;
    }

    @Override
    public double getIdealHeatValue() {
        return 100.0;
    }

    @Override
    public double getMaxHeatValue() {
        return 250.0;
    }

    @Override
    public double getCurrentHeatValue() {
        return this.heat;
    }

    @Override
    public double setHeatValue(double value) {
        this.heat = (float)MathUtils.clamp(value, 20.0, 250.0);
        return this.heat;
    }

    public static enum EnergyStage {
        BLUE,
        GREEN,
        YELLOW,
        RED,
        OVERHEAT;

        public static final EnergyStage[] VALUES;

        static {
            VALUES = EnergyStage.values();
        }
    }
}

