/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet;

import buildcraft.api.tablet.TabletBitmap;
import buildcraft.api.tablet.TabletTicker;

class TabletRenderer {
    private TabletBitmap currDisplay;
    private TabletBitmap newDisplay;
    private final TabletTicker refreshRate = new TabletTicker(0.035f);
    private boolean changed = false;
    private boolean isTicking = false;
    private int tickLocation = 7;

    public TabletRenderer(TabletBitmap display) {
        this.currDisplay = display;
    }

    public TabletBitmap get() {
        return this.currDisplay;
    }

    public boolean shouldChange() {
        boolean oldChanged = this.changed;
        this.changed = false;
        return oldChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TabletBitmap display) {
        TabletTicker tabletTicker = this.refreshRate;
        synchronized (tabletTicker) {
            this.newDisplay = display;
            this.isTicking = true;
            this.tickLocation = 7;
            this.refreshRate.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tick(float tick) {
        if (this.isTicking) {
            TabletTicker tabletTicker = this.refreshRate;
            synchronized (tabletTicker) {
                this.refreshRate.add(tick);
                this.changed = false;
                for (int times = 0; times < this.refreshRate.getTicks(); ++times) {
                    for (int j = 0; j < this.currDisplay.height; ++j) {
                        for (int i = 0; i < this.currDisplay.width; ++i) {
                            int newI;
                            int oldI = this.currDisplay.get(i, j);
                            if (Math.abs(oldI - (newI = this.newDisplay.get(i, j))) != this.tickLocation) continue;
                            if (oldI < newI) {
                                this.changed = true;
                                this.currDisplay.set(i, j, oldI + 1);
                                continue;
                            }
                            if (oldI <= newI) continue;
                            this.changed = true;
                            this.currDisplay.set(i, j, oldI - 1);
                        }
                    }
                    --this.tickLocation;
                    if (this.changed && this.tickLocation != 0) continue;
                    this.isTicking = false;
                    break;
                }
                this.refreshRate.tick();
            }
            return true;
        }
        return false;
    }
}

