/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.StackRequest;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.filters.ArrayStackOrListFilter;
import buildcraft.robotics.ai.AIRobotGotoStation;
import buildcraft.robotics.ai.AIRobotUnload;
import net.minecraft.item.ItemStack;

public class AIRobotDeliverRequested
extends AIRobot {
    private StackRequest requested;
    private boolean delivered = false;

    public AIRobotDeliverRequested(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotDeliverRequested(EntityRobotBase robot, StackRequest request) {
        this(robot);
        this.requested = request;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotGotoStation(this.robot, this.requested.station));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (!(ai instanceof AIRobotGotoStation)) {
            if (!(ai instanceof AIRobotUnload)) return;
            this.delivered = ai.success();
            this.terminate();
            return;
        }
        if (!ai.success()) {
            this.terminate();
            return;
        }
        IInvSlot slot = InvUtils.getItem(this.robot, new ArrayStackOrListFilter(this.requested.stack));
        if (slot == null) {
            this.terminate();
            return;
        }
        if (this.requested.requester == null) {
            this.startDelegateAI(new AIRobotUnload(this.robot));
            return;
        }
        ItemStack newStack = ((IRequestProvider)this.requested.requester).provideItemsForRequest(this.requested.index, slot.getStackInSlot().func_77946_l());
        if (newStack == null || newStack.field_77994_a != slot.getStackInSlot().field_77994_a) {
            this.delivered = true;
            slot.setStackInSlot(newStack);
        }
        this.terminate();
    }

    @Override
    public boolean success() {
        return this.delivered;
    }
}

