/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotStraightMoveTo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotGoAndLinkToDock
extends AIRobot {
    private DockingStation station;

    public AIRobotGoAndLinkToDock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGoAndLinkToDock(EntityRobotBase iRobot, DockingStation iStation) {
        this(iRobot);
        this.station = iStation;
    }

    @Override
    public void start() {
        if (this.station == this.robot.getLinkedStation() && this.station == this.robot.getDockingStation()) {
            this.terminate();
        } else if (this.station != null && this.station.takeAsMain(this.robot)) {
            this.startDelegateAI(new AIRobotGotoBlock(this.robot, this.station.x() + this.station.side().offsetX * 2, this.station.y() + this.station.side().offsetY * 2, this.station.z() + this.station.side().offsetZ * 2));
        } else {
            this.setSuccess(false);
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoBlock) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotStraightMoveTo(this.robot, (float)this.station.x() + 0.5f + (float)this.station.side().offsetX * 0.5f, (float)this.station.y() + 0.5f + (float)this.station.side().offsetY * 0.5f, (float)this.station.z() + 0.5f + (float)this.station.side().offsetZ * 0.5f));
            } else {
                this.terminate();
            }
        } else if (ai instanceof AIRobotStraightMoveTo) {
            if (ai.success()) {
                this.robot.dock(this.station);
            }
            this.terminate();
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.station.index().writeTo(indexNBT);
        nbt.func_74782_a("stationIndex", (NBTBase)indexNBT);
        nbt.func_74774_a("stationSide", (byte)this.station.side().ordinal());
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("stationIndex")) {
            BlockIndex index = new BlockIndex(nbt.func_74775_l("stationIndex"));
            ForgeDirection side = ForgeDirection.values()[nbt.func_74771_c("stationSide")];
            this.station = this.robot.getRegistry().getStation(index.x, index.y, index.z, side);
        } else {
            this.station = this.robot.getLinkedStation();
        }
    }
}

