/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.map;

import buildcraft.api.core.BCLog;
import net.minecraft.block.material.MapColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;

public class MapChunk {
    private static final int VERSION = 1;
    private int x;
    private int z;
    private byte[] data;

    public MapChunk(int x, int z) {
        this.x = x;
        this.z = z;
        this.data = new byte[256];
    }

    public MapChunk(NBTTagCompound compound) {
        this.readFromNBT(compound);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getColor(int x, int z) {
        return this.data[(z & 0xF) << 4 | x & 0xF];
    }

    public void update(Chunk chunk) {
        for (int bz = 0; bz < 16; ++bz) {
            for (int bx = 0; bx < 16; ++bx) {
                int color;
                int y = chunk.func_76611_b(bx, bz);
                while ((color = chunk.func_150810_a((int)bx, (int)y, (int)bz).func_149728_f((int)0).field_76290_q) == MapColor.field_151660_b.field_76290_q && --y >= 0) {
                }
                this.data[bz << 4 | bx] = (byte)color;
            }
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        short version = compound.func_74765_d("version");
        if (version > 1) {
            BCLog.logger.error("Unsupported MapChunk version: " + version);
            return;
        }
        this.x = compound.func_74762_e("x");
        this.z = compound.func_74762_e("z");
        this.data = compound.func_74770_j("data");
        if (this.data.length != 256) {
            BCLog.logger.error("Invalid MapChunk data length: " + this.data.length);
            this.data = new byte[256];
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74777_a("version", (short)1);
        compound.func_74768_a("x", this.x);
        compound.func_74768_a("z", this.z);
        compound.func_74773_a("data", this.data);
    }

    public int hashCode() {
        return 31 * this.x + this.z;
    }
}

