/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.statements;

import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementSlot;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.robotics.statements.StatementParameterRobot;
import net.minecraft.client.renderer.texture.IIconRegister;

public class ActionStationForbidRobot
extends BCStatement
implements IActionInternal {
    private final boolean invert;

    public ActionStationForbidRobot(boolean invert) {
        super("buildcraft:station." + (invert ? "force" : "forbid") + "_robot");
        this.invert = invert;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.station." + (this.invert ? "force" : "forbid") + "_robot");
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraftrobotics:triggers/action_station_robot_" + (this.invert ? "mandatory" : "forbidden"));
    }

    @Override
    public int minParameters() {
        return 1;
    }

    @Override
    public int maxParameters() {
        return 3;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterRobot();
    }

    public static boolean isForbidden(DockingStation station, EntityRobotBase robot) {
        for (StatementSlot s : station.getActiveActions()) {
            if (!(s.statement instanceof ActionStationForbidRobot) || !(((ActionStationForbidRobot)s.statement).invert ^ ActionStationForbidRobot.isForbidden(s, robot))) continue;
            return true;
        }
        return false;
    }

    public static boolean isForbidden(StatementSlot slot, EntityRobotBase robot) {
        for (IStatementParameter p : slot.parameters) {
            if (!StatementParameterRobot.matches(p, robot)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionActivate(IStatementContainer source, IStatementParameter[] parameters) {
    }
}

