/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.core.Position;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.transport.ItemPipeWire;
import buildcraft.transport.TileGenericPipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class StripesHandlerPipeWires
implements IStripesHandler {
    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemPipeWire;
    }

    @Override
    public boolean handle(World world, int x, int y, int z, ForgeDirection direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        int pipeWireColor = stack.func_77960_j();
        Position p = new Position(x, y, z);
        p.orientation = direction;
        for (int pipesToTry = 8; pipesToTry > 0; --pipesToTry) {
            p.moveBackwards(1.0);
            TileEntity tile = world.func_147438_o((int)p.x, (int)p.y, (int)p.z);
            if (!(tile instanceof TileGenericPipe)) break;
            TileGenericPipe pipeTile = (TileGenericPipe)tile;
            if (pipeTile.pipe.wireSet[pipeWireColor]) continue;
            pipeTile.pipe.wireSet[pipeWireColor] = true;
            pipeTile.pipe.signalStrength[pipeWireColor] = 0;
            pipeTile.pipe.updateSignalState();
            pipeTile.scheduleRenderUpdate();
            world.func_147459_d(pipeTile.field_145851_c, pipeTile.field_145848_d, pipeTile.field_145849_e, pipeTile.getBlock());
            return true;
        }
        return false;
    }
}

