/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.asm;

import com.google.common.base.Throwables;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.MalisisCoreAccessTransformer;
import net.malisis.core.asm.MalisisCoreTransformer;
import net.malisis.core.util.chunkblock.ChunkBlockTransformer;
import net.malisis.core.util.chunkcollision.ChunkCollisionTransformer;
import org.apache.logging.log4j.LogManager;

@IFMLLoadingPlugin.TransformerExclusions(value={"net.malisis.core.asm."})
@IFMLLoadingPlugin.SortingIndex(value=1001)
public class MalisisCorePlugin
implements IFMLLoadingPlugin {
    public String[] getASMTransformerClass() {
        return new String[]{MalisisCoreTransformer.class.getName(), ChunkBlockTransformer.class.getName(), ChunkCollisionTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        MalisisCore.isObfEnv = (Boolean)data.get("runtimeDeobfuscationEnabled");
        MalisisCore.coremodLocation = (File)data.get("coremodLocation");
        if (MalisisCore.coremodLocation == null) {
            try {
                MalisisCore.coremodLocation = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (URISyntaxException e) {
                LogManager.getLogger((String)"malisiscore").error("Failed to acquire source location for MalisisCore!");
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public String getAccessTransformerClass() {
        return MalisisCoreAccessTransformer.class.getName();
    }
}

