/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.minecraft.util.IIcon;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class UIRadioButton
extends UIComponent<UIRadioButton>
implements IGuiText<UIRadioButton> {
    private static HashMap<String, List<UIRadioButton>> radioButtons = new HashMap();
    protected GuiIcon bgIcon;
    protected GuiIcon bgIconDisabled;
    protected GuiIcon rbDisabled;
    protected GuiIcon rbChecked;
    protected GuiIcon rbHovered;
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontRenderOptions fro = new FontRenderOptions();
    private String name;
    private String text;
    private boolean selected;

    public UIRadioButton(MalisisGui gui, String name, String text) {
        super(gui);
        this.name = name;
        this.setText(text);
        this.fro.color = 0x444444;
        this.shape = new SimpleGuiShape();
        this.bgIcon = gui.getGuiTexture().getIcon(200, 54, 8, 8);
        this.bgIconDisabled = gui.getGuiTexture().getIcon(200, 62, 8, 8);
        this.rbDisabled = gui.getGuiTexture().getIcon(208, 54, 6, 6);
        this.rbChecked = gui.getGuiTexture().getIcon(214, 54, 6, 6);
        this.rbHovered = gui.getGuiTexture().getIcon(220, 54, 6, 6);
        UIRadioButton.addRadioButton(this);
    }

    public UIRadioButton(MalisisGui gui, String name) {
        this(gui, name, null);
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UIRadioButton setFont(MalisisFont font) {
        this.font = font;
        this.calculateSize();
        return this;
    }

    @Override
    public FontRenderOptions getFontRenderOptions() {
        return this.fro;
    }

    @Override
    public UIRadioButton setFontRenderOptions(FontRenderOptions fro) {
        this.fro = fro;
        this.calculateSize();
        return this;
    }

    public UIRadioButton setText(String text) {
        this.text = text;
        this.calculateSize();
        return this;
    }

    public String getText() {
        return this.text;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public UIRadioButton setSelected() {
        UIRadioButton rb = UIRadioButton.getSelected(this.name);
        if (rb != null) {
            rb.selected = false;
        }
        this.selected = true;
        return this;
    }

    private void calculateSize() {
        int w = StringUtils.isEmpty((CharSequence)this.text) ? 0 : (int)this.font.getStringWidth(this.text, this.fro);
        this.setSize(w + 11, 10);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.resetState();
        this.shape.setSize(8.0f, 8.0f);
        this.shape.translate(1.0f, 0.0f, 0.0f);
        this.rp.icon.set((IIcon)(this.isDisabled() ? this.bgIconDisabled : this.bgIcon));
        renderer.drawShape(this.shape, this.rp);
        renderer.next();
        if (this.hovered) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3008);
            renderer.enableBlending();
            this.rp = new RenderParameters();
            this.rp.colorMultiplier.set(0xFFFFFF);
            this.rp.alpha.set(80);
            this.rp.useTexture.set(false);
            this.shape.resetState();
            this.shape.setSize(6.0f, 6.0f);
            this.shape.setPosition(2.0f, 1.0f);
            renderer.drawShape(this.shape, this.rp);
            renderer.next();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3553);
        }
        if (this.text != null) {
            renderer.drawText(this.font, this.text, 12.0f, 0.0f, 0.0f, this.fro);
        }
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.selected) {
            GL11.glEnable((int)3042);
            this.rp.reset();
            this.shape.resetState();
            this.shape.setSize(6.0f, 6.0f);
            this.shape.setPosition(2.0f, 1.0f);
            this.rp.icon.set((IIcon)(this.isDisabled() ? this.rbDisabled : (this.isHovered() ? this.rbHovered : this.rbChecked)));
            renderer.drawShape(this.shape, this.rp);
        }
    }

    @Override
    public boolean onClick(int x, int y) {
        if (this.fireEvent(new SelectEvent(this))) {
            this.setSelected();
        }
        return true;
    }

    public static void addRadioButton(UIRadioButton rb) {
        List<UIRadioButton> listRb = radioButtons.get(rb.name);
        if (listRb == null) {
            listRb = new ArrayList<UIRadioButton>();
        }
        listRb.add(rb);
        radioButtons.put(rb.name, listRb);
    }

    public static UIRadioButton getSelected(String name) {
        List<UIRadioButton> listRb = radioButtons.get(name);
        if (listRb == null) {
            return null;
        }
        for (UIRadioButton rb : listRb) {
            if (!rb.selected) continue;
            return rb;
        }
        return null;
    }

    public static UIRadioButton getSelected(UIRadioButton rb) {
        return UIRadioButton.getSelected(rb.name);
    }

    public static class SelectEvent
    extends ComponentEvent.ValueChange<UIRadioButton, UIRadioButton> {
        public SelectEvent(UIRadioButton component) {
            super(component, UIRadioButton.getSelected(component), component);
        }
    }
}

