/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import com.google.common.io.Files;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.SouthFace;
import net.malisis.core.renderer.font.CharData;
import net.malisis.core.renderer.font.FontGenerator;
import net.malisis.core.renderer.font.FontGeneratorOptions;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MinecraftFont;
import net.malisis.core.renderer.font.StringWalker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class MalisisFont {
    public static MalisisFont minecraftFont = new MinecraftFont();
    private static Pattern pattern = Pattern.compile("\\{(.*?)}");
    protected Font font;
    protected FontRenderContext frc;
    protected FontGeneratorOptions options = FontGeneratorOptions.DEFAULT;
    protected CharData[] charData = new CharData[256];
    protected ResourceLocation textureRl;
    protected int size;
    protected boolean drawingShadow = false;

    public MalisisFont(File fontFile) {
        this(MalisisFont.load(fontFile, FontGeneratorOptions.DEFAULT), null);
    }

    public MalisisFont(File fontFile, FontGeneratorOptions options) {
        this(MalisisFont.load(fontFile, options), options);
    }

    public MalisisFont(ResourceLocation fontFile) {
        this(MalisisFont.load(fontFile, FontGeneratorOptions.DEFAULT), null);
    }

    public MalisisFont(ResourceLocation fontFile, FontGeneratorOptions options) {
        this(MalisisFont.load(fontFile, options), options);
    }

    public MalisisFont(Font font) {
        this(font, null);
    }

    public MalisisFont(Font font, FontGeneratorOptions options) {
        this.font = font;
        if (font == null) {
            return;
        }
        if (options != null) {
            this.options = options;
        }
        this.loadCharacterData();
        this.loadTexture(false);
    }

    public ResourceLocation getResourceLocation() {
        return this.textureRl;
    }

    public void generateTexture(boolean debug) {
        this.options.debug = debug;
        this.loadCharacterData();
        this.loadTexture(true);
    }

    public CharData getCharData(char c) {
        if (c < '\u0000' || c > this.charData.length) {
            c = (char)63;
        }
        return this.charData[c];
    }

    public Shape getShape(String text, float fontSize) {
        text = this.processString(text, null);
        ArrayList<Face> faces = new ArrayList<Face>();
        float offset = 0.0f;
        float factor = this.options.fontSize / fontSize;
        for (int i = 0; i < text.length(); ++i) {
            CharData cd = this.getCharData(text.charAt(i));
            if (cd.getChar() != ' ') {
                SouthFace f = new SouthFace();
                f.factor(cd.getFullWidth(this.options) / factor, cd.getFullHeight(this.options) / factor, 0.0f);
                f.translate((offset - this.options.mx) / factor, -this.options.my / factor, 0.0f);
                f.setTexture(cd.getIcon());
                faces.add(f);
            }
            offset += cd.getCharWidth();
        }
        return new Shape(faces).storeState();
    }

    protected void prepare(MalisisRenderer renderer, float x, float y, float z, FontRenderOptions fro) {
        boolean isGui = renderer instanceof GuiRenderer;
        renderer.next(7);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textureRl);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)(y + (isGui ? 0.0f : fro.fontScale)), (float)z);
        if (!isGui) {
            GL11.glScalef((float)0.11111111f, (float)-0.11111111f, (float)0.11111111f);
        }
    }

    protected void clean(MalisisRenderer renderer, boolean isDrawing) {
        if (isDrawing) {
            renderer.next();
        } else {
            renderer.draw();
        }
        if (renderer instanceof GuiRenderer) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(((GuiRenderer)renderer).getDefaultTexture().getResourceLocation());
        }
        GL11.glPopMatrix();
    }

    protected void prepareShadow(MalisisRenderer renderer) {
        this.drawingShadow = true;
        if (renderer instanceof GuiRenderer) {
            return;
        }
        renderer.next();
        GL11.glPolygonOffset((float)3.0f, (float)3.0f);
        GL11.glEnable((int)32823);
    }

    protected void cleanShadow(MalisisRenderer renderer) {
        this.drawingShadow = false;
        if (renderer instanceof GuiRenderer) {
            return;
        }
        renderer.next();
        GL11.glPolygonOffset((float)0.0f, (float)0.0f);
        GL11.glDisable((int)32823);
    }

    protected void prepareLines(MalisisRenderer renderer, FontRenderOptions fro) {
        renderer.next();
        renderer.disableTextures();
    }

    protected void cleanLines(MalisisRenderer renderer) {
        renderer.next();
        renderer.enableTextures();
    }

    public void render(MalisisRenderer renderer, String text, float x, float y, float z, FontRenderOptions fro) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        boolean isDrawing = renderer.isDrawing();
        this.prepare(renderer, x, y, z, fro);
        text = this.processString(text, fro);
        if (fro.shadow) {
            this.prepareShadow(renderer);
            this.drawString(text, fro);
            this.cleanShadow(renderer);
        }
        this.drawString(text, fro);
        if (this.hasLines(text, fro)) {
            this.prepareLines(renderer, fro);
            if (fro.shadow) {
                this.prepareShadow(renderer);
                this.drawLines(text, fro);
                this.cleanShadow(renderer);
            }
            this.drawLines(text, fro);
            this.cleanLines(renderer);
        }
        this.clean(renderer, isDrawing);
    }

    protected void drawString(String text, FontRenderOptions fro) {
        float x = 0.0f;
        fro.resetStylesLine();
        StringWalker walker = new StringWalker(text, this, fro);
        walker.applyStyles(true);
        while (walker.walk()) {
            CharData cd = this.getCharData(walker.getChar());
            this.drawChar(cd, x, 0.0f, fro);
            x += walker.getWidth();
        }
    }

    protected void drawChar(CharData cd, float offsetX, float offsetY, FontRenderOptions fro) {
        float i;
        if (Character.isWhitespace(cd.getChar())) {
            return;
        }
        Tessellator t = Tessellator.field_78398_a;
        float factor = fro.fontScale / this.options.fontSize * 9.0f;
        float w = cd.getFullWidth(this.options) * factor;
        float h = cd.getFullHeight(this.options) * factor;
        float f = i = fro.italic ? fro.fontScale : 0.0f;
        if (this.drawingShadow) {
            offsetX += fro.fontScale;
            offsetY += fro.fontScale;
        }
        t.func_78378_d(this.drawingShadow ? fro.getShadowColor() : fro.color);
        t.func_78380_c(0xF000F0);
        t.func_78374_a((double)(offsetX + i), (double)offsetY, 0.0, (double)cd.u(), (double)cd.v());
        t.func_78374_a((double)(offsetX - i), (double)(offsetY + h), 0.0, (double)cd.u(), (double)cd.V());
        t.func_78374_a((double)(offsetX + w - i), (double)(offsetY + h), 0.0, (double)cd.U(), (double)cd.V());
        t.func_78374_a((double)(offsetX + w + i), (double)offsetY, 0.0, (double)cd.U(), (double)cd.v());
    }

    protected void drawLines(String text, FontRenderOptions fro) {
        float x = 0.0f;
        fro.resetStylesLine();
        StringWalker walker = new StringWalker(text, this, fro);
        walker.applyStyles(true);
        while (walker.walk()) {
            if (walker.isFormatting()) continue;
            CharData cd = this.getCharData(walker.getChar());
            if (fro.underline) {
                this.drawLineChar(cd, x, this.getStringHeight(fro) + fro.fontScale, fro);
            }
            if (fro.strikethrough) {
                this.drawLineChar(cd, x, this.getStringHeight(fro) * 0.5f + fro.fontScale, fro);
            }
            x += walker.getWidth();
        }
    }

    protected void drawLineChar(CharData cd, float offsetX, float offsetY, FontRenderOptions fro) {
        Tessellator t = Tessellator.field_78398_a;
        float factor = fro.fontScale / this.options.fontSize * 9.0f;
        float w = cd.getFullWidth(this.options) * factor;
        float h = cd.getFullHeight(this.options) / 9.0f * factor;
        if (this.drawingShadow) {
            offsetX += fro.fontScale;
            offsetY += fro.fontScale;
        }
        t.func_78378_d(this.drawingShadow ? fro.getShadowColor() : fro.color);
        t.func_78377_a((double)offsetX, (double)offsetY, 0.0);
        t.func_78377_a((double)offsetX, (double)(offsetY + h), 0.0);
        t.func_78377_a((double)(offsetX + w), (double)(offsetY + h), 0.0);
        t.func_78377_a((double)(offsetX + w), (double)offsetY, 0.0);
    }

    public String processString(String str, FontRenderOptions fro) {
        str = this.translate(str);
        return str;
    }

    private String translate(String str) {
        if (str.indexOf(123) == -1 || str.indexOf(123) >= str.indexOf(125)) {
            return StatCollector.func_74838_a((String)str);
        }
        StringBuffer output = new StringBuffer();
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            matcher.appendReplacement(output, StatCollector.func_74838_a((String)matcher.group(1)));
        }
        matcher.appendTail(output);
        return output.toString();
    }

    private boolean hasLines(String text, FontRenderOptions fro) {
        return fro.underline || fro.strikethrough || text.contains(EnumChatFormatting.UNDERLINE.toString()) || text.contains(EnumChatFormatting.STRIKETHROUGH.toString());
    }

    public String clipString(String str, int width) {
        return this.clipString(str, width, null, false);
    }

    public String clipString(String str, int width, FontRenderOptions fro) {
        return this.clipString(str, width, fro, false);
    }

    public String clipString(String str, int width, FontRenderOptions fro, boolean appendPeriods) {
        str = this.processString(str, fro);
        if (appendPeriods) {
            width -= 4;
        }
        int pos = (int)this.getCharPosition(str, fro, width, 0);
        return str.substring(0, pos) + (pos < str.length() && appendPeriods ? "..." : "");
    }

    public float getStringWidth(String str) {
        return this.getStringWidth(str, null);
    }

    public float getStringWidth(String str, FontRenderOptions fro, int start, int end) {
        if (start > end) {
            return 0.0f;
        }
        if (fro != null && !fro.disableECF) {
            str = EnumChatFormatting.func_110646_a((String)str);
        }
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        str = this.processString(str, fro);
        return (float)this.font.getStringBounds(str, this.frc).getWidth() / this.options.fontSize * (fro != null ? fro.fontScale : 1.0f) * 9.0f;
    }

    public float getStringWidth(String str, FontRenderOptions fro) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        return this.getStringWidth(str, fro, 0, 0);
    }

    public float getStringHeight() {
        return this.getStringHeight(null);
    }

    public float getStringHeight(FontRenderOptions fro) {
        return (fro != null ? fro.fontScale : 1.0f) * 9.0f;
    }

    public float getMaxStringWidth(List<String> strings) {
        return this.getMaxStringWidth(strings, null);
    }

    public float getMaxStringWidth(List<String> strings, FontRenderOptions fro) {
        float width = 0.0f;
        for (String str : strings) {
            width = Math.max(width, this.getStringWidth(str, fro));
        }
        return width;
    }

    public float getCharWidth(char c) {
        return this.getCharWidth(c, null);
    }

    public float getCharWidth(char c, FontRenderOptions fro) {
        if (c == '\r' || c == '\n') {
            return 0.0f;
        }
        if (c == '\t') {
            return this.getCharWidth(' ', fro) * 4.0f;
        }
        return this.getCharData(c).getCharWidth() / this.options.fontSize * (fro != null ? fro.fontScale : 1.0f) * 9.0f;
    }

    public float getCharPosition(String str, FontRenderOptions fro, int position, int charOffset) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        str = this.processString(str, fro);
        StringWalker walker = new StringWalker(str, this, fro);
        walker.startIndex(charOffset);
        walker.skipChars(true);
        return walker.walkTo(position);
    }

    public List<String> wrapText(String text, int maxWidth) {
        return this.wrapText(text, maxWidth, null);
    }

    public List<String> wrapText(String str, int maxWidth, FontRenderOptions fro) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] texts = str.split("\r?(?<=\n)");
        if (texts.length > 1) {
            for (String t : texts) {
                lines.addAll(this.wrapText(t, maxWidth, fro));
            }
            return lines;
        }
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        maxWidth -= 4;
        float lineWidth = 0.0f;
        float wordWidth = 0.0f;
        str = this.processString(str, fro);
        StringWalker walker = new StringWalker(str, this, fro);
        walker.skipChars(false);
        walker.applyStyles(false);
        while (walker.walk()) {
            char c = walker.getChar();
            lineWidth += walker.getWidth();
            wordWidth += walker.getWidth();
            word.append(c);
            if (c == ' ' || c == '-' || c == '.') {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0.0f;
            }
            if (!(lineWidth >= (float)maxWidth)) continue;
            if (line.length() == 0) {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0.0f;
            }
            lines.add(line.toString());
            line.setLength(0);
            lineWidth = wordWidth;
        }
        line.append((CharSequence)word);
        lines.add(line.toString());
        return lines;
    }

    protected void loadCharacterData() {
        this.frc = new FontRenderContext(null, true, true);
        float totalWidth = 0.0f;
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            CharData cd;
            String s = "" + c;
            LineMetrics lm = this.font.getLineMetrics(s, this.frc);
            Rectangle2D bounds = this.font.getStringBounds(s, this.frc);
            this.charData[c] = cd = new CharData(c, lm.getAscent(), (float)bounds.getWidth(), this.options.fontSize);
            totalWidth += cd.getFullWidth(this.options);
        }
        int split = 1;
        while (totalWidth / (float)split > this.options.fontSize * (float)split) {
            ++split;
        }
        this.size = this.roundUp((int)totalWidth / (split - 1));
    }

    protected int roundUp(int n) {
        int r = n - 1;
        r |= r >> 1;
        r |= r >> 2;
        r |= r >> 4;
        r |= r >> 8;
        r |= r >> 16;
        return r + 1;
    }

    protected void loadTexture(boolean forceGenerate) {
        BufferedImage img;
        File textureFile = new File("fonts/" + this.font.getName() + ".png");
        File uvFile = new File("fonts/" + this.font.getName() + ".bin");
        if (!textureFile.exists() || !uvFile.exists() || forceGenerate) {
            MalisisCore.log.info("Generating files for " + this.font.getName());
            img = new FontGenerator(this.font, this.charData, this.options).generate(this.size, textureFile, uvFile);
        } else {
            MalisisCore.log.info("Loading texture and data for " + this.font.getName());
            img = this.readTextureFile(textureFile);
            this.readUVFile(uvFile);
        }
        if (img == null) {
            return;
        }
        if (this.textureRl != null) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(this.textureRl);
        }
        DynamicTexture dynTex = new DynamicTexture(img);
        this.textureRl = Minecraft.func_71410_x().func_110434_K().func_110578_a(this.font.getName(), dynTex);
    }

    protected BufferedImage readTextureFile(File textureFile) {
        try {
            BufferedImage img = ImageIO.read(textureFile);
            this.size = img.getWidth();
            return img;
        }
        catch (IOException e) {
            MalisisCore.log.error("Failed to read font texture.", (Throwable)e);
            return null;
        }
    }

    protected void readUVFile(File uvFile) {
        int i = 0;
        try {
            for (String str : Files.readLines((File)uvFile, (Charset)StandardCharsets.UTF_8)) {
                String[] split = str.split(";");
                CharData cd = this.charData[i++];
                cd.setUVs(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4]));
            }
        }
        catch (IOException | NumberFormatException e) {
            MalisisCore.log.error("Failed to read font data. (Line " + i + " (" + (char)i + ")", (Throwable)e);
        }
    }

    public static Font load(ResourceLocation rl, FontGeneratorOptions options) {
        try {
            return MalisisFont.load(Minecraft.func_71410_x().func_110442_L().func_110536_a(rl).func_110527_b(), options);
        }
        catch (IOException e) {
            MalisisCore.log.error("[MalisiFont] Couldn't load font from ResourceLocation.", (Throwable)e);
            return null;
        }
    }

    public static Font load(File file, FontGeneratorOptions options) {
        try {
            return MalisisFont.load(new FileInputStream(file), options);
        }
        catch (FileNotFoundException e) {
            MalisisCore.log.error("[MalisiFont] Couldn't load font from File.", (Throwable)e);
            return null;
        }
    }

    public static Font load(InputStream is, FontGeneratorOptions options) {
        try {
            Font font = Font.createFont(options.fontType, is);
            return font.deriveFont(options.fontSize);
        }
        catch (FontFormatException | IOException e) {
            MalisisCore.log.error("[MalisiFont] Couldn't load font from InputStream.", (Throwable)e);
            return null;
        }
    }
}

