/*
 * Decompiled with CFR 0.152.
 */
package com.temportalist.origin.api.client.gui.widget;

import com.temportalist.origin.api.client.gui.IGuiScreen;
import com.temportalist.origin.api.client.gui.widget.Component;
import com.temportalist.origin.api.client.gui.widget.IWidgetOwner;
import com.temportalist.origin.api.client.utility.Rendering;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WidgetTree {
    IWidgetOwner owner;
    GuiScreen parentScreen;
    final int boxX;
    final int boxY;
    final int boxW;
    final int boxH;
    int minColumn;
    int maxColumn;
    int minRow;
    int maxRow;
    int innerBoxLeft;
    int innerBoxRight;
    int innerBoxTop;
    int innerBoxBottom;
    int innerBoxWidth;
    int innerBoxHeight;
    int bufferW;
    int bufferH;
    float scale = 1.0f;
    final ResourceLocation background;
    protected double prevMapPosX;
    protected double prevMapPosY;
    protected double mapPosX;
    protected double mapPosY;
    protected double savedMapPosX_maybe;
    protected double savedMapPosY_maybe;
    private int isMouseButtonDown;
    protected int mouseX_Saved;
    protected int mouseY_Saved;
    protected float some_float_value = 1.0f;
    List<Component> components = new ArrayList<Component>();

    public WidgetTree(IWidgetOwner owner, IGuiScreen parentScreen, int x, int y, int boxWidth, int boxHeight, int minCol, int maxCol, int minRow, int maxRow, int startingCol, int startingRow, ResourceLocation background) {
        this.owner = owner;
        this.parentScreen = (GuiScreen)parentScreen;
        this.boxX = x;
        this.boxY = y;
        this.boxW = boxWidth;
        this.boxH = boxHeight;
        this.minColumn = minCol;
        this.maxColumn = maxCol;
        this.minRow = minRow;
        this.maxRow = maxRow;
        this.updateBox(this.minColumn, this.maxColumn, this.minRow, this.maxRow);
        this.background = background;
        int offsetX = 141;
        int offsetY = 141;
        this.mapPosX = this.savedMapPosX_maybe = (double)(startingCol * 24 - offsetX / 2 - 12);
        this.prevMapPosX = this.savedMapPosX_maybe;
        this.mapPosY = this.savedMapPosY_maybe = (double)(startingRow * 24 - offsetY / 2);
        this.prevMapPosY = this.savedMapPosY_maybe;
    }

    public void addComponent(Component comp) {
        this.components.add(comp);
    }

    public void updateBox(int minCol, int maxCol, int minRow, int maxRow) {
        this.bufferW = 50;
        this.bufferH = 50;
        this.innerBoxLeft = minCol * 24 - this.bufferW;
        this.innerBoxRight = (maxCol + 1) * 24 + this.bufferW;
        this.innerBoxWidth = this.innerBoxRight + this.bufferW;
        this.innerBoxTop = minRow * 24 - this.bufferH;
        this.innerBoxBottom = (maxRow + 1) * 24 + this.bufferH;
        this.innerBoxHeight = this.innerBoxBottom + this.bufferH;
        if (this.innerBoxWidth > this.innerBoxHeight) {
            this.innerBoxHeight = this.innerBoxWidth;
            this.innerBoxBottom = this.innerBoxRight;
        } else {
            this.innerBoxWidth = this.innerBoxHeight;
            this.innerBoxRight += this.innerBoxBottom;
        }
    }

    public void updateWidget() {
        this.prevMapPosX = this.mapPosX;
        this.prevMapPosY = this.mapPosY;
        double mapX = this.savedMapPosX_maybe - this.mapPosX;
        double mapY = this.savedMapPosY_maybe - this.mapPosY;
        if (mapX * mapX + mapY * mapY < 4.0) {
            this.mapPosX += mapX;
            this.mapPosY += mapY;
        } else {
            this.mapPosX += mapX * 0.85;
            this.mapPosY += mapY * 0.85;
        }
    }

    public void drawWidget(int mouseX, int mouseY, float rpt) {
        if (Mouse.isButtonDown((int)0)) {
            if ((this.isMouseButtonDown == 0 || this.isMouseButtonDown == 1) && mouseX >= this.boxX && mouseX < this.boxX + this.boxW && mouseY >= this.boxY && mouseY < this.boxY + this.boxH) {
                if (this.isMouseButtonDown == 0) {
                    this.isMouseButtonDown = 1;
                } else {
                    this.mapPosX -= (double)((float)(mouseX - this.mouseX_Saved) * this.some_float_value);
                    this.mapPosY -= (double)((float)(mouseY - this.mouseY_Saved) * this.some_float_value);
                    this.savedMapPosX_maybe = this.prevMapPosX = this.mapPosX;
                    this.savedMapPosY_maybe = this.prevMapPosY = this.mapPosY;
                }
                this.mouseX_Saved = mouseX;
                this.mouseY_Saved = mouseY;
            }
        } else {
            this.isMouseButtonDown = 0;
        }
        this.drawComponents(mouseX, mouseY, rpt);
    }

    protected void drawComponents(int mouseX, int mouseY, float rpt) {
        int currentMapPosX = this.getCurrentMapPosX(rpt);
        int currentMapPosY = this.getCurrentMapPosY(rpt);
        GL11.glDepthFunc((int)518);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.boxX, (float)this.boxY, (float)0.0f);
        GL11.glScalef((float)(1.0f / this.some_float_value), (float)(1.0f / this.some_float_value), (float)0.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glPushMatrix();
        this.drawStaticBackground(currentMapPosX, currentMapPosY);
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        for (int index = 0; index < this.components.size(); ++index) {
            int compY;
            Component comp = this.components.get(index);
            int compX = comp.getDisplayColumn() * 24 - currentMapPosX;
            if (!this.isWithinArea(compX, compY = comp.getDisplayRow() * 24 - currentMapPosY, -22, this.boxW, -22, this.boxH)) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int leftOffset = 0;
            if ((float)compX <= 0.0f) {
                leftOffset = Math.abs(compX);
            }
            int rightOffset = 0;
            if ((float)(compX + 24) >= (float)this.boxW) {
                rightOffset = compX + 24 - this.boxW;
            }
            int topOffset = 0;
            if ((float)compY <= 0.0f) {
                topOffset = Math.abs(compY);
            }
            int bottomOffset = 0;
            if ((float)(compY + 24) >= (float)this.boxH) {
                bottomOffset = compY + 24 - this.boxH;
            }
            comp.draw((IGuiScreen)this.parentScreen, compX - 2, compY - 2, leftOffset, rightOffset, topOffset, bottomOffset);
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3553);
    }

    private int getCurrentMapPosX(float rpt) {
        return this.getWithin(MathHelper.func_76128_c((double)(this.prevMapPosX + (this.mapPosX - this.prevMapPosX) * (double)rpt)), this.innerBoxLeft, this.innerBoxRight - (this.innerBoxWidth - (this.innerBoxWidth - this.boxW)));
    }

    private int getCurrentMapPosY(float rpt) {
        return this.getWithin(MathHelper.func_76128_c((double)(this.prevMapPosY + (this.mapPosY - this.prevMapPosY) * (double)rpt)), this.innerBoxTop, this.innerBoxBottom - (this.innerBoxHeight - (this.innerBoxHeight - this.boxH)));
    }

    private boolean isWithinArea(int x, int y, int left, int right, int top, int bottom) {
        return x >= left && y >= top && (float)x <= (float)right && (float)y <= (float)bottom;
    }

    private int getWithin(int pos, int min, int max) {
        return (int)this.getWithin((double)pos, (double)min, (double)max);
    }

    private double getWithin(double pos, double min, double max) {
        if (pos < min) {
            return min;
        }
        if (pos >= max) {
            return max - 1.0;
        }
        return pos;
    }

    private void drawStaticBackground(int currentMapX, int currentMapY) {
        Rendering.bindResource(this.background);
        float scaleW = (float)this.innerBoxWidth / 256.0f;
        float scaleH = (float)this.innerBoxHeight / 256.0f;
        GL11.glScalef((float)scaleW, (float)scaleH, (float)1.0f);
        this.parentScreen.func_73729_b(0, 0, (int)((float)(currentMapX + this.bufferW) / scaleW), (int)((float)(currentMapY + this.bufferH) / scaleH), (int)((float)this.boxW / scaleW) + 1, (int)((float)this.boxH / scaleH) + 1);
        GL11.glScalef((float)(1.0f / scaleW), (float)(1.0f / scaleH), (float)1.0f);
    }

    private void drawMovingBackground(int currentMapX, int currentMapY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int texWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int texHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        float scaleW = 1.0f;
        float scaleH = 1.0f;
        int width = this.innerBoxRight - this.innerBoxLeft;
        int height = this.innerBoxBottom - this.innerBoxTop;
        int right = this.boxX + width;
        int bottom = this.boxY + height;
        int vx = (int)((float)((currentMapX - this.boxX) / Math.abs(this.boxX - bottom)) * 288.0f);
        int vy = (int)((float)((currentMapY - this.boxY) / Math.abs(this.boxY - right)) * 316.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        Rendering.bindResource(this.background);
        this.parentScreen.func_73729_b(0, 0, vx / 2, vy / 2, this.boxW / 2, this.boxH / 2);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
    }

    public void onMouseClick(int mouseX, int mouseY, int mouseButton) {
        Component comp = this.getComponentAtMouse(mouseX, mouseY);
        if (comp != null) {
            comp.onClick();
        }
    }

    public void addHoverInformation(int mouseX, int mouseY, List<String> hoverInfo) {
        Component comp = this.getComponentAtMouse(mouseX, mouseY);
        if (comp != null) {
            comp.onHover(hoverInfo);
        }
    }

    private Component getComponentAtMouse(int mouseX, int mouseY) {
        if (this.isWithinArea(mouseX, mouseY, this.boxX, this.boxX + this.boxW, this.boxY, this.boxY + this.boxH)) {
            int currentMapPosX = this.getCurrentMapPosX(0.0f);
            int currentMapPosY = this.getCurrentMapPosY(0.0f);
            for (int i = 0; i < this.components.size(); ++i) {
                int compY;
                Component comp = this.components.get(i);
                int compX = comp.getDisplayColumn() * 24 - currentMapPosX;
                if (!this.isWithinArea(compX, compY = comp.getDisplayRow() * 24 - currentMapPosY, -22, this.boxW, -22, this.boxH) || !this.isWithinArea(mouseX, mouseY, this.boxX + compX, this.boxX + compX + 22, this.boxY + compY, this.boxY + compY + 22)) continue;
                return comp;
            }
        }
        return null;
    }
}

