/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.exnihilo.commands;

import exnihilo.registries.CompostRegistry;
import exnihilo.registries.CrucibleRegistry;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.Compostable;
import exnihilo.registries.helpers.Meltable;
import exnihilo.registries.helpers.Smashable;
import exnihilo.utils.ItemInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.ICommandFunction;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StringHelper;
import modtweaker2.mods.exnihilo.ExNihiloHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ExNihiloLogger
implements ICommandFunction {
    private static final List<String> validArguments = new LinkedList<String>();

    public void execute(String[] arguments, IPlayer player) {
        List<String> args = StringHelper.toLowerCase(Arrays.asList(arguments));
        if (!validArguments.containsAll(args)) {
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("Invalid arguments for command. Valid arguments: " + StringHelper.join(validArguments, ", ")));
            }
        } else {
            if (args.isEmpty() || args.contains("compost")) {
                for (Map.Entry entry : CompostRegistry.entries.entrySet()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.exnihilo.Composting.addRecipe(%s, %s, \"%s\");", LogHelper.getStackDescription(((ItemInfo)entry.getKey()).getStack()), Float.valueOf(((Compostable)entry.getValue()).value), Integer.toHexString(((Compostable)entry.getValue()).color.toInt()).substring(2)));
                }
            }
            if (args.isEmpty() || args.contains("crucible")) {
                for (Meltable meltable : CrucibleRegistry.entries.values()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.exnihilo.Crucible.addRecipe(%s, %s);", LogHelper.getStackDescription(new ItemStack(meltable.block, 1, meltable.meta)), LogHelper.getStackDescription(new FluidStack(meltable.fluid, (int)meltable.fluidVolume))));
                }
                for (Map.Entry<Object, Object> entry : ExNihiloHelper.getHeatMap().entrySet()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.exnihilo.Crucible.addHeatSource(%s, %s);", LogHelper.getStackDescription(((ItemInfo)entry.getKey()).getStack()), entry.getValue()));
                }
            }
            if (args.isEmpty() || args.contains("hammer")) {
                for (Map.Entry<Object, Object> entry : HammerRegistry.getRewards().entrySet()) {
                    for (Smashable recipe : (ArrayList)entry.getValue()) {
                        MineTweakerAPI.logCommand((String)String.format("mods.exnihilo.Hammer.addRecipe(%s, %s, %s, %s);", LogHelper.getStackDescription(((ItemInfo)entry.getKey()).getStack()), LogHelper.getStackDescription(new ItemStack(recipe.item, 1, recipe.meta)), Float.valueOf(recipe.chance), Float.valueOf(recipe.luckMultiplier)));
                    }
                }
            }
            if (args.isEmpty() || args.contains("sieve")) {
                for (Map.Entry<Object, Object> entry : SieveRegistry.getSiftables().entrySet()) {
                    for (Smashable recipe : (ArrayList)entry.getValue()) {
                        MineTweakerAPI.logCommand((String)String.format("mods.exnihilo.Sieve.addRecipe(%s, %s, %s);", LogHelper.getStackDescription(((ItemInfo)entry.getKey()).getStack()), LogHelper.getStackDescription(new ItemStack(recipe.item, 1, recipe.meta)), recipe.rarity));
                    }
                }
            }
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("List generated; see minetweaker.log in your minecraft dir"));
            }
        }
    }

    static {
        validArguments.add("compost");
        validArguments.add("crucible");
        validArguments.add("hammer");
        validArguments.add("sieve");
    }
}

