/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.factorization.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.factorization.FactorizationHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorization.SlagFurnace")
public class SlagFurnace {
    public static final String name = "Factorization Slag Furnace";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output2, double chance2, IItemStack output1, double chance1) {
        Object recipe = FactorizationHelper.getSlagFurnaceRecipe(InputHelper.toStack(input), (float)chance1, InputHelper.toStack(output1), (float)chance2, InputHelper.toStack(output2));
        MineTweakerAPI.apply((IUndoableAction)new Add(InputHelper.toStack(input), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<Object> recipes = new LinkedList<Object>();
        for (Object r : FactorizationHelper.slag) {
            ItemStack in;
            if (r == null || !StackHelper.matches(input, InputHelper.toIItemStack(in = (ItemStack)ReflectionHelper.getObject(r, "input")))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, input));
        }
    }

    private static class Remove
    extends BaseListRemoval<Object> {
        public Remove(List<Object> recipes) {
            super(SlagFurnace.name, FactorizationHelper.slag, recipes);
        }

        @Override
        public String getRecipeInfo(Object recipe) {
            return LogHelper.getStackDescription((ItemStack)ReflectionHelper.getObject(recipe, "input"));
        }
    }

    private static class Add
    extends BaseListAddition<Object> {
        public Add(ItemStack input, Object recipe) {
            super(SlagFurnace.name, FactorizationHelper.slag);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(Object recipe) {
            return LogHelper.getStackDescription((ItemStack)ReflectionHelper.getObject(recipe, "input"));
        }
    }
}

