/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.railcraft.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import mods.railcraft.api.crafting.ICokeOvenRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.util.crafting.CokeOvenCraftingManager;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.railcraft.RailcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.railcraft.CokeOven")
public class CokeOven {
    public static final String name = "Railcraft Coke Oven";

    @ZenMethod
    public static void addRecipe(IItemStack itemOutput, ILiquidStack fluidOutput, IItemStack ingredient, int timePerItem) {
        boolean matchEmptyNBT = InputHelper.toStack((IItemStack)ingredient).field_77990_d != null;
        if (ingredient.getDamage() == Short.MAX_VALUE) {
            MineTweakerAPI.apply((IUndoableAction)new Add((ICokeOvenRecipe)new CokeOvenCraftingManager.CokeOvenRecipe(InputHelper.toStack(ingredient), false, matchEmptyNBT, InputHelper.toStack(itemOutput), InputHelper.toFluid(fluidOutput), timePerItem)));
        } else {
            MineTweakerAPI.apply((IUndoableAction)new Add((ICokeOvenRecipe)new CokeOvenCraftingManager.CokeOvenRecipe(InputHelper.toStack(ingredient), true, matchEmptyNBT, InputHelper.toStack(itemOutput), InputHelper.toFluid(fluidOutput), timePerItem)));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack itemOutput, ILiquidStack fluidOutput, IItemStack ingredient, boolean matchEmptyNBT, int timePerItem) {
        if (ingredient.getDamage() == Short.MAX_VALUE) {
            MineTweakerAPI.apply((IUndoableAction)new Add((ICokeOvenRecipe)new CokeOvenCraftingManager.CokeOvenRecipe(InputHelper.toStack(ingredient), false, matchEmptyNBT, InputHelper.toStack(itemOutput), InputHelper.toFluid(fluidOutput), timePerItem)));
        } else {
            MineTweakerAPI.apply((IUndoableAction)new Add((ICokeOvenRecipe)new CokeOvenCraftingManager.CokeOvenRecipe(InputHelper.toStack(ingredient), true, matchEmptyNBT, InputHelper.toStack(itemOutput), InputHelper.toFluid(fluidOutput), timePerItem)));
        }
    }

    @Deprecated
    @ZenMethod
    public static void addRecipe(IItemStack input, boolean matchDamage, boolean matchNBT, IItemStack output, ILiquidStack fluidOutput, int cookTime) {
        MineTweakerAPI.apply((IUndoableAction)new Add((ICokeOvenRecipe)new CokeOvenCraftingManager.CokeOvenRecipe(InputHelper.toStack(input), matchDamage, matchNBT, InputHelper.toStack(output), InputHelper.toFluid(fluidOutput), cookTime)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<ICokeOvenRecipe> recipes = new LinkedList<ICokeOvenRecipe>();
        for (ICokeOvenRecipe iCokeOvenRecipe : RailcraftHelper.oven) {
            if (iCokeOvenRecipe.getOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(iCokeOvenRecipe.getOutput()))) continue;
            recipes.add(iCokeOvenRecipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<ICokeOvenRecipe> {
        public Remove(List<ICokeOvenRecipe> recipes) {
            super(CokeOven.name, RailcraftHelper.oven, recipes);
        }

        @Override
        public String getRecipeInfo(ICokeOvenRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }

    private static class Add
    extends BaseListAddition<ICokeOvenRecipe> {
        public Add(ICokeOvenRecipe recipe) {
            super(CokeOven.name, RailcraftCraftingManager.cokeOven.getRecipes());
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(ICokeOvenRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }
}

