/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.tconstruct.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.mods.tconstruct.TConstructHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tconstruct.library.crafting.PatternBuilder;

@ZenClass(value="mods.tconstruct.Tweaks")
public class TiCTweaks {
    @ZenMethod
    public static void addRepairMaterial(IItemStack stack, String material, int value) {
        ItemStack input = InputHelper.toStack(stack);
        MineTweakerAPI.apply((IUndoableAction)new Add(TConstructHelper.getItemKey(input.func_77973_b(), input.func_77960_j(), value, material)));
    }

    @ZenMethod
    public static void removeRepairMaterial(IIngredient output, @Optional String material) {
        LinkedList<PatternBuilder.ItemKey> recipes = new LinkedList<PatternBuilder.ItemKey>();
        for (PatternBuilder.ItemKey recipe : PatternBuilder.instance.materials) {
            IItemStack clone = InputHelper.toIItemStack(new ItemStack(recipe.item, 1, recipe.damage));
            if ((material == null || !material.equalsIgnoreCase(recipe.key)) && material != null || !output.matches(clone)) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        }
    }

    private static class Remove
    extends BaseListRemoval<PatternBuilder.ItemKey> {
        public Remove(List<PatternBuilder.ItemKey> recipes) {
            super("Repair Material", PatternBuilder.instance.materials, recipes);
        }

        @Override
        protected String getRecipeInfo(PatternBuilder.ItemKey recipe) {
            return LogHelper.getStackDescription(new ItemStack(recipe.item, 1, recipe.damage));
        }
    }

    private static class Add
    extends BaseListAddition<PatternBuilder.ItemKey> {
        public Add(PatternBuilder.ItemKey recipe) {
            super("Repair Material", PatternBuilder.instance.materials);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(PatternBuilder.ItemKey recipe) {
            return LogHelper.getStackDescription(new ItemStack(recipe.item, 1, recipe.damage));
        }
    }
}

