/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.common.Handlers;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.enchant.EnchantAutoSmelt;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.world.BlockEvent;

@Handlers.Handler(value={Handlers.Handler.HandlerType.FORGE})
public class AutoSmeltHandler {
    @SubscribeEvent
    public void handleBlockBreak(BlockEvent.HarvestDropsEvent event) {
        ItemStack held;
        if (!event.world.field_72995_K && event.harvester != null && (held = event.harvester.func_71045_bC()) != null) {
            int level = this.getAutoSmeltLevel(held);
            int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)held);
            if (level >= 0) {
                for (int i = 0; i < event.drops.size(); ++i) {
                    int j;
                    ItemStack stack = (ItemStack)event.drops.get(i);
                    if (stack == null || event.isSilkTouching || FurnaceRecipes.func_77602_a().func_151395_a(stack) == null) continue;
                    ItemStack furnaceStack = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
                    if (fortune > 0 && ConfigHandler.allowAutoSmeltWithFortune) {
                        furnaceStack.field_77994_a *= event.world.field_73012_v.nextInt(fortune + 1) + 1;
                    }
                    event.drops.set(i, furnaceStack);
                    int xp = furnaceStack.field_77994_a;
                    float f = FurnaceRecipes.func_77602_a().func_151398_b(furnaceStack);
                    if (f == 0.0f) {
                        xp = 0;
                    } else if (f < 1.0f) {
                        j = MathHelper.func_76141_d((float)((float)xp * f));
                        if (j < MathHelper.func_76123_f((float)((float)xp * f)) && (float)Math.random() < (float)xp * f - (float)j) {
                            ++j;
                        }
                        xp = j;
                    }
                    while (xp > 0) {
                        j = EntityXPOrb.func_70527_a((int)xp);
                        xp -= j;
                        event.world.func_72838_d((Entity)new EntityXPOrb(event.world, (double)event.x, (double)event.y + 0.5, (double)event.z, j));
                    }
                }
            }
        }
    }

    private int getAutoSmeltLevel(ItemStack tool) {
        if (tool == null) {
            return -1;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)tool);
        Iterator iterator = enchants.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Enchantment enchant = Enchantment.field_77331_b[i];
            if (enchant != EnchantAutoSmelt.INSTANCE) continue;
            return (Integer)enchants.get(i);
        }
        return -1;
    }
}

