/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import com.enderio.core.common.util.EnderFileUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.IResourcePack;
import org.apache.commons.io.FileUtils;

public class ResourcePackAssembler {
    private List<File> icons = new ArrayList<File>();
    private List<File> langs = new ArrayList<File>();
    private List<CustomFile> customs = new ArrayList<CustomFile>();
    private static List<IResourcePack> defaultResourcePacks;
    private static final String MC_META_BASE = "{\"pack\":{\"pack_format\":1,\"description\":\"%s\"}}";
    private File dir;
    private File zip;
    private String name;
    private String mcmeta;
    private String modid;
    private boolean hasPackPng = false;
    private Class<?> jarClass;

    public ResourcePackAssembler(File directory, String packName, String modid) {
        this.dir = directory;
        this.zip = new File(this.dir.getAbsolutePath() + ".zip");
        this.name = packName;
        this.modid = modid.toLowerCase();
        this.mcmeta = String.format(MC_META_BASE, this.name);
    }

    public ResourcePackAssembler setHasPackPng(Class<?> jarClass) {
        this.jarClass = jarClass;
        this.hasPackPng = true;
        return this;
    }

    public void addIcon(File icon) {
        this.icons.add(icon);
    }

    public void addLang(File lang) {
        this.langs.add(lang);
    }

    public void addCustomFile(String path, File file) {
        this.customs.add(new CustomFile(path, file));
    }

    public void addCustomFile(File file) {
        this.addCustomFile(null, file);
    }

    public ResourcePackAssembler assemble() {
        EnderFileUtils.safeDeleteDirectory(this.dir);
        this.dir.mkdirs();
        String pathToDir = this.dir.getAbsolutePath();
        File metaFile = new File(pathToDir + "/pack.mcmeta");
        try {
            this.writeNewFile(metaFile, this.mcmeta);
            if (this.hasPackPng) {
                EnderFileUtils.copyFromJar(this.jarClass, this.modid + "/" + "pack.png", new File(this.dir.getAbsolutePath() + "/pack.png"));
            }
            String itemsDir = pathToDir + "/assets/" + this.modid + "/textures/items";
            String blocksDir = pathToDir + "/assets/" + this.modid + "/textures/blocks";
            String langDir = pathToDir + "/assets/" + this.modid + "/lang";
            for (File icon : this.icons) {
                FileUtils.copyFile((File)icon, (File)new File(itemsDir + "/" + icon.getName()));
                FileUtils.copyFile((File)icon, (File)new File(blocksDir + "/" + icon.getName()));
            }
            for (File lang : this.langs) {
                FileUtils.copyFile((File)lang, (File)new File(langDir + "/" + lang.getName()));
            }
            for (CustomFile custom : this.customs) {
                File directory = new File(pathToDir + (custom.ext != null ? "/" + custom.ext : ""));
                directory.mkdirs();
                FileUtils.copyFile((File)custom.file, (File)new File(directory.getAbsolutePath() + "/" + custom.file.getName()));
            }
            EnderFileUtils.zipFolderContents(this.dir, this.zip);
            EnderFileUtils.safeDeleteDirectory(this.dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void inject() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            try {
                if (defaultResourcePacks == null) {
                    defaultResourcePacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao", "ap"});
                }
                File dest = new File(this.dir.getParent() + "/resourcepack/" + this.zip.getName());
                EnderFileUtils.safeDelete(dest);
                FileUtils.copyFile((File)this.zip, (File)dest);
                EnderFileUtils.safeDelete(this.zip);
                this.writeNewFile(new File(dest.getParent() + "/readme.txt"), EnderCore.lang.localize("resourcepack.readme") + "\n\n" + EnderCore.lang.localize("resourcepack.readme2"));
                defaultResourcePacks.add((IResourcePack)new FileResourcePack(dest));
            }
            catch (Exception e) {
                EnderCore.logger.error("Failed to inject resource pack for mod {}", new Object[]{this.modid, e});
            }
        } else {
            EnderCore.logger.info("Skipping resource pack, we are on a dedicated server.");
        }
    }

    private void writeNewFile(File file, String defaultText) throws IOException {
        EnderFileUtils.safeDelete(file);
        file.delete();
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileWriter fw = new FileWriter(file);
        fw.write(defaultText);
        fw.flush();
        fw.close();
    }

    private class CustomFile {
        private String ext;
        private File file;

        @ConstructorProperties(value={"ext", "file"})
        public CustomFile(String ext, File file) {
            this.ext = ext;
            this.file = file;
        }
    }
}

