/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.client.render;

import com.cricketcraft.chisel.api.carving.CarvingUtils;
import com.cricketcraft.chisel.api.rendering.TextureType;
import com.cricketcraft.chisel.client.render.SubmapManagerBase;
import com.cricketcraft.ctmlib.RenderBlocksCTM;
import com.cricketcraft.ctmlib.TextureSubmap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Triple;

public class SubmapManagerRCTM
extends SubmapManagerBase {
    @SideOnly(value=Side.CLIENT)
    private RenderBlocksCTM rb;
    private TextureSubmap submap;
    private TextureSubmap smallSubmap;
    private int size;
    private String texturePath;
    private int meta;
    private IIcon defaultIcon;
    private TextureType rType;

    public SubmapManagerRCTM(int meta, String texturePath, TextureType rType) {
        assert (rType == TextureType.R16 || rType == TextureType.R9 || rType == TextureType.R4) : "Not a valid random type!";
        this.meta = meta;
        this.texturePath = texturePath;
        this.size = Integer.parseInt(rType.name().substring(1, rType.name().length()));
        this.rType = rType;
    }

    @Override
    public IIcon getIcon(int side, int meta) {
        return this.defaultIcon;
    }

    @Override
    public RenderBlocks createRenderContext(RenderBlocks rendererOld, Block block, IBlockAccess world) {
        if (this.rb == null) {
            this.rb = new RenderBlocksRCTM();
        }
        this.rb.func_147775_a(block);
        return this.rb;
    }

    @Override
    public void registerIcons(String modName, Block block, IIconRegister register) {
        IIcon base = register.func_94245_a(modName + ":" + this.texturePath);
        TextureSubmap[][] submaps = new TextureSubmap[this.size][this.size];
        TextureSubmap[][] submapsSmall = new TextureSubmap[this.size][this.size];
        int wh = (int)Math.sqrt(this.size);
        for (int i = 0; i < this.size; ++i) {
            TextureType.AbstractSubmapManager manager = (TextureType.AbstractSubmapManager)TextureType.CTMX.createManagerFor(CarvingUtils.getDefaultVariationFor(block, this.meta, 0), this.texturePath + "-ctm-" + i);
            manager.registerIcons(modName, block, register);
            Object cached = manager.getCachedObject();
            Triple triple = (Triple)cached;
            submaps[this.size % wh][this.size / wh] = (TextureSubmap)triple.getMiddle();
            submapsSmall[this.size % wh][this.size / wh] = (TextureSubmap)triple.getRight();
            if (i != 0) continue;
            this.defaultIcon = ((TextureSubmap)triple.getRight()).getSubIcon(0, 0);
        }
        this.submap = new Submap(base, wh, submaps);
        this.smallSubmap = new Submap(base, wh, submapsSmall);
    }

    private class Submap
    extends TextureSubmap {
        private TextureSubmap[][] submap;

        public Submap(IIcon base, int wh, TextureSubmap[][] submap) {
            super(base, wh, wh);
            this.submap = submap;
        }

        @Override
        public void TexturesStitched(TextureStitchEvent.Post event) {
            super.TexturesStitched(event);
            for (int i = 0; i < this.icons.length; ++i) {
                for (int j = 0; j < this.icons[i].length; ++j) {
                    this.icons[i][j] = this.submap[i][j];
                    this.submap[i][j].TexturesStitched(event);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class RenderBlocksRCTM
    extends RenderBlocksCTM {
        private RenderBlocksRCTM() {
        }

        @Override
        public void func_147798_e(Block block, double x, double y, double z, IIcon icon) {
            this.submap = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.submap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.WEST.ordinal());
            this.submapSmall = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.smallSubmap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.WEST.ordinal());
            super.func_147798_e(block, x, y, z, icon);
        }

        @Override
        public void func_147764_f(Block block, double x, double y, double z, IIcon icon) {
            this.submap = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.submap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.EAST.ordinal());
            this.submapSmall = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.smallSubmap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.EAST.ordinal());
            super.func_147764_f(block, x, y, z, icon);
        }

        @Override
        public void func_147768_a(Block block, double x, double y, double z, IIcon icon) {
            this.submap = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.submap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.DOWN.ordinal());
            this.submapSmall = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.smallSubmap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.DOWN.ordinal());
            super.func_147768_a(block, x, y, z, icon);
        }

        @Override
        public void func_147806_b(Block block, double x, double y, double z, IIcon icon) {
            this.submap = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.submap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.UP.ordinal());
            this.submapSmall = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.smallSubmap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.UP.ordinal());
            super.func_147806_b(block, x, y, z, icon);
        }

        @Override
        public void func_147761_c(Block block, double x, double y, double z, IIcon icon) {
            this.submap = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.submap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.NORTH.ordinal());
            this.submapSmall = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.smallSubmap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.UP.ordinal());
            super.func_147761_c(block, x, y, z, icon);
        }

        @Override
        public void func_147734_d(Block block, double x, double y, double z, IIcon icon) {
            this.submap = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.submap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.SOUTH.ordinal());
            this.submapSmall = (TextureSubmap)TextureType.getRIcon(SubmapManagerRCTM.this.rType, SubmapManagerRCTM.this.smallSubmap, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), ForgeDirection.SOUTH.ordinal());
            super.func_147734_d(block, x, y, z, icon);
        }
    }
}

