/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.ctmlib;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

public class TextureSubmap
implements IIcon {
    private static List<TextureSubmap> submaps = Lists.newArrayList();
    private static TextureSubmap dummy = new TextureSubmap(null, 0, 0);
    private int width;
    private int height;
    private IIcon baseIcon;
    protected IIcon[][] icons;

    public TextureSubmap(IIcon baseIcon, int width, int height) {
        this.baseIcon = baseIcon;
        this.width = width;
        this.height = height;
        this.icons = new IIcon[width][height];
        submaps.add(this);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public IIcon getBaseIcon() {
        return this.baseIcon;
    }

    public IIcon getSubIcon(int x, int y) {
        return this.icons[x][y % this.icons[x %= this.icons.length].length];
    }

    @SubscribeEvent
    public void TexturesStitched(TextureStitchEvent.Post event) {
        for (TextureSubmap ts : submaps) {
            for (int x = 0; x < ts.width; ++x) {
                for (int y = 0; y < ts.height; ++y) {
                    ts.icons[x][y] = new TextureVirtual(ts.getBaseIcon(), ts.width, ts.height, x, y);
                }
            }
        }
    }

    public int func_94211_a() {
        return this.baseIcon.func_94211_a();
    }

    public int func_94216_b() {
        return this.baseIcon.func_94216_b();
    }

    public float func_94209_e() {
        return this.baseIcon.func_94209_e();
    }

    public float func_94212_f() {
        return this.baseIcon.func_94212_f();
    }

    public float func_94214_a(double arg0) {
        return this.baseIcon.func_94214_a(arg0);
    }

    public float func_94206_g() {
        return this.baseIcon.func_94206_g();
    }

    public float func_94210_h() {
        return this.baseIcon.func_94210_h();
    }

    public float func_94207_b(double arg0) {
        return this.baseIcon.func_94207_b(arg0);
    }

    public String func_94215_i() {
        return this.baseIcon.func_94215_i();
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)dummy);
    }

    private class TextureVirtual
    implements IIcon {
        private int width;
        private int height;
        private float umin;
        private float umax;
        private float vmin;
        private float vmax;
        private String name;
        private IIcon parentIcon;

        private TextureVirtual(IIcon parent, int w, int h, int x, int y) {
            this.parentIcon = parent;
            this.umin = this.parentIcon.func_94214_a(16.0 * (double)x / (double)w);
            this.umax = this.parentIcon.func_94214_a(16.0 * (double)(x + 1) / (double)w);
            this.vmin = this.parentIcon.func_94207_b(16.0 * (double)y / (double)h);
            this.vmax = this.parentIcon.func_94207_b(16.0 * (double)(y + 1) / (double)h);
            this.name = this.parentIcon.func_94215_i() + "|" + x + "." + y;
            this.width = this.parentIcon.func_94211_a();
            this.height = this.parentIcon.func_94216_b();
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94209_e() {
            return this.umin;
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94212_f() {
            return this.umax;
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94214_a(double d0) {
            return (float)((double)this.umin + (double)(this.umax - this.umin) * d0 / 16.0);
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94206_g() {
            return this.vmin;
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94210_h() {
            return this.vmax;
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94207_b(double d0) {
            return (float)((double)this.vmin + (double)(this.vmax - this.vmin) * d0 / 16.0);
        }

        @SideOnly(value=Side.CLIENT)
        public String func_94215_i() {
            return this.name;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_94211_a() {
            return this.width;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_94216_b() {
            return this.height;
        }
    }
}

