/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Iterator;
import toast.specialAI.Properties;
import toast.specialAI._SpecialAI;
import toast.specialAI.ai.GriefSearch;

public class SearchHandler {
    private static final int MAX_SCAN = Math.max(1, Properties.getInt("passive_griefing", "grief_scan_cap"));
    private static final int SCAN_CAP = Math.max(1, Properties.getInt("passive_griefing", "grief_scan_max"));
    private static final boolean DEBUG_MESSGAE = Properties.getBoolean("passive_griefing", "grief_scan_cap_info");
    private static final ArrayList<GriefSearch> scanners = new ArrayList();
    public static int scansLeft;
    private int updateCounter;

    public static GriefSearch addScanner(GriefSearch scanner) {
        if (scanners.size() < SCAN_CAP) {
            scanners.add(scanner);
            return scanner;
        }
        if (DEBUG_MESSGAE) {
            _SpecialAI.console("Scan request rejected - cap reached!");
        }
        return null;
    }

    public static void removeScanner(GriefSearch scanner) {
        if (scanner != null) {
            scanners.remove(scanner);
        }
    }

    public SearchHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !scanners.isEmpty()) {
            scansLeft = MAX_SCAN;
            Iterator<GriefSearch> iterator = scanners.iterator();
            while (iterator.hasNext() && scansLeft > 0) {
                GriefSearch scanner = iterator.next();
                if (scanner.isValid()) {
                    scanner.runSearch();
                    if (!scanner.complete) continue;
                    scanner.clear();
                    iterator.remove();
                    continue;
                }
                scanner.clear();
                iterator.remove();
            }
        }
    }
}

