/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.blocks;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.items.CCubesItems;
import chanceCubes.items.ItemChanceCube;
import chanceCubes.registry.ChanceCubeRegistry;
import chanceCubes.tileentities.TileChanceCube;
import chanceCubes.util.GiantCubeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class BlockChanceCube
extends Block
implements ITileEntityProvider {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] specialIcons;

    public BlockChanceCube() {
        super(Material.field_151578_c);
        this.func_149711_c(0.5f);
        this.func_149663_c("Chance_Cube");
        this.func_149647_a(CCubesCore.modTab);
        this.func_149658_d("chancecubes:chanceCube");
        this.func_149715_a(2.0f);
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileChanceCube();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!world.field_72995_K && player != null && !(player instanceof FakePlayer)) {
            TileChanceCube te = (TileChanceCube)world.func_147438_o(x, y, z);
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b().equals(CCubesItems.silkPendant)) {
                ItemStack stack = new ItemStack(Item.func_150898_a((Block)CCubesBlocks.chanceCube), 1);
                ((ItemChanceCube)stack.func_77973_b()).setChance(stack, te.getChance());
                this.func_149642_a(world, x, y, z, stack);
                world.func_147468_f(x, y, z);
                world.func_147475_p(x, y, z);
                return true;
            }
            if (te != null) {
                world.func_147468_f(x, y, z);
                ChanceCubeRegistry.INSTANCE.triggerRandomReward(world, x, y, z, player, te.getChance());
            }
        }
        return true;
    }

    public int func_149745_a(Random p_149745_1_) {
        return 0;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return !(entity instanceof EntityWither) && super.canEntityDestroy(world, x, y, z, entity);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[6];
        this.icons[0] = register.func_94245_a("chancecubes:chancecube_face_1");
        this.icons[1] = register.func_94245_a("chancecubes:chancecube_face_6");
        this.icons[2] = register.func_94245_a("chancecubes:chancecube_face_2");
        this.icons[3] = register.func_94245_a("chancecubes:chancecube_face_5");
        this.icons[4] = register.func_94245_a("chancecubes:chancecube_face_4");
        this.icons[5] = register.func_94245_a("chancecubes:chancecube_face_3");
        if (CCubesSettings.hasHolidayTexture) {
            this.specialIcons = new IIcon[2];
            String texture = CCubesSettings.holidayTextureName;
            this.specialIcons[0] = register.func_94245_a("chancecubes:" + texture + "Top");
            this.specialIcons[1] = register.func_94245_a("chancecubes:" + texture);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (CCubesSettings.hasHolidayTexture) {
            if (side == 0 || side == 1) {
                return this.specialIcons[0];
            }
            return this.specialIcons[1];
        }
        return this.icons[side];
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (GiantCubeUtil.checkMultiBlockForm(x, y, z, world)) {
            GiantCubeUtil.setupStructure(x, y, z, world);
        }
    }
}

