/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories;

import net.minecraft.util.ResourceLocation;

public enum EInventoryMaterial {
    Stone(27, new String[]{"normalChestFrameStone.png", "doubleChestFrameStone.png", "normalLockerFrameStone.png", "doubleLockerFrameStone.png"}, "cobblestone", 0),
    Iron(54, 255, 255, 255, "ingotIron", 1),
    Gold(81, 230, 180, 40, "ingotGold", 2),
    Diamond(108, 105, 240, 218, "gemDiamond", 3),
    Emerald(108, 77, 192, 97, "gemEmerald", 3),
    Obsidian(108, new String[]{"normalChestFrameObsidian.png", "doubleChestFrameObsidian.png", "normalLockerFrameObsidian.png", "doubleLockerFrameObsidian.png"}, "obsidian", 4),
    Copper(54, 195, 125, 10, "ingotCopper", 1),
    Tin(54, 117, 148, 191, "ingotTin", 1),
    Silver(81, 147, 178, 201, "ingotSilver", 2),
    Bronze(81, 225, 155, 50, "ingotBronze", 2),
    Steel(81, 128, 128, 128, "ingotSteel", 2),
    Platinum(108, 98, 153, 255, "ingotPlatinum", 3),
    Alumite(108, 235, 140, 240, "ingotAlumite", 3),
    Cobalt(135, 65, 65, 255, "ingotCobalt", 4),
    Ardite(135, 255, 88, 0, "ingotArdite", 4),
    Manyullyn(162, 120, 0, 235, "ingotManyullyn", 5);

    int size;
    int rVal;
    int gVal;
    int bVal;
    int tier;
    String mat;
    String[] recipes;
    ResourceLocation[] textures;

    private EInventoryMaterial(int size, int rV, int gV, int bV, String mat, int tier) {
        this.size = size;
        this.rVal = rV;
        this.gVal = gV;
        this.bVal = bV;
        this.tier = tier;
        this.mat = mat;
    }

    private EInventoryMaterial(int size, int rV, int gV, int bV) {
        this.size = size;
        this.rVal = rV;
        this.gVal = gV;
        this.bVal = bV;
        this.tier = 0;
    }

    private EInventoryMaterial(int size, String[] textures, String mat, int tier) {
        this.size = size;
        this.textures = new ResourceLocation[textures.length];
        for (int i = 0; i < textures.length; ++i) {
            this.textures[i] = new ResourceLocation("enhancedinventories", "textures/uvs/" + textures[i]);
        }
        this.mat = mat;
        this.tier = tier;
    }

    private EInventoryMaterial(int size, String[] textures) {
        this.size = size;
        this.textures = new ResourceLocation[textures.length];
        for (int i = 0; i < textures.length; ++i) {
            this.textures[i] = new ResourceLocation("enhancedinventories", "textures/uvs/" + textures[i]);
        }
        this.tier = 0;
    }

    public int getTier() {
        return this.tier;
    }

    public String getMaterial() {
        return this.mat;
    }

    public int size() {
        return this.size;
    }

    public int doubleSize() {
        return this.size * 2;
    }

    public float r() {
        return (float)this.rVal / 255.0f;
    }

    public float g() {
        return (float)this.gVal / 255.0f;
    }

    public float b() {
        return (float)this.bVal / 255.0f;
    }

    public boolean hasTexture() {
        return this.textures != null;
    }

    public ResourceLocation getTexture(int index) {
        return this.textures[index];
    }

    public static void registerRecipes() {
    }
}

