/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories;

import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import yuuto.enhancedinventories.EnhancedInventories;
import yuuto.enhancedinventories.WoodTypes;
import yuuto.enhancedinventories.WoolUpgradeHelper;
import yuuto.enhancedinventories.item.ItemBlockImprovedChest;

public class RecipeImprovedChest
extends ShapedOreRecipe {
    int subType;

    public RecipeImprovedChest(int subType, ItemStack result, Object[] recipe) {
        super(result, recipe);
        this.subType = subType;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (this.subType != 0) {
            return super.func_77569_a(inv, world);
        }
        if (!super.func_77569_a(inv, world)) {
            return false;
        }
        if (this.func_77571_b().func_77960_j() != 0) {
            return true;
        }
        ItemStack wood = null;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                if ((x != 1 || y == 1) && (y != 1 || x == 1)) continue;
                if (wood == null) {
                    wood = inv.func_70463_b(x, y);
                    continue;
                }
                ItemStack stack = inv.func_70463_b(x, y);
                if (wood.func_77973_b() != stack.func_77973_b()) {
                    return false;
                }
                if (wood.func_77960_j() != stack.func_77960_j()) {
                    return false;
                }
                if (wood.func_77942_o() != stack.func_77942_o()) {
                    return false;
                }
                if (!wood.func_77942_o() || ItemStack.func_77989_b((ItemStack)wood, (ItemStack)stack)) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        if (this.subType == 0) {
            return this.getBasicResult(var1);
        }
        if (this.subType == 1) {
            return this.getDyeResult(var1);
        }
        if (this.subType == 2) {
            return this.getAltResult(var1);
        }
        return null;
    }

    public ItemStack getDyeResult(InventoryCrafting var1) {
        ItemStack ret = super.func_77572_b(var1);
        ItemStack dye = null;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            if (var1.func_70301_a(i) == null) continue;
            if (var1.func_70301_a(i).func_77973_b() != Item.func_150898_a((Block)EnhancedInventories.improvedChest)) {
                dye = var1.func_70301_a(i);
                continue;
            }
            if (var1.func_70301_a(i).func_77942_o()) {
                ret.func_77982_d((NBTTagCompound)var1.func_70301_a(i).func_77978_p().func_74737_b());
                continue;
            }
            ret.func_77982_d(this.generateNBT(ret));
        }
        int dyeColor = WoolUpgradeHelper.getDyeId(dye);
        if ((dyeColor = WoolUpgradeHelper.getCollorValue(dyeColor)) < 0) {
            dyeColor = 0;
        }
        if (dyeColor > 15) {
            dyeColor = 15;
        }
        ret.func_77978_p().func_74774_a("wool", (byte)dyeColor);
        return ret;
    }

    public ItemStack getBasicResult(InventoryCrafting var1) {
        ItemStack ret = super.func_77572_b(var1);
        if (ret.func_77960_j() == 0) {
            String wood = WoodTypes.getId(var1.func_70463_b(0, 1));
            int wool = var1.func_70463_b(1, 1).func_77960_j();
            if (wood == null) {
                return null;
            }
            ret.func_77982_d(new NBTTagCompound());
            ret.func_77978_p().func_74778_a("woodType", wood);
            if (ret.func_77973_b() instanceof ItemBlockImprovedChest) {
                ret.func_77978_p().func_74774_a("wool", (byte)wool);
            }
            ret.func_77978_p().func_74757_a("alt", false);
            return ret;
        }
        if (var1.func_70463_b(1, 1).func_77942_o()) {
            ret.func_77982_d((NBTTagCompound)var1.func_70463_b(1, 1).func_77978_p().func_74737_b());
        } else {
            ret.func_77982_d(this.generateNBT(ret));
        }
        return ret;
    }

    public ItemStack getAltResult(InventoryCrafting var1) {
        ItemStack ret = super.func_77572_b(var1);
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            if (var1.func_70301_a(i) == null) continue;
            if (var1.func_70301_a(i).func_77942_o()) {
                ret.func_77982_d((NBTTagCompound)var1.func_70301_a(i).func_77978_p().func_74737_b());
                continue;
            }
            ret.func_77982_d(this.generateNBT(ret));
        }
        ret.func_77978_p().func_74757_a("alt", !ret.func_77978_p().func_74767_n("alt"));
        return ret;
    }

    public NBTTagCompound generateNBT(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("woodType", "wood:minecraft:planks:0");
        if (stack.func_77973_b() instanceof ItemBlockImprovedChest) {
            nbt.func_74774_a("wool", (byte)0);
        }
        nbt.func_74757_a("alt", false);
        return nbt;
    }
}

