/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import yuuto.enhancedinventories.WoodType;
import yuuto.enhancedinventories.compat.modules.BiomesOPlentyModule;
import yuuto.enhancedinventories.compat.modules.BotaniaModule;
import yuuto.enhancedinventories.compat.modules.ChiselModule;
import yuuto.enhancedinventories.compat.modules.ExtraTreesModule;
import yuuto.enhancedinventories.compat.modules.ExtrabiomesModule;
import yuuto.enhancedinventories.compat.modules.ForestryModule;
import yuuto.enhancedinventories.compat.modules.NaturaModule;
import yuuto.enhancedinventories.compat.modules.ThaumcraftModule;
import yuuto.enhancedinventories.compat.modules.VanillaModule;
import yuuto.enhancedinventories.proxy.ConfigHandler;

public final class WoodTypes {
    public static final String DEFAULT_WOOD_ID = "wood:minecraft:planks:0";
    static ArrayList<WoodType> woodTypes = new ArrayList();
    static HashMap<String, WoodType> woodTypeMap = new HashMap();

    public static void init() {
        VanillaModule.init();
        if (ConfigHandler.chisel && Loader.isModLoaded((String)"chisel")) {
            ChiselModule.init();
        }
        if (ConfigHandler.natura && Loader.isModLoaded((String)"Natura")) {
            NaturaModule.init();
        }
        if (ConfigHandler.forestry && Loader.isModLoaded((String)"Forestry")) {
            ForestryModule.init();
            if (ConfigHandler.extraTrees && Loader.isModLoaded((String)"ExtraTrees")) {
                ExtraTreesModule.init();
            }
        }
        if (ConfigHandler.botania && Loader.isModLoaded((String)"Botania")) {
            BotaniaModule.init();
        }
        if (ConfigHandler.thaumcraft && Loader.isModLoaded((String)"Thaumcraft")) {
            ThaumcraftModule.init();
        }
        if (ConfigHandler.biomesOPlenty && Loader.isModLoaded((String)"BiomesOPlenty")) {
            BiomesOPlentyModule.init();
        }
        if (ConfigHandler.extrabiomes && Loader.isModLoaded((String)"ExtrabiomesXL")) {
            ExtrabiomesModule.init();
        }
    }

    public static void addWoodType(WoodType wood) {
        woodTypes.add(wood);
        woodTypeMap.put(wood.id(), wood);
    }

    public static String getId(ItemStack stack) {
        for (WoodType wood : woodTypes) {
            if (!wood.matches(stack)) continue;
            return wood.id();
        }
        return DEFAULT_WOOD_ID;
    }

    public static WoodType getWoodType(String id) {
        if (woodTypeMap.containsKey(id)) {
            return woodTypeMap.get(id);
        }
        return null;
    }

    public static ArrayList<WoodType> getWoodTypes() {
        return woodTypes;
    }
}

