/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.DungeonBase;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.TreasureChestEmpty;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.PotionMixture;
import greymerk.roguelike.treasure.loot.Record;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import greymerk.roguelike.worldgen.BlockFactoryCheckers;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Log;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class DungeonBTeam
extends DungeonBase {
    @Override
    public boolean generate(World world, Random rand, CatacombLevelSettings settings, Cardinal[] entrances, Coord origin) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        MetaBlock oakLog = Log.getLog(Log.OAK);
        MetaBlock stair = new MetaBlock(Blocks.field_150485_bF);
        MetaBlock stonebrick = new MetaBlock(Blocks.field_150417_aV);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y, z - 4, x + 4, y + 4, z + 5, air);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y - 1, z - 4, x + 4, y - 1, z + 5, new MetaBlock(Blocks.field_150347_e));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 3, y - 1, z - 2, x + 3, y - 1, z + 3, new MetaBlock(Blocks.field_150406_ce, 9), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y - 1, z - 1, x + 2, y - 1, z + 2, new MetaBlock((Block)Blocks.field_150334_T, 8), true, true);
        BlockFactoryCheckers panels = new BlockFactoryCheckers(Log.getLog(Log.SPRUCE, Cardinal.UP), Log.getLog(Log.SPRUCE, Cardinal.EAST));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 1, z + 6, x + 4, y + 3, z + 6, panels, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 1, z - 5, x + 4, y + 3, z - 5, panels, true, true);
        MetaBlock spruce = new MetaBlock(Blocks.field_150344_f, 1);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y, z + 6, x + 4, y, z + 6, spruce, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y, z - 5, x + 4, y, z - 5, spruce, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y - 1, z - 4, x - 5, y, z + 5, spruce, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y - 1, z - 4, x + 5, y, z + 5, spruce, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 4, z - 4, x + 4, y + 4, z - 4, new MetaBlock(Blocks.field_150485_bF, WorldGenPrimitive.blockOrientation(Cardinal.SOUTH, true)), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 4, z + 5, x + 4, y + 4, z + 5, new MetaBlock(Blocks.field_150485_bF, WorldGenPrimitive.blockOrientation(Cardinal.NORTH, true)), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y, z - 5, x + 1, y + 2, z - 5, new MetaBlock(Blocks.field_150347_e));
        WorldGenPrimitive.fillRectSolid(world, rand, x, y, z - 5, x, y + 1, z - 5, air);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y, z + 6, x + 1, y + 2, z + 6, new MetaBlock(Blocks.field_150347_e));
        WorldGenPrimitive.fillRectSolid(world, rand, x, y, z + 6, x, y + 1, z + 6, air);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y, z - 5, x - 5, y + 4, z + 6, spruce, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y, z - 1, x - 5, y, z + 2, new MetaBlock(Blocks.field_150323_B));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y + 1, z - 3, x - 5, y + 3, z + 4, new MetaBlock(Blocks.field_150342_X));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y + 1, z - 1, x - 5, y + 3, z + 2, new MetaBlock(Blocks.field_150325_L, 15), true, true);
        MetaBlock cocao = new MetaBlock(Blocks.field_150375_by, 9);
        WorldGenPrimitive.setBlock(world, x - 5, y + 2, z - 2, Log.getLog(Log.JUNGLE, Cardinal.EAST));
        cocao.setBlock(world, new Coord(x - 4, y + 2, z - 2));
        WorldGenPrimitive.setBlock(world, x - 5, y + 2, z + 3, Log.getLog(Log.JUNGLE, Cardinal.EAST));
        cocao.setBlock(world, new Coord(x - 4, y + 2, z + 3));
        DungeonBTeam.lamp(world, x - 2, y, z - 4);
        DungeonBTeam.lamp(world, x + 2, y, z - 4);
        DungeonBTeam.lamp(world, x - 2, y, z + 5);
        DungeonBTeam.lamp(world, x + 2, y, z + 5);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y + 1, z - 4, x + 5, y + 4, z + 5, stonebrick);
        MetaBlock greenBlock = RogueConfig.getBoolean(RogueConfig.PRECIOUSBLOCKS) ? new MetaBlock(Blocks.field_150475_bE) : new MetaBlock(Blocks.field_150325_L, 5);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y, z - 1, x + 5, y + 4, z - 1, greenBlock, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y, z, x + 5, y, z + 1, greenBlock, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y + 1, z, x + 5, y + 1, z + 1, air);
        greenBlock.setBlock(world, new Coord(x + 5, y + 1, z + 2));
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y + 2, z, x + 5, y + 2, z + 1, greenBlock, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y + 3, z, x + 5, y + 3, z + 1, air);
        greenBlock.setBlock(world, new Coord(x + 5, y + 3, z + 2));
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y + 4, z, x + 5, y + 4, z + 1, greenBlock, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 5, z - 5, x + 4, y + 6, z + 6, new MetaBlock(Blocks.field_150348_b));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y + 5, z - 1, x + 2, y + 5, z - 1, WorldGenPrimitive.blockOrientation(stair, Cardinal.SOUTH, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y + 5, z + 2, x + 2, y + 5, z + 2, WorldGenPrimitive.blockOrientation(stair, Cardinal.NORTH, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 3, y + 5, z, x - 3, y + 5, z + 1, WorldGenPrimitive.blockOrientation(stair, Cardinal.EAST, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 3, y + 5, z, x + 3, y + 5, z + 1, WorldGenPrimitive.blockOrientation(stair, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y + 5, z, x + 2, y + 5, z + 1, new MetaBlock(Blocks.field_150379_bu));
        WorldGenPrimitive.setBlock(world, x - 3, y + 5, z - 1, oakLog);
        WorldGenPrimitive.setBlock(world, x + 3, y + 5, z - 1, oakLog);
        WorldGenPrimitive.setBlock(world, x - 3, y + 5, z + 2, oakLog);
        WorldGenPrimitive.setBlock(world, x + 3, y + 5, z + 2, oakLog);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y, z, x - 2, y, z + 1, WorldGenPrimitive.blockOrientation(stair, Cardinal.WEST, true), true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 2, y, z, x + 2, y, z + 1, WorldGenPrimitive.blockOrientation(stair, Cardinal.EAST, true), true, true);
        MetaBlock spruceSlabUpsideDown = new MetaBlock((Block)Blocks.field_150376_bx, 9);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 1, y, z, x + 1, y, z + 1, spruceSlabUpsideDown, true, true);
        MetaBlock chair = new MetaBlock(Blocks.field_150387_bl);
        WorldGenPrimitive.blockOrientation(chair, Cardinal.SOUTH, false);
        chair.setBlock(world, new Coord(x - 1, y, z - 2));
        chair.setBlock(world, new Coord(x + 1, y, z - 2));
        WorldGenPrimitive.blockOrientation(chair, Cardinal.NORTH, false);
        chair.setBlock(world, new Coord(x - 1, y, z + 3));
        chair.setBlock(world, new Coord(x + 1, y, z + 3));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 7, y - 1, z - 4, x - 6, y + 4, z + 4, stonebrick);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 6, y - 1, z - 4, x + 7, y + 4, z + 4, stonebrick);
        ITreasureChest recordChest = new TreasureChestEmpty().generate(world, rand, settings.getLoot(), new Coord(x - 4, y, z - 4), 0, false);
        recordChest.setInventorySlot(Record.getRecord(Record.STAL), recordChest.getInventorySize() / 2);
        WorldGenPrimitive.setBlock(world, x - 3, y, z - 4, Blocks.field_150421_aI);
        ITreasureChest bdubsChest = new TreasureChestEmpty().generate(world, rand, settings.getLoot(), new Coord(x - 3, y, z + 5), 0, false);
        bdubsChest.setInventorySlot(ItemNovelty.getItem(ItemNovelty.BDOUBLEO), bdubsChest.getInventorySize() / 2 - 2);
        ItemStack shirt = new ItemStack((Item)Items.field_151027_R);
        Loot.setItemName(shirt, "Pink Sweater", null);
        Loot.setItemLore(shirt, "\"It's chinese red!\"");
        ItemArmour.dyeArmor(shirt, 250, 96, 128);
        bdubsChest.setInventorySlot(shirt, bdubsChest.getInventorySize() / 2 + 2);
        ITreasureChest gennybChest = new TreasureChestEmpty().generate(world, rand, settings.getLoot(), new Coord(x + 3, y, z + 5), 0, false);
        gennybChest.setInventorySlot(ItemNovelty.getItem(ItemNovelty.GENERIKB), gennybChest.getInventorySize() / 2);
        WorldGenPrimitive.setBlock(world, x + 4, y, z - 4, Blocks.field_150342_X);
        WorldGenPrimitive.setBlock(world, x + 4, y + 1, z - 4, Blocks.field_150382_bo);
        ITreasureChest contraband = new TreasureChestEmpty().generate(world, rand, settings.getLoot(), new Coord(x + 3, y, z - 4), 0, false);
        for (int i = 0; i < 8; ++i) {
            ItemStack booze = PotionMixture.getBooze(rand);
            contraband.setInventorySlot(booze, rand.nextInt(contraband.getInventorySize()));
        }
        return true;
    }

    private static void lamp(World world, int x, int y, int z) {
        MetaBlock spruce = new MetaBlock(Blocks.field_150344_f, 1);
        spruce.setBlock(world, new Coord(x, y + 4, z));
        WorldGenPrimitive.setBlock(world, x, y + 3, z, Blocks.field_150422_aJ);
        WorldGenPrimitive.setBlock(world, x, y + 2, z, Blocks.field_150426_aN);
        MetaBlock fence = new MetaBlock(Blocks.field_150415_aT, 4);
        fence.setBlock(world, new Coord(x, y + 2, z - 1));
        fence.setMeta(5);
        fence.setBlock(world, new Coord(x, y + 2, z + 1));
        fence.setMeta(6);
        fence.setBlock(world, new Coord(x - 1, y + 2, z));
        fence.setMeta(7);
        fence.setBlock(world, new Coord(x + 1, y + 2, z));
        WorldGenPrimitive.setBlock(world, x, y + 1, z, Blocks.field_150422_aJ);
        spruce.setBlock(world, new Coord(x, y, z));
    }

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public boolean validLocation(World world, Cardinal dir, int x, int y, int z) {
        if (dir != Cardinal.NORTH && dir != Cardinal.SOUTH) {
            return false;
        }
        List<Coord> box = WorldGenPrimitive.getRectHollow(x - 7, y - 2, z - 7, x + 7, y + 5, z + 7);
        for (Coord pos : box) {
            Block b = world.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
            if (b.func_149688_o().func_76220_a()) continue;
            return false;
        }
        return true;
    }
}

