/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.DungeonBase;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.TreasureChestEmpty;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import greymerk.roguelike.worldgen.BlockFactoryCheckers;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonEniko
extends DungeonBase {
    @Override
    public boolean generate(World world, Random rand, CatacombLevelSettings settings, Cardinal[] entrances, Coord origin) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        MetaBlock coal = new MetaBlock(Blocks.field_150402_ci);
        MetaBlock netherBrick = new MetaBlock(Blocks.field_150385_bj);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y, z - 5, x + 5, y + 4, z + 5, air);
        DungeonEniko.pillar(world, rand, x - 5, y, z - 5);
        DungeonEniko.pillar(world, rand, x - 5, y, z - 2);
        DungeonEniko.pillar(world, rand, x - 5, y, z + 2);
        DungeonEniko.pillar(world, rand, x - 5, y, z + 5);
        DungeonEniko.pillar(world, rand, x - 2, y, z - 5);
        DungeonEniko.pillar(world, rand, x - 2, y, z + 5);
        DungeonEniko.pillar(world, rand, x + 2, y, z - 5);
        DungeonEniko.pillar(world, rand, x + 2, y, z + 5);
        DungeonEniko.pillar(world, rand, x + 5, y, z - 5);
        DungeonEniko.pillar(world, rand, x + 5, y, z - 2);
        DungeonEniko.pillar(world, rand, x + 5, y, z + 2);
        DungeonEniko.pillar(world, rand, x + 5, y, z + 5);
        MetaBlock shelf = new MetaBlock(Blocks.field_150390_bg, WorldGenPrimitive.blockOrientation(Cardinal.EAST, true));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 6, y + 1, z - 4, x - 6, y + 3, z - 3, coal);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y, z - 4, x - 5, y, z - 3, shelf, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 6, y + 1, z + 3, x - 6, y + 3, z + 4, coal);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y, z + 3, x - 5, y, z + 4, shelf, true, true);
        shelf.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.WEST, true));
        WorldGenPrimitive.fillRectSolid(world, rand, x + 6, y + 1, z - 4, x + 6, y + 3, z - 3, coal);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y, z - 4, x + 5, y, z - 3, shelf, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 6, y + 1, z + 3, x + 6, y + 3, z + 4, coal);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 5, y, z + 3, x + 5, y, z + 4, shelf, true, true);
        shelf.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.SOUTH, true));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 1, z - 6, x - 3, y + 3, z - 6, coal);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y, z - 5, x - 3, y, z - 5, shelf, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 3, y + 1, z - 6, x + 4, y + 3, z - 6, coal);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 3, y, z - 5, x + 4, y, z - 5, shelf, true, true);
        shelf.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.NORTH, true));
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 1, z + 6, x - 3, y + 3, z + 6, coal);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y, z + 5, x - 3, y, z + 5, shelf, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 3, y + 1, z + 6, x + 4, y + 3, z + 6, coal);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 3, y, z + 5, x + 4, y, z + 5, shelf, true, true);
        ITreasureChest eniChest = new TreasureChestEmpty().generate(world, rand, settings.getLoot(), new Coord(x + 3, y + 1, z + 5), 0, false);
        if (rand.nextBoolean()) {
            eniChest.setInventorySlot(ItemNovelty.getItem(ItemNovelty.ENIKOBOW), eniChest.getInventorySize() / 2);
        } else {
            eniChest.setInventorySlot(ItemNovelty.getItem(ItemNovelty.ENIKOSWORD), eniChest.getInventorySize() / 2);
        }
        WorldGenPrimitive.fillRectSolid(world, rand, x - 5, y - 1, z - 5, x + 5, y - 1, z + 5, new MetaBlock(Blocks.field_150417_aV));
        MetaBlock blockOne = RogueConfig.getBoolean(RogueConfig.PRECIOUSBLOCKS) ? new MetaBlock(Blocks.field_150368_y) : new MetaBlock(Blocks.field_150406_ce, 11);
        MetaBlock blockTwo = new MetaBlock(Blocks.field_150371_ca);
        BlockFactoryCheckers checkers = new BlockFactoryCheckers(blockOne, blockTwo);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 3, y - 1, z - 3, x + 3, y - 1, z + 3, checkers);
        MetaBlock lamp = new MetaBlock(Blocks.field_150374_bv);
        WorldGenPrimitive.setBlock(world, x - 2, y - 1, z - 2, lamp);
        WorldGenPrimitive.setBlock(world, x - 2, y - 2, z - 2, Blocks.field_150451_bX);
        WorldGenPrimitive.setBlock(world, x - 2, y - 1, z + 2, lamp);
        WorldGenPrimitive.setBlock(world, x - 2, y - 2, z + 2, Blocks.field_150451_bX);
        WorldGenPrimitive.setBlock(world, x + 2, y - 1, z - 2, lamp);
        WorldGenPrimitive.setBlock(world, x + 2, y - 2, z - 2, Blocks.field_150451_bX);
        WorldGenPrimitive.setBlock(world, x + 2, y - 1, z + 2, lamp);
        WorldGenPrimitive.setBlock(world, x + 2, y - 2, z + 2, Blocks.field_150451_bX);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 6, y + 4, z - 6, x - 4, y + 4, z + 6, netherBrick);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 3, y + 4, z - 6, x + 4, y + 4, z - 4, netherBrick);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 3, y + 4, z + 4, x + 4, y + 4, z + 6, netherBrick);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 4, y + 4, z - 6, x + 6, y + 4, z + 6, netherBrick);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 4, y + 5, z - 4, x + 4, y + 5, z + 4, netherBrick);
        MetaBlock upsideDownNetherSlab = new MetaBlock((Block)Blocks.field_150333_U, 14);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 3, y + 4, z - 3, x - 3, y + 4, z + 3, upsideDownNetherSlab, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x + 3, y + 4, z - 3, x + 3, y + 4, z + 3, upsideDownNetherSlab, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y + 4, z - 3, x + 2, y + 4, z - 3, upsideDownNetherSlab, true, true);
        WorldGenPrimitive.fillRectSolid(world, rand, x - 2, y + 4, z + 3, x + 2, y + 4, z + 3, upsideDownNetherSlab, true, true);
        return true;
    }

    private static void pillar(World world, Random rand, int x, int y, int z) {
        WorldGenPrimitive.fillRectSolid(world, rand, x, y, z, x, y + 3, z, new MetaBlock(Blocks.field_150417_aV));
        WorldGenPrimitive.setBlock(world, x + 1, y + 3, z, Blocks.field_150390_bg, WorldGenPrimitive.blockOrientation(Cardinal.EAST, true), 2, true, false);
        WorldGenPrimitive.setBlock(world, x - 1, y + 3, z, Blocks.field_150390_bg, WorldGenPrimitive.blockOrientation(Cardinal.WEST, true), 2, true, false);
        WorldGenPrimitive.setBlock(world, x, y + 3, z + 1, Blocks.field_150390_bg, WorldGenPrimitive.blockOrientation(Cardinal.SOUTH, true), 2, true, false);
        WorldGenPrimitive.setBlock(world, x, y + 3, z - 1, Blocks.field_150390_bg, WorldGenPrimitive.blockOrientation(Cardinal.NORTH, true), 2, true, false);
    }

    @Override
    public int getSize() {
        return 7;
    }

    @Override
    public boolean validLocation(World world, Cardinal dir, int x, int y, int z) {
        int size = this.getSize();
        List<Coord> box = WorldGenPrimitive.getRectHollow(x - size, y - 2, z - size, x + size, y + 5, z + size);
        for (Coord pos : box) {
            Block b = world.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
            if (b.func_149688_o().func_76220_a()) continue;
            return false;
        }
        return true;
    }
}

