/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.DungeonBase;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsCreeperDen
extends DungeonBase {
    @Override
    public boolean generate(World world, Random rand, CatacombLevelSettings settings, Cardinal[] entrances, Coord origin) {
        ITheme theme = settings.getTheme();
        MetaBlock tnt = new MetaBlock(Blocks.field_150335_W);
        BlockWeightedRandom mossy = new BlockWeightedRandom();
        mossy.addBlock(theme.getPrimaryWall(), 3);
        mossy.addBlock(new MetaBlock(Blocks.field_150341_Y), 1);
        BlockWeightedRandom floor = new BlockWeightedRandom();
        floor.addBlock(theme.getPrimaryFloor(), 1);
        mossy.addBlock(new MetaBlock(Blocks.field_150341_Y), 1);
        floor.addBlock(new MetaBlock(Blocks.field_150351_n), 3);
        BlockWeightedRandom subfloor = new BlockWeightedRandom();
        subfloor.addBlock(floor, 3);
        subfloor.addBlock(tnt, 1);
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        start.add(new Coord(-4, -4, -4));
        end.add(new Coord(4, 5, 4));
        mossy.fillRectHollow(world, rand, start, end, false, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(new Coord(-3, -1, -3));
        end.add(new Coord(3, -1, 3));
        floor.fillRectSolid(world, rand, start, end, true, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(new Coord(-3, -3, -3));
        end.add(new Coord(3, -2, 3));
        subfloor.fillRectSolid(world, rand, start, end, true, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(new Coord(-3, 0, -3));
        end.add(new Coord(3, 0, 3));
        List<Coord> chestSpaces = WorldGenPrimitive.getRectSolid(start, end);
        Collections.shuffle(chestSpaces);
        int counter = 0;
        for (Coord spot : chestSpaces) {
            if (TreasureChest.isValidChestSpace(world, spot)) {
                TreasureChest.generate(world, rand, settings, spot, TreasureChest.ORE, true);
                Coord cursor = new Coord(spot);
                cursor.add(Cardinal.DOWN, 2);
                tnt.setBlock(world, cursor);
                ++counter;
            }
            if (counter < 2) continue;
            break;
        }
        Spawner.generate(world, rand, settings, new Coord(origin), Spawner.CREEPER);
        return true;
    }

    @Override
    public int getSize() {
        return 7;
    }
}

