/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.DungeonBase;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsSpiderNest
extends DungeonBase {
    World world;
    Random rand;
    int originX;
    int originY;
    int originZ;
    byte dungeonHeight = (byte)2;
    int dungeonLength = 3;
    int dungeonWidth = 3;

    @Override
    public boolean generate(World inWorld, Random inRandom, CatacombLevelSettings settings, Cardinal[] entrances, Coord origin) {
        this.world = inWorld;
        this.rand = inRandom;
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        BlockWeightedRandom webs = new BlockWeightedRandom();
        webs.addBlock(new MetaBlock(Blocks.field_150321_G), 3);
        webs.addBlock(new MetaBlock(Blocks.field_150350_a), 1);
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                for (int blockY = this.originY + this.dungeonHeight; blockY >= this.originY - this.dungeonHeight; --blockY) {
                    int z;
                    int clearHeight;
                    int x = Math.abs(blockX - this.originX);
                    int n = clearHeight = x > (z = Math.abs(blockZ - this.originZ)) ? x : z;
                    if (blockY == this.originY) {
                        webs.setBlock(inWorld, inRandom, new Coord(blockX, blockY, blockZ));
                    }
                    if (clearHeight < 1) {
                        clearHeight = 1;
                    }
                    if (Math.abs(blockY - this.originY) > clearHeight) continue;
                    if (this.rand.nextInt(clearHeight) == 0) {
                        webs.setBlock(inWorld, inRandom, new Coord(blockX, blockY, blockZ));
                        continue;
                    }
                    if (this.rand.nextInt(5) != 0) continue;
                    WorldGenPrimitive.setBlock(this.world, blockX, blockY, blockZ, Blocks.field_150351_n);
                }
            }
        }
        Spawner.generate(this.world, this.rand, settings, new Coord(this.originX, this.originY, this.originZ), Spawner.CAVESPIDER);
        TreasureChest.createChests(this.world, this.rand, settings, 1 + this.rand.nextInt(3), WorldGenPrimitive.getRectSolid(this.originX - this.dungeonLength, this.originY - 1, this.originZ - this.dungeonWidth, this.originX + this.dungeonLength, this.originY + 1, this.originZ + this.dungeonWidth));
        return true;
    }

    @Override
    public int getSize() {
        return 4;
    }
}

