/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.segment.part.SegmentBase;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SegmentFireArch
extends SegmentBase {
    @Override
    protected void genWall(World world, Random rand, CatacombLevel level, Cardinal dir, ITheme theme, int x, int y, int z) {
        MetaBlock stair = theme.getPrimaryStair();
        IBlockFactory walls = theme.getPrimaryWall();
        Cardinal[] orths = Cardinal.getOrthogonal(dir);
        Coord start = new Coord(x, y, z);
        start.add(dir, 3);
        Coord end = new Coord(start);
        start.add(orths[0]);
        end.add(orths[0]);
        end.add(Cardinal.UP, 2);
        end.add(dir);
        WorldGenPrimitive.fillRectSolid(world, rand, start, end, walls, true, true);
        Coord cursor = new Coord(x, y, z);
        cursor.add(dir, 2);
        WorldGenPrimitive.blockOrientation(stair, Cardinal.reverse(dir), false).setBlock(world, cursor);
        cursor.add(Cardinal.UP, 2);
        WorldGenPrimitive.blockOrientation(stair, Cardinal.reverse(dir), true).setBlock(world, cursor);
        cursor.add(Cardinal.DOWN, 2);
        cursor.add(dir);
        WorldGenPrimitive.setBlock(world, cursor, Blocks.field_150424_aL);
        cursor.add(Cardinal.UP);
        WorldGenPrimitive.setBlock(world, cursor, (Block)Blocks.field_150480_ab);
        cursor.add(Cardinal.reverse(dir));
        WorldGenPrimitive.setBlock(world, cursor, Blocks.field_150411_aY);
        for (Cardinal orth : orths) {
            cursor = new Coord(x, y, z);
            cursor.add(dir);
            cursor.add(orth);
            cursor.add(Cardinal.UP, 2);
            WorldGenPrimitive.blockOrientation(stair, Cardinal.reverse(dir), true).setBlock(world, cursor);
        }
    }
}

