/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.BlockFactory;
import greymerk.roguelike.worldgen.BlockFactoryBase;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;

public class BlockFactoryCheckers
extends BlockFactoryBase {
    private IBlockFactory fillOne;
    private IBlockFactory fillTwo;

    public BlockFactoryCheckers(IBlockFactory fillOne, IBlockFactory fillTwo) {
        this.fillOne = fillOne;
        this.fillTwo = fillTwo;
    }

    public BlockFactoryCheckers(JsonElement json) {
        JsonArray arr = (JsonArray)json;
        ArrayList<IBlockFactory> blocks = new ArrayList<IBlockFactory>();
        for (JsonElement entry : arr) {
            JsonObject d = entry.getAsJsonObject();
            String type = d.get("type").getAsString();
            JsonElement blockJson = d.get("data");
            blocks.add(BlockFactory.create(type, blockJson));
        }
        this.fillOne = (IBlockFactory)blocks.get(0);
        this.fillTwo = (IBlockFactory)blocks.get(1);
    }

    @Override
    public boolean setBlock(World world, Random rand, Coord origin, boolean fillAir, boolean replaceSolid) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        if (x % 2 == 0) {
            if (z % 2 == 0) {
                if (y % 2 == 0) {
                    return WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillOne, fillAir, replaceSolid);
                }
                return WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillTwo, fillAir, replaceSolid);
            }
            if (y % 2 == 0) {
                return WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillTwo, fillAir, replaceSolid);
            }
            return WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillOne, fillAir, replaceSolid);
        }
        if (z % 2 == 0) {
            if (y % 2 == 0) {
                return WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillTwo, fillAir, replaceSolid);
            }
            return WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillOne, fillAir, replaceSolid);
        }
        if (y % 2 == 0) {
            return WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillOne, fillAir, replaceSolid);
        }
        return WorldGenPrimitive.setBlock(world, rand, x, y, z, this.fillTwo, fillAir, replaceSolid);
    }
}

