/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonObject;
import greymerk.roguelike.util.JsonNBT;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;

public class Spawnable {
    private boolean equip;
    private String name;
    private NBTTagCompound meta;

    public Spawnable(JsonObject data) {
        this.name = data.get("name").getAsString();
        boolean bl = this.equip = data.has("equip") ? data.get("equip").getAsBoolean() : true;
        if (data.has("meta")) {
            JsonObject metadata = data.get("meta").getAsJsonObject();
            this.meta = JsonNBT.jsonToCompound(metadata);
        }
    }

    public void generate(World world, Random rand, Coord cursor, int level) {
        if (!WorldGenPrimitive.setBlock(world, cursor.getX(), cursor.getY(), cursor.getZ(), Blocks.field_150474_ac)) {
            return;
        }
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_147438_o(cursor.getX(), cursor.getY(), cursor.getZ());
        if (spawner == null) {
            return;
        }
        MobSpawnerBaseLogic logic = spawner.func_145881_a();
        logic.func_98272_a(this.name);
        if (this.meta == null) {
            if (this.equip) {
                Spawner.setRoguelike(logic, level);
            }
            return;
        }
        Spawner.setMeta(logic, this.meta);
    }
}

