/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry.trees;

import codechicken.nei.api.API;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.config.Option;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticItemFilter;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.forestry.MutationDumper;
import net.bdew.neiaddons.forestry.trees.TreeBreedingHandler;
import net.bdew.neiaddons.forestry.trees.TreeProduceHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TreeHelper {
    public static Collection<IAlleleTreeSpecies> allSpecies;
    public static Map<Item, Collection<IAlleleSpecies>> productsCache;
    public static ITreeRoot root;

    private static void addProductToCache(Item item, IAlleleTreeSpecies species) {
        if (!productsCache.containsKey(item)) {
            productsCache.put(item, new ArrayList());
        }
        productsCache.get(item).add((IAlleleSpecies)species);
    }

    public static void setup() {
        root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
        if (root == null) {
            AddonForestry.instance.logWarning("Tree Species Root not found, some functionality will be unavailable", new Object[0]);
            return;
        }
        allSpecies = GeneticsUtils.getAllTreeSpecies(AddonForestry.loadBlacklisted);
        if (AddonForestry.showTreeMutations) {
            TreeBreedingHandler breedingRecipeHandler = new TreeBreedingHandler();
            API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
            API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        }
        if (AddonForestry.showTreeProducts) {
            TreeProduceHandler produceRecipeHandler = new TreeProduceHandler();
            API.registerRecipeHandler((ICraftingHandler)produceRecipeHandler);
            API.registerUsageHandler((IUsageHandler)produceRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(produceRecipeHandler.getRecipeName(), produceRecipeHandler.getRecipeIdent());
        }
        for (IAlleleTreeSpecies species : allSpecies) {
            if (AddonForestry.addSaplings) {
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumGermlingType.SAPLING.ordinal()));
            }
            if (AddonForestry.addPollen) {
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumGermlingType.POLLEN.ordinal()));
            }
            for (ItemStack prod : GeneticsUtils.getProduceFromSpecies((IAlleleSpecies)species).keySet()) {
                TreeHelper.addProductToCache(prod.func_77973_b(), species);
            }
            for (ItemStack prod : GeneticsUtils.getSpecialtyFromSpecies((IAlleleSpecies)species).keySet()) {
                TreeHelper.addProductToCache(prod.func_77973_b(), species);
            }
        }
        API.addSubset((String)"Forestry.Trees.Pollen", (ItemFilter)new GeneticItemFilter((ISpeciesRoot)root, EnumGermlingType.POLLEN.ordinal(), true));
        API.addSubset((String)"Forestry.Trees.Saplings", (ItemFilter)new GeneticItemFilter((ISpeciesRoot)root, EnumGermlingType.SAPLING.ordinal(), true));
        API.addOption((Option)new MutationDumper((ISpeciesRoot)root, "tree_mutation"));
    }

    static {
        productsCache = new HashMap<Item, Collection<IAlleleSpecies>>();
    }
}

