/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.componentAI;

import CoroUtil.OldUtil;
import CoroUtil.componentAI.jobSystem.JobBase;
import CoroUtil.diplomacy.DiplomacyHelper;
import CoroUtil.util.CoroUtilEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;

public class AITamable {
    public JobBase job;
    public String owner = "";
    public int ownerEntityID = -1;
    public EntityLivingBase ownerCachedInstance = null;
    public ChunkCoordinates occupyCoord;
    public double followDistMin = 2.0;
    public double followDistMax = 8.0;
    public double strayDistMax = 32.0;
    public double teleportFromFarDist = 48.0;

    public AITamable(JobBase parJob) {
        this.job = parJob;
    }

    public boolean isTame() {
        return !this.owner.equals("");
    }

    public void tameBy(String user) {
        this.owner = user;
        this.updateCache();
    }

    public void tameClear() {
        this.owner = "";
        this.ownerCachedInstance = null;
    }

    public void updateCache() {
        this.ownerCachedInstance = this.job.ent.field_70170_p.func_72924_a(this.owner);
    }

    public EntityLivingBase getPlayerCached() {
        return this.ownerCachedInstance;
    }

    public boolean isEnemy(Entity ent) {
        if (ent instanceof EntityPlayer && CoroUtilEntity.getName(ent).equals(this.owner)) {
            return false;
        }
        return DiplomacyHelper.shouldTameTargetEnt((EntityLivingBase)this.job.ent, ent, this);
    }

    public void tick() {
        if (this.isTame()) {
            this.updateCache();
            EntityLivingBase ent = this.getPlayerCached();
            if (ent != null) {
                this.occupyCoord = OldUtil.entToCoord((Entity)ent);
                if ((ent.field_70122_E || ent.func_70090_H()) && this.teleportFromFarDist != -1.0 && (double)this.job.ai.ent.func_70032_d((Entity)ent) > this.teleportFromFarDist) {
                    double range = 2.0;
                    Random rand = new Random();
                    this.job.ai.ent.func_70107_b(ent.field_70165_t + rand.nextDouble() * range - rand.nextDouble() * range, ent.field_70163_u, ent.field_70161_v + rand.nextDouble() * range - rand.nextDouble() * range);
                    this.job.ai.ent.func_70661_as().func_75499_g();
                }
                if (!(this.job.ai.entityToAttack == null || this.job.ai.entityToAttack.func_145782_y() != ent.func_145782_y() && DiplomacyHelper.shouldTameTargetEnt((EntityLivingBase)this.job.ent, this.job.ai.entityToAttack, this))) {
                    this.job.ai.entityToAttack = null;
                }
                if (!this.job.ai.ent.func_82165_m(Potion.field_76431_k.field_76415_H)) {
                    this.job.ai.ent.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 5, 0));
                }
            }
        }
    }

    public void onIdleTick() {
        Random rand = new Random();
        if (this.job.ent.func_70661_as().func_75500_f() && rand.nextInt(40) == 0) {
            if (this.occupyCoord == null || OldUtil.getDistanceXZ((Entity)this.job.ent, this.occupyCoord) < this.followDistMax) {
                this.job.ai.updateWanderPath();
            } else {
                this.job.ai.walkTo((Entity)this.job.ent, this.occupyCoord, this.job.ai.maxPFRange, 600);
            }
        } else if (this.job.ent.func_70661_as().func_75500_f()) {
            // empty if block
        }
    }

    public void cleanup() {
        this.job = null;
        this.ownerCachedInstance = null;
    }
}

