/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CoroUtilFile {
    public static String lastWorldFolder = "";

    public static NBTTagCompound getExtraWorldNBT(String fileName) {
        NBTTagCompound data = new NBTTagCompound();
        String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName();
        if (new File(saveFolder + fileName).exists()) {
            try {
                data = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + fileName));
            }
            catch (Exception ex) {
                System.out.println("CoroUtilFile: getExtraWorldNBT: Error loading " + saveFolder + fileName);
            }
        }
        return data;
    }

    public static void setExtraWorldNBT(String fileName, NBTTagCompound data) {
        try {
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName();
            FileOutputStream fos = new FileOutputStream(saveFolder + fileName);
            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getWorldFolderName() {
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world != null) {
            lastWorldFolder = world.getChunkSaveLocation().getName();
            return lastWorldFolder + File.separator;
        }
        return lastWorldFolder + File.separator;
    }

    public static String getSaveFolderPath() {
        if (MinecraftServer.func_71276_C() == null || MinecraftServer.func_71276_C().func_71264_H()) {
            return CoroUtilFile.getClientSidePath() + File.separator;
        }
        return new File(".").getAbsolutePath() + File.separator;
    }

    public static String getMinecraftSaveFolderPath() {
        if (MinecraftServer.func_71276_C() == null || MinecraftServer.func_71276_C().func_71264_H()) {
            return CoroUtilFile.getClientSidePath() + File.separator + "config" + File.separator;
        }
        return new File(".").getAbsolutePath() + File.separator + "config" + File.separator;
    }

    public static String getWorldSaveFolderPath() {
        if (MinecraftServer.func_71276_C() == null || MinecraftServer.func_71276_C().func_71264_H()) {
            return CoroUtilFile.getClientSidePath() + File.separator + "saves" + File.separator;
        }
        return new File(".").getAbsolutePath() + File.separator;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getClientSidePath() {
        return FMLClientHandler.instance().getClient().field_71412_D.getPath();
    }

    public static void writeCoords(String name, ChunkCoordinates coords, NBTTagCompound nbt) {
        nbt.func_74768_a(name + "X", coords.field_71574_a);
        nbt.func_74768_a(name + "Y", coords.field_71572_b);
        nbt.func_74768_a(name + "Z", coords.field_71573_c);
    }

    public static ChunkCoordinates readCoords(String name, NBTTagCompound nbt) {
        if (nbt.func_74764_b(name + "X")) {
            return new ChunkCoordinates(nbt.func_74762_e(name + "X"), nbt.func_74762_e(name + "Y"), nbt.func_74762_e(name + "Z"));
        }
        return null;
    }
}

