/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.tweak.enchantment;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.event.AnvilUpdateEvent;
import pl.asie.lib.AsieLibMod;
import pl.asie.lib.tweak.enchantment.EnchantmentBetterBane;
import pl.asie.lib.util.RayTracer;

public class EnchantmentTweak {
    public static EnchantmentBetterBane bane;

    public static void registerBaneEnchantment(int enchID) {
        if (enchID >= 0 && enchID < 256) {
            if (Enchantment.field_77331_b[enchID] == null) {
                bane = new EnchantmentBetterBane(244);
                return;
            }
            for (int i = enchID; i < 256; ++i) {
                if (Enchantment.field_77331_b[i] != null) continue;
                AsieLibMod.log.info("Enchantment ID " + enchID + " already occupied, using " + i + " instead");
                bane = new EnchantmentBetterBane(i);
                return;
            }
        }
        throw new IllegalArgumentException("No valid enchantment id! " + EnchantmentBetterBane.class + " Enchantment ID:" + enchID);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void anvilEvent(AnvilUpdateEvent e) {
        if (e.left == null || e.right == null || e.left.func_77973_b() == null || e.right.func_77973_b() == null || e.isCanceled()) {
            return;
        }
        if (e.left.func_77984_f() && e.left.func_77948_v() && e.right.func_77973_b() == Items.field_151071_bq && !EnchantmentTweak.hasBaneEnchantment(e.left)) {
            if (e.right.field_77994_a == 64) {
                e.output = e.left.func_77946_l();
                e.cost = 37;
                if (!EnchantmentTweak.addBaneEnchantment(e.output, 9)) {
                    e.output = null;
                    if (e.isCancelable()) {
                        e.setCanceled(true);
                    }
                }
            } else {
                e.output = null;
                if (e.isCancelable()) {
                    e.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void enchEvent(TickEvent.PlayerTickEvent e) {
        EntityPlayer player = e.player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.func_71045_bC() != null && EnchantmentTweak.hasBaneEnchantment(player.func_71045_bC()) && player.func_71045_bC().func_77984_f()) {
            Entity entity;
            RayTracer.instance().fire((EntityLivingBase)player, 10.0);
            MovingObjectPosition target = RayTracer.instance().getTarget();
            if (target != null && target.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && (entity = target.field_72308_g) != null && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.ARTHROPOD && entity.field_70172_ad <= 10 && !player.func_70632_aY()) {
                player.func_71059_n(entity);
                if (player.func_71045_bC().func_77984_f()) {
                    float distance = player.func_70032_d(entity);
                    int damage = Math.max(Math.min((int)distance + 1, 10), 1);
                    player.func_71045_bC().func_77972_a(damage, (EntityLivingBase)player);
                }
            }
        }
    }

    private static boolean hasBaneEnchantment(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            return false;
        }
        if (!stack.func_77978_p().func_150297_b("ench", 9)) {
            return false;
        }
        NBTTagList list = stack.func_77978_p().func_150295_c("ench", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag == null || tag.func_74765_d("id") != EnchantmentTweak.bane.field_77352_x) continue;
            return true;
        }
        return false;
    }

    private static boolean addBaneEnchantment(ItemStack stack, int level) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_150297_b("ench", 9)) {
            stack.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList list = stack.func_77978_p().func_150295_c("ench", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag == null || tag.func_74765_d("id") != Enchantment.field_77336_l.field_77352_x || tag.func_74765_d("lvl") != 5) continue;
            list.func_74744_a(i);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("id", (short)EnchantmentTweak.bane.field_77352_x);
            data.func_74777_a("lvl", (short)((byte)level));
            list.func_74742_a((NBTBase)data);
            return true;
        }
        return false;
    }
}

