/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import magicbees.bees.BeeClassification;
import magicbees.bees.BeeGenomeManager;
import magicbees.bees.BeeManager;
import magicbees.bees.BeeProductHelper;
import magicbees.main.Config;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.compat.AppliedEnergisticsHelper;
import magicbees.main.utils.compat.ArsMagicaHelper;
import magicbees.main.utils.compat.BloodMagicHelper;
import magicbees.main.utils.compat.BotaniaHelper;
import magicbees.main.utils.compat.EquivalentExchangeHelper;
import magicbees.main.utils.compat.ForestryHelper;
import magicbees.main.utils.compat.RedstoneArsenalHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import magicbees.main.utils.compat.ThermalExpansionHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public enum BeeSpecies implements IAlleleBeeSpecies,
IIconProvider
{
    MYSTICAL("Mystical", "mysticum", (IClassification)BeeClassification.VEILED, 11534263, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false, true),
    SORCEROUS("Sorcerous", "fascinatio", (IClassification)BeeClassification.VEILED, 0xEA9A9A, EnumTemperature.HOT, EnumHumidity.ARID, false, false, true),
    UNUSUAL("Unusual", "inusitatus", (IClassification)BeeClassification.VEILED, 7525217, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false, true),
    ATTUNED("Attuned", "similis", (IClassification)BeeClassification.VEILED, 34472, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false, true),
    ELDRITCH("Eldritch", "prodigiosus", BeeClassification.VEILED, 9270688, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ESOTERIC("Esoteric", "secretiore", (IClassification)BeeClassification.ARCANE, 4249, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    MYSTERIOUS("Mysterious", "mysticus", (IClassification)BeeClassification.ARCANE, 7744450, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ARCANE("Arcane", "arcanus", (IClassification)BeeClassification.ARCANE, 13779679, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    CHARMED("Charmed", "larvatus", (IClassification)BeeClassification.SUPERNATURAL, 4779756, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ENCHANTED("Enchanted", "cantatus", (IClassification)BeeClassification.SUPERNATURAL, 1632038, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    SUPERNATURAL("Supernatural", "coeleste", (IClassification)BeeClassification.SUPERNATURAL, 22036, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    ETHEREAL("Ethereal", "diaphanum", (IClassification)BeeClassification.MAGICAL, 0xBA3B3B, 0xEFF8FF, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    WATERY("Watery", "aquatilis", BeeClassification.MAGICAL, 3226718, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    EARTHY("Earthen", "fictili", BeeClassification.MAGICAL, 7897645, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    FIREY("Firey", "ardens", BeeClassification.MAGICAL, 13848857, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    WINDY("Windy", "ventosum", BeeClassification.MAGICAL, 16776634, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    PUPIL("Pupil", "disciplina", BeeClassification.SCHOLARLY, 0xFFFF00, EnumTemperature.NORMAL, EnumHumidity.ARID, false, true),
    SCHOLARLY("Scholarly", "studiosis", BeeClassification.SCHOLARLY, 0x6E0000, EnumTemperature.NORMAL, EnumHumidity.ARID, false, false),
    SAVANT("Savant", "philologus", BeeClassification.SCHOLARLY, 16752706, EnumTemperature.NORMAL, EnumHumidity.ARID, true, false),
    AWARE("Aware", "sensibilis", BeeClassification.MAGICAL, 6198709, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    SPIRIT("Spirit", "larva", BeeClassification.SOUL, 11703883, EnumTemperature.WARM, EnumHumidity.NORMAL, false, true),
    SOUL("Soul", "anima", BeeClassification.SOUL, 8214811, EnumTemperature.HELLISH, EnumHumidity.NORMAL, true, false),
    SKULKING("Skulking", "malevolens", (IClassification)BeeClassification.SKULKING, 5392423, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    GHASTLY("Ghastly", "pallens", (IClassification)BeeClassification.SKULKING, 0xCCCCEE, 12552060, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    SPIDERY("Spidery", "araneolus", (IClassification)BeeClassification.SKULKING, 0x888888, 0x222222, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    SMOULDERING("Smouldering", "flagrantia", (IClassification)BeeClassification.SKULKING, 16762695, 15369028, EnumTemperature.HELLISH, EnumHumidity.NORMAL, false, false),
    BIGBAD("BigBad", "magnumalum", BeeClassification.SKULKING, 11088971, 4535606, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false, true, true, true),
    TIMELY("Timely", "gallifreis", BeeClassification.TIME, 13021062, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    LORDLY("Lordly", "rassilonis", (IClassification)BeeClassification.TIME, 13021062, 9306643, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    DOCTORAL("Doctoral", "medicus qui", (IClassification)BeeClassification.TIME, 14542332, 4943500, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    INFERNAL("Infernal", "infernales", (IClassification)BeeClassification.ABOMINABLE, 0xFF1C1C, 9834240, EnumTemperature.HELLISH, EnumHumidity.ARID, false, true),
    HATEFUL("Hateful", "odibilis", (IClassification)BeeClassification.ABOMINABLE, 0xDB00DB, 9834240, EnumTemperature.HELLISH, EnumHumidity.ARID, false, false),
    SPITEFUL("Spiteful", "maligna", (IClassification)BeeClassification.ABOMINABLE, 6278144, 9834240, EnumTemperature.HELLISH, EnumHumidity.ARID, true, false),
    WITHERING("Withering", "vietus", (IClassification)BeeClassification.ABOMINABLE, 0x5B5B5B, 9834240, EnumTemperature.HELLISH, EnumHumidity.ARID, true, false),
    OBLIVION("Oblivion", "oblivioni", (IClassification)BeeClassification.EXTRINSIC, 14009317, 0xF696FF, EnumTemperature.COLD, EnumHumidity.NORMAL, false, false),
    NAMELESS("Nameless", "sine nomine", (IClassification)BeeClassification.EXTRINSIC, 9217995, 0xF696FF, EnumTemperature.COLD, EnumHumidity.NORMAL, false, true),
    ABANDONED("Abandoned", "reliquit", (IClassification)BeeClassification.EXTRINSIC, 12962700, 0xF696FF, EnumTemperature.COLD, EnumHumidity.NORMAL, false, true),
    FORLORN("Forlorn", "perditus", (IClassification)BeeClassification.EXTRINSIC, 13346956, 0xF696FF, EnumTemperature.COLD, EnumHumidity.NORMAL, true, false),
    DRACONIC("Draconic", "draconic", (IClassification)BeeClassification.EXTRINSIC, 10442413, 5913442, EnumTemperature.COLD, EnumHumidity.NORMAL, true, false),
    IRON("Iron", "ferrus", (IClassification)BeeClassification.METALLIC, 0x686868, 0xE9E9E9, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    GOLD("Gold", "aurum", (IClassification)BeeClassification.METALLIC, 6834945, 0xFFFF0B, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    COPPER("Copper", "aercus", (IClassification)BeeClassification.METALLIC, 6834945, 16762906, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TIN("Tin", "stannum", (IClassification)BeeClassification.METALLIC, 4086125, 10926795, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    SILVER("Silver", "argenteus", (IClassification)BeeClassification.METALLIC, 7634049, 9879492, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    LEAD("Lead", "plumbeus", (IClassification)BeeClassification.METALLIC, 9879492, 9546227, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ALUMINUM("Aluminum", "aluminium", (IClassification)BeeClassification.METALLIC, 0xEDEDED, 0x767676, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ARDITE("Ardite", "aurantiaco", (IClassification)BeeClassification.METALLIC, 0x720000, 16752128, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    COBALT("Cobalt", "caeruleo", (IClassification)BeeClassification.METALLIC, 206431, 5876463, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    MANYULLYN("Manyullyn", "manahmanah", (IClassification)BeeClassification.METALLIC, 4726125, 12423921, EnumTemperature.HOT, EnumHumidity.ARID, true, false),
    OSMIUM("Osmium", "hyacintho", (IClassification)BeeClassification.METALLIC, 3623771, 7109513, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    DIAMOND("Diamond", "diamond", (IClassification)BeeClassification.GEM, 2135425, 9303523, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    EMERALD("Emerald", "prasinus", (IClassification)BeeClassification.GEM, 21248, 1564002, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    APATITE("Apatite", "apatite", (IClassification)BeeClassification.GEM, 3057644, 7505, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    SILICON("Silicon", "siliconisque", (IClassification)BeeClassification.GEM, 11379367, 7562869, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    CERTUS("Certus", "alia cristallum", (IClassification)BeeClassification.GEM, 9684991, 10926279, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    FLUIX("Fluix", "alien cristallum", (IClassification)BeeClassification.GEM, 16540574, 5457815, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    MUTABLE("Mutable", "mutable", (IClassification)BeeClassification.TRANSMUTING, 14398028, 14734758, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TRANSMUTING("Transmuting", "transmuting", (IClassification)BeeClassification.TRANSMUTING, 14398028, 10670808, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    CRUMBLING("Crumbling", "crumbling", (IClassification)BeeClassification.TRANSMUTING, 14398028, 14394532, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    INVISIBLE("Invisible", "invisible", (IClassification)BeeClassification.VEILED, 0xFFCCFF, 0xFFFFFF, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_AIR("TCAir", "aether", (IClassification)BeeClassification.THAUMIC, 14276150, 0x999999, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    TC_FIRE("TCFire", "praefervidus", (IClassification)BeeClassification.THAUMIC, 15010571, 0x999999, EnumTemperature.HOT, EnumHumidity.ARID, true, true),
    TC_WATER("TCWater", "umidus", (IClassification)BeeClassification.THAUMIC, 3592153, 0x999999, EnumTemperature.NORMAL, EnumHumidity.DAMP, true, true),
    TC_EARTH("TCEarth", "sordida", (IClassification)BeeClassification.THAUMIC, 20736, 0x999999, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    TC_ORDER("TCOrder", "ordinatus", (IClassification)BeeClassification.THAUMIC, 11154172, 0x999999, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    TC_CHAOS("TCChaos", "tenebrarum", (IClassification)BeeClassification.THAUMIC, 0xCCCCCC, 0x999999, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    TC_VIS("TCVis", "arcanus saecula", (IClassification)BeeClassification.THAUMIC, 19609, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_REJUVENATING("TCRejuvenating", "arcanus vitae", (IClassification)BeeClassification.THAUMIC, 9556185, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_EMPOWERING("TCEmpowering", "tractus", (IClassification)BeeClassification.THAUMIC, 9895868, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_NEXUS("TCNexus", "nexi", (IClassification)BeeClassification.THAUMIC, 1421231, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    TC_TAINT("TCFlux", "arcanus labe", (IClassification)BeeClassification.THAUMIC, 9516906, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_PURE("TCPure", "arcanus puritatem", (IClassification)BeeClassification.THAUMIC, 14827365, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_HUNGRY("TCHungry", "omnique", (IClassification)BeeClassification.THAUMIC, 14460386, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_BRAINY("TCBrainy", "cerebrum", (IClassification)BeeClassification.THAUMIC, 8650608, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_WISPY("TCWispy", "umbrabilis", (IClassification)BeeClassification.THAUMIC, 10270933, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_BATTY("TCBatty", "chiroptera", (IClassification)BeeClassification.THAUMIC, 2569485, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_CHICKEN("TCChicken", "pullus", (IClassification)BeeClassification.FLESHY, 8209182, 14717022, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_BEEF("TCBeef", "bubulae", (IClassification)BeeClassification.FLESHY, 4203034, 11298643, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_PORK("TCPork", "porcina", (IClassification)BeeClassification.FLESHY, 7494959, 13811603, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    EE_MINIUM("EEMinium", "mutabilis", (IClassification)BeeClassification.ALCHEMICAL, 11274529, 3801867, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    AM_ESSENCE("AMEssence", "essentia", (IClassification)BeeClassification.ESSENTIAL, 8829893, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    AM_QUINTESSENCE("AMQuintessence", "cor essentia", (IClassification)BeeClassification.ESSENTIAL, 14918747, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    AM_EARTH("AMEarth", "magica terra", (IClassification)BeeClassification.ESSENTIAL, 11175774, 14919003, EnumTemperature.WARM, EnumHumidity.ARID, false, false),
    AM_AIR("AMAir", "magica aer", (IClassification)BeeClassification.ESSENTIAL, 14019485, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    AM_FIRE("AMFire", "magica ignis", (IClassification)BeeClassification.ESSENTIAL, 9651486, 14919003, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    AM_WATER("AMWater", "magica aqua", (IClassification)BeeClassification.ESSENTIAL, 3898764, 14919003, EnumTemperature.NORMAL, EnumHumidity.DAMP, false, false),
    AM_LIGHTNING("AMLightning", "magica fulgur", (IClassification)BeeClassification.ESSENTIAL, 15462305, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    AM_PLANT("AMPlant", "magica herba", (IClassification)BeeClassification.ESSENTIAL, 4830537, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    AM_ICE("AMIce", "magica glacium", (IClassification)BeeClassification.ESSENTIAL, 8829638, 14919003, EnumTemperature.COLD, EnumHumidity.NORMAL, false, false),
    AM_ARCANE("AMArcane", "magica arcanum", (IClassification)BeeClassification.ESSENTIAL, 7739469, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    AM_VORTEX("AMVortex", "gurges", (IClassification)BeeClassification.ESSENTIAL, 7453666, 734632, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    AM_WIGHT("AMWight", "vectem", (IClassification)BeeClassification.ESSENTIAL, 0xB50000, 4999223, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_BLIZZY("TEBlizzy", "blizzard", BeeClassification.ABOMINABLE, 29636, EnumTemperature.COLD, EnumHumidity.NORMAL, false, false),
    TE_GELID("TEGelid", "cyro", BeeClassification.ABOMINABLE, 4894711, EnumTemperature.COLD, EnumHumidity.NORMAL, true, true),
    TE_DANTE("TEDante", "inferno", BeeClassification.ABOMINABLE, 16231498, EnumTemperature.HELLISH, EnumHumidity.ARID, false, false),
    TE_PYRO("TEPyro", "pyromaniac", BeeClassification.ABOMINABLE, 16421644, EnumTemperature.HELLISH, EnumHumidity.ARID, true, true),
    TE_ELECTRUM("TEElectrum", "electrum", BeeClassification.THERMAL, 15398814, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    TE_PLATINUM("TEPlatinum", "platina", BeeClassification.THERMAL, 10414071, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_NICKEL("TENickel", "nickel", BeeClassification.THERMAL, 11848073, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_INVAR("TEInvar", "invar", BeeClassification.THERMAL, 13493153, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    TE_BRONZE("TEBronze", "pyropus", BeeClassification.THERMAL, 11889927, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_COAL("TECoal", "carbonis", BeeClassification.THERMAL, 0x2E2D2D, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_DESTABILIZED("TEDestabilized", "electric", BeeClassification.THERMAL, 6160899, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_LUX("TELux", "lux", BeeClassification.THERMAL, 15858313, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_WINSOME("TEWinsome", "cuniculus", BeeClassification.ADORABLE, 617319, EnumTemperature.COLD, EnumHumidity.NORMAL, false, false),
    TE_ENDEARING("TEEndearing", "cognito", BeeClassification.ADORABLE, 433815, EnumTemperature.COLD, EnumHumidity.NORMAL, true, true),
    RSA_FLUXED("RSAFluxed", "Thermametallic electroflux", BeeClassification.THERMAL, 10356237, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    BM_BLOODY("BMBloody", "sanguis", BeeClassification.BLOODY, 11997231, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    BM_BOUND("BMBound", "obligatus", BeeClassification.BLOODY, 11997231, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    BOT_ROOTED("BotRooted", "truncus", (IClassification)BeeClassification.BOTANICAL, 43008, 0xFFB2BB, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    BOT_BOTANIC("BotBotanic", "botanica", (IClassification)BeeClassification.BOTANICAL, 9750113, 0xFFB2BB, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    BOT_BLOSSOM("BotBlossom", "viridis", (IClassification)BeeClassification.BOTANICAL, 10797459, 0xFFB2BB, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    BOT_FLORAL("BotFloral", "florens", (IClassification)BeeClassification.BOTANICAL, 2742298, 0xFFB2BB, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    BOT_VAZBEE("BotVazbee", "vazbii", (IClassification)BeeClassification.BOTANICAL, 16739228, 0xFFB2BB, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    BOT_SOMNOLENT("BotSomnolent", "soporatus", BeeClassification.BOTANICAL, 2717894, 0xFFB2BB, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false, true, true, true),
    BOT_DREAMING("BotDreaming", "somnior", BeeClassification.BOTANICAL, 1193046, 0xFFB2BB, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false, true, true, true),
    BOT_ALFHEIM("BotAlfheim", "alfheimis", (IClassification)BeeClassification.BOTANICAL, -1, -1, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    AE_SKYSTONE("AESkystone", "terra astris", (IClassification)BeeClassification.TRANSMUTING, 4948865, 0x252929, EnumTemperature.HOT, EnumHumidity.ARID, false, true);

    private String binomial;
    private String authority;
    private int primaryColour;
    private int secondaryColour;
    private EnumTemperature temperature;
    private EnumHumidity humidity;
    private boolean hasEffect;
    private boolean isSecret;
    private boolean isCounted;
    private boolean isActive;
    private boolean isNocturnal;
    private IClassification branch;
    private HashMap<ItemStack, Float> products;
    @Deprecated
    private HashMap<ItemStack, Integer> oldProducts;
    private HashMap<ItemStack, Float> specialties;
    @Deprecated
    private HashMap<ItemStack, Integer> oldSpecialties;
    private IAllele[] genomeTemplate;
    private String uid;
    private boolean dominant;
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] icons;

    public static void setupBeeSpecies() {
        MYSTICAL.registerGenomeTemplate(BeeGenomeManager.getTemplateMystical());
        SORCEROUS.registerGenomeTemplate(BeeGenomeManager.getTemplateSorcerous());
        UNUSUAL.registerGenomeTemplate(BeeGenomeManager.getTemplateUnusual());
        ATTUNED.registerGenomeTemplate(BeeGenomeManager.getTemplateAttuned());
        ELDRITCH.registerGenomeTemplate(BeeGenomeManager.getTemplateEldritch());
        ESOTERIC.registerGenomeTemplate(BeeGenomeManager.getTemplateEsoteric());
        MYSTERIOUS.registerGenomeTemplate(BeeGenomeManager.getTemplateMysterious());
        ARCANE.registerGenomeTemplate(BeeGenomeManager.getTemplateArcane());
        CHARMED.registerGenomeTemplate(BeeGenomeManager.getTemplateCharmed());
        ENCHANTED.registerGenomeTemplate(BeeGenomeManager.getTemplateEnchanted());
        SUPERNATURAL.registerGenomeTemplate(BeeGenomeManager.getTemplateSupernatural());
        ETHEREAL.registerGenomeTemplate(BeeGenomeManager.getTemplateEthereal());
        WATERY.registerGenomeTemplate(BeeGenomeManager.getTemplateWatery());
        EARTHY.registerGenomeTemplate(BeeGenomeManager.getTemplateEarthy());
        FIREY.registerGenomeTemplate(BeeGenomeManager.getTemplateFirey());
        WINDY.registerGenomeTemplate(BeeGenomeManager.getTemplateWindy());
        PUPIL.registerGenomeTemplate(BeeGenomeManager.getTemplatePupil());
        SCHOLARLY.registerGenomeTemplate(BeeGenomeManager.getTemplateScholarly());
        SAVANT.registerGenomeTemplate(BeeGenomeManager.getTemplateSavant());
        AWARE.registerGenomeTemplate(BeeGenomeManager.getTemplateAware());
        SPIRIT.registerGenomeTemplate(BeeGenomeManager.getTemplateSpirit());
        SOUL.registerGenomeTemplate(BeeGenomeManager.getTemplateSoul());
        SKULKING.registerGenomeTemplate(BeeGenomeManager.getTemplateSkulking());
        GHASTLY.registerGenomeTemplate(BeeGenomeManager.getTemplateGhastly());
        SPIDERY.registerGenomeTemplate(BeeGenomeManager.getTemplateSpidery());
        SMOULDERING.registerGenomeTemplate(BeeGenomeManager.getTemplateSmouldering());
        BIGBAD.registerGenomeTemplate(BeeGenomeManager.getTemplateBigbad());
        TIMELY.registerGenomeTemplate(BeeGenomeManager.getTemplateTimely());
        LORDLY.registerGenomeTemplate(BeeGenomeManager.getTemplateLordly());
        DOCTORAL.registerGenomeTemplate(BeeGenomeManager.getTemplateDoctoral());
        INFERNAL.registerGenomeTemplate(BeeGenomeManager.getTemplateInfernal());
        HATEFUL.registerGenomeTemplate(BeeGenomeManager.getTemplateHateful());
        SPITEFUL.registerGenomeTemplate(BeeGenomeManager.getTemplateSpiteful());
        WITHERING.registerGenomeTemplate(BeeGenomeManager.getTemplateWithering());
        OBLIVION.registerGenomeTemplate(BeeGenomeManager.getTemplateOblivion());
        NAMELESS.registerGenomeTemplate(BeeGenomeManager.getTemplateNameless());
        ABANDONED.registerGenomeTemplate(BeeGenomeManager.getTemplateAbandoned());
        FORLORN.registerGenomeTemplate(BeeGenomeManager.getTemplateForlorn());
        DRACONIC.registerGenomeTemplate(BeeGenomeManager.getTemplateDraconic());
        IRON.registerGenomeTemplate(BeeGenomeManager.getTemplateIron());
        GOLD.registerGenomeTemplate(BeeGenomeManager.getTemplateGold());
        COPPER.registerGenomeTemplate(BeeGenomeManager.getTemplateCopper());
        TIN.registerGenomeTemplate(BeeGenomeManager.getTemplateTin());
        SILVER.registerGenomeTemplate(BeeGenomeManager.getTemplateSilver());
        LEAD.registerGenomeTemplate(BeeGenomeManager.getTemplateLead());
        ALUMINUM.registerGenomeTemplate(BeeGenomeManager.getTemplateAluminum());
        ARDITE.registerGenomeTemplate(BeeGenomeManager.getTemplateArdite());
        COBALT.registerGenomeTemplate(BeeGenomeManager.getTemplateCobalt());
        MANYULLYN.registerGenomeTemplate(BeeGenomeManager.getTemplateManyullyn());
        OSMIUM.registerGenomeTemplate(BeeGenomeManager.getTemplateOsmium());
        DIAMOND.registerGenomeTemplate(BeeGenomeManager.getTemplateDiamond());
        EMERALD.registerGenomeTemplate(BeeGenomeManager.getTemplateEmerald());
        APATITE.registerGenomeTemplate(BeeGenomeManager.getTemplateApatite());
        SILICON.registerGenomeTemplate(BeeGenomeManager.getTemplateSilicon());
        FLUIX.registerGenomeTemplate(BeeGenomeManager.getTemplateFluix());
        CERTUS.registerGenomeTemplate(BeeGenomeManager.getTemplateCertus());
        MUTABLE.registerGenomeTemplate(BeeGenomeManager.getTemplateMutable());
        TRANSMUTING.registerGenomeTemplate(BeeGenomeManager.getTemplateTransmuting());
        CRUMBLING.registerGenomeTemplate(BeeGenomeManager.getTemplateCrumbling());
        INVISIBLE.registerGenomeTemplate(BeeGenomeManager.getTemplateInvisible());
        TC_AIR.registerGenomeTemplate(BeeGenomeManager.getTemplateTCAir());
        TC_FIRE.registerGenomeTemplate(BeeGenomeManager.getTemplateTCFire());
        TC_WATER.registerGenomeTemplate(BeeGenomeManager.getTemplateTCWater());
        TC_EARTH.registerGenomeTemplate(BeeGenomeManager.getTemplateTCEarth());
        TC_ORDER.registerGenomeTemplate(BeeGenomeManager.getTemplateTCOrder());
        TC_CHAOS.registerGenomeTemplate(BeeGenomeManager.getTemplateTCChaos());
        TC_VIS.registerGenomeTemplate(BeeGenomeManager.getTemplateTCVis());
        TC_REJUVENATING.registerGenomeTemplate(BeeGenomeManager.getTemplateTCRejuvinating());
        TC_EMPOWERING.registerGenomeTemplate(BeeGenomeManager.getTemplateTCEmpowering());
        TC_NEXUS.registerGenomeTemplate(BeeGenomeManager.getTemplateTCNexus());
        TC_TAINT.registerGenomeTemplate(BeeGenomeManager.getTemplateTCTaint());
        TC_PURE.registerGenomeTemplate(BeeGenomeManager.getTemplateTCPure());
        TC_HUNGRY.registerGenomeTemplate(BeeGenomeManager.getTemplateTCHungry());
        TC_BRAINY.registerGenomeTemplate(BeeGenomeManager.getTemplateTCBrainy());
        TC_WISPY.registerGenomeTemplate(BeeGenomeManager.getTemplateTCWispy());
        TC_BATTY.registerGenomeTemplate(BeeGenomeManager.getTemplateTCBatty());
        TC_CHICKEN.registerGenomeTemplate(BeeGenomeManager.getTemplateTCChicken());
        TC_BEEF.registerGenomeTemplate(BeeGenomeManager.getTemplateTCBeef());
        TC_PORK.registerGenomeTemplate(BeeGenomeManager.getTemplateTCPork());
        EE_MINIUM.registerGenomeTemplate(BeeGenomeManager.getTemplateEEMinium());
        AM_ESSENCE.registerGenomeTemplate(BeeGenomeManager.getTemplateAMEssence());
        AM_QUINTESSENCE.registerGenomeTemplate(BeeGenomeManager.getTemplateAMQuintessence());
        AM_EARTH.registerGenomeTemplate(BeeGenomeManager.getTemplateAMEarth());
        AM_AIR.registerGenomeTemplate(BeeGenomeManager.getTemplateAMAir());
        AM_FIRE.registerGenomeTemplate(BeeGenomeManager.getTemplateAMFire());
        AM_WATER.registerGenomeTemplate(BeeGenomeManager.getTemplateAMWater());
        AM_LIGHTNING.registerGenomeTemplate(BeeGenomeManager.getTemplateAMLightning());
        AM_PLANT.registerGenomeTemplate(BeeGenomeManager.getTemplateAMPlant());
        AM_ICE.registerGenomeTemplate(BeeGenomeManager.getTemplateAMIce());
        AM_ARCANE.registerGenomeTemplate(BeeGenomeManager.getTemplateAMArcane());
        AM_VORTEX.registerGenomeTemplate(BeeGenomeManager.getTemplateAMVortex());
        AM_WIGHT.registerGenomeTemplate(BeeGenomeManager.getTemplateAMWight());
        TE_BLIZZY.registerGenomeTemplate(BeeGenomeManager.getTemplateTEBlizzy());
        TE_GELID.registerGenomeTemplate(BeeGenomeManager.getTemplateTEGelid());
        TE_DANTE.registerGenomeTemplate(BeeGenomeManager.getTemplateTEDante());
        TE_PYRO.registerGenomeTemplate(BeeGenomeManager.getTemplateTEPyro());
        TE_ELECTRUM.registerGenomeTemplate(BeeGenomeManager.getTemplateTEElectrum());
        TE_PLATINUM.registerGenomeTemplate(BeeGenomeManager.getTemplateTEPlatinum());
        TE_NICKEL.registerGenomeTemplate(BeeGenomeManager.getTemplateTENickel());
        TE_INVAR.registerGenomeTemplate(BeeGenomeManager.getTemplateTEInvar());
        TE_BRONZE.registerGenomeTemplate(BeeGenomeManager.getTemplateTEBronze());
        TE_COAL.registerGenomeTemplate(BeeGenomeManager.getTemplateTECoal());
        TE_DESTABILIZED.registerGenomeTemplate(BeeGenomeManager.getTemplateTEDestabilized());
        TE_LUX.registerGenomeTemplate(BeeGenomeManager.getTemplateTELux());
        TE_WINSOME.registerGenomeTemplate(BeeGenomeManager.getTemplateTEWinsome());
        TE_ENDEARING.registerGenomeTemplate(BeeGenomeManager.getTemplateTEEndearing());
        RSA_FLUXED.registerGenomeTemplate(BeeGenomeManager.getTemplateRSAFluxed());
        BM_BLOODY.registerGenomeTemplate(BeeGenomeManager.getTemplateBMBloody());
        BM_BOUND.registerGenomeTemplate(BeeGenomeManager.getTemplateBMBound());
        BOT_ROOTED.registerGenomeTemplate(BeeGenomeManager.getTemplateBotRooted());
        BOT_BOTANIC.registerGenomeTemplate(BeeGenomeManager.getTemplateBotBotanic());
        BOT_BLOSSOM.registerGenomeTemplate(BeeGenomeManager.getTemplateBotBlossom());
        BOT_FLORAL.registerGenomeTemplate(BeeGenomeManager.getTemplateBotFloral());
        BOT_VAZBEE.registerGenomeTemplate(BeeGenomeManager.getTemplateBotVazbee());
        BOT_SOMNOLENT.registerGenomeTemplate(BeeGenomeManager.getTemplateBotSomnolent());
        BOT_DREAMING.registerGenomeTemplate(BeeGenomeManager.getTemplateBotDreaming());
        BOT_ALFHEIM.registerGenomeTemplate(BeeGenomeManager.getTemplateBotAelfheim());
        AE_SKYSTONE.registerGenomeTemplate(BeeGenomeManager.getTemplateAESkystone());
        BeeProductHelper.initThaumcraftProducts();
        if (!ThaumcraftHelper.isActive()) {
            TC_CHAOS.setInactive();
            TC_AIR.setInactive();
            TC_FIRE.setInactive();
            TC_WATER.setInactive();
            TC_EARTH.setInactive();
            TC_ORDER.setInactive();
            TC_VIS.setInactive();
            TC_PURE.setInactive();
            TC_BRAINY.setInactive();
            TC_BATTY.setInactive();
            TC_CHICKEN.setInactive();
            TC_BEEF.setInactive();
            TC_PORK.setInactive();
            TC_WISPY.setInactive();
        }
        TC_TAINT.setInactive();
        TC_EMPOWERING.setInactive();
        BeeProductHelper.initEquivalentExchange3Species();
        if (!EquivalentExchangeHelper.isActive()) {
            EE_MINIUM.setInactive();
        }
        BeeProductHelper.initArsMagicaSpecies();
        if (!ArsMagicaHelper.isActive()) {
            AM_ESSENCE.setInactive();
            AM_QUINTESSENCE.setInactive();
            AM_EARTH.setInactive();
            AM_AIR.setInactive();
            AM_FIRE.setInactive();
            AM_WATER.setInactive();
            AM_LIGHTNING.setInactive();
            AM_PLANT.setInactive();
            AM_ICE.setInactive();
            AM_ARCANE.setInactive();
            AM_VORTEX.setInactive();
            AM_WIGHT.setInactive();
        }
        BeeProductHelper.initThermalExpansionProducts();
        if (!ThermalExpansionHelper.isActive()) {
            TE_BLIZZY.setInactive();
            TE_GELID.setInactive();
            TE_DANTE.setInactive();
            TE_PYRO.setInactive();
            TE_DESTABILIZED.setInactive();
            TE_COAL.setInactive();
            TE_LUX.setInactive();
            TE_WINSOME.setInactive();
            TE_ENDEARING.setInactive();
        }
        BeeProductHelper.initRedstoneArsenelProducts();
        if (!RedstoneArsenalHelper.isActive()) {
            RSA_FLUXED.setInactive();
        }
        BeeProductHelper.initBloodMagicProducts();
        if (!BloodMagicHelper.isActive()) {
            BM_BLOODY.setInactive();
            BM_BOUND.setInactive();
        }
        BeeProductHelper.initBotaniaProducts();
        if (!BotaniaHelper.isActive()) {
            BOT_ROOTED.setInactive();
            BOT_BLOSSOM.setInactive();
            BOT_BOTANIC.setInactive();
            BOT_FLORAL.setInactive();
            BOT_VAZBEE.setInactive();
            BOT_SOMNOLENT.setInactive();
            BOT_DREAMING.setInactive();
            BOT_ALFHEIM.setInactive();
        }
        BeeProductHelper.initAppEngProducts();
        if (!AppliedEnergisticsHelper.isActive()) {
            AE_SKYSTONE.setInactive();
        }
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean hasGlowEffect, boolean isSpeciesDominant) {
        this(speciesName, genusName, classification, firstColour, 16743462, preferredTemp, preferredHumidity, hasGlowEffect, true, true, isSpeciesDominant, false);
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, int secondColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean hasGlowEffect, boolean isSpeciesDominant) {
        this(speciesName, genusName, classification, firstColour, secondColour, preferredTemp, preferredHumidity, hasGlowEffect, true, true, isSpeciesDominant, false);
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, int secondColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean isSecret, boolean hasGlowEffect, boolean isSpeciesDominant) {
        this(speciesName, genusName, classification, firstColour, secondColour, preferredTemp, preferredHumidity, hasGlowEffect, isSecret, true, isSpeciesDominant, false);
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean isSecret, boolean hasGlowEffect, boolean isSpeciesDominant) {
        this(speciesName, genusName, classification, firstColour, 16743462, preferredTemp, preferredHumidity, hasGlowEffect, isSecret, true, isSpeciesDominant, false);
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, int secondColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean hasGlowEffect, boolean isSpeciesSecret, boolean isSpeciesCounted, boolean isSpeciesDominant, boolean isSpeciesNocturnal) {
        this.uid = "magicbees.species" + speciesName;
        this.dominant = isSpeciesDominant;
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
        this.binomial = genusName;
        this.authority = "MysteriousAges";
        this.primaryColour = firstColour;
        this.secondaryColour = secondColour;
        this.temperature = preferredTemp;
        this.humidity = preferredHumidity;
        this.hasEffect = hasGlowEffect;
        this.isSecret = isSpeciesSecret;
        this.isCounted = isSpeciesCounted;
        this.products = new HashMap();
        this.oldProducts = new HashMap();
        this.specialties = new HashMap();
        this.oldSpecialties = new HashMap();
        this.branch = classification;
        this.branch.addMemberSpecies((IAlleleSpecies)this);
        this.isNocturnal = isSpeciesNocturnal;
        this.isActive = true;
    }

    public IAllele[] getGenome() {
        return this.genomeTemplate;
    }

    @Deprecated
    public BeeSpecies addProduct(ItemStack produce, int percentChance) {
        return null;
    }

    public BeeSpecies addProduct(ItemStack produce, float chance) {
        this.products.put(produce, Float.valueOf(chance));
        this.oldProducts.put(produce, (int)(chance * 100.0f));
        return this;
    }

    @Deprecated
    public BeeSpecies addSpecialty(ItemStack produce, int percentChance) {
        return null;
    }

    public BeeSpecies addSpecialty(ItemStack produce, float chance) {
        this.specialties.put(produce, Float.valueOf(chance));
        this.oldSpecialties.put(produce, (int)(chance * 100.0f));
        return this;
    }

    public ItemStack getBeeItem(EnumBeeType beeType) {
        return BeeManager.beeRoot.getMemberStack((IIndividual)BeeManager.beeRoot.getBee(null, BeeManager.beeRoot.templateAsGenome(this.genomeTemplate)), beeType.ordinal());
    }

    public String getName() {
        return LocalizationManager.getLocalizedString(this.getUID());
    }

    public String getDescription() {
        return LocalizationManager.getLocalizedString(this.getUID() + ".description");
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    public boolean hasEffect() {
        return this.hasEffect;
    }

    public BeeSpecies setInactive() {
        this.isActive = false;
        AlleleManager.alleleRegistry.blacklistAllele(this.getUID());
        return this;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public boolean isCounted() {
        return this.isCounted;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return this.authority;
    }

    public IClassification getBranch() {
        return this.branch;
    }

    public Map<ItemStack, Float> getProductChances() {
        return this.products;
    }

    public Map<ItemStack, Float> getSpecialtyChances() {
        return this.specialties;
    }

    @Deprecated
    public HashMap<ItemStack, Integer> getProducts() {
        return this.oldProducts;
    }

    @Deprecated
    public HashMap<ItemStack, Integer> getSpecialty() {
        return this.oldSpecialties;
    }

    public String getUID() {
        return this.uid;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    public boolean isNocturnal() {
        return this.isNocturnal;
    }

    public boolean isJubilant(IBeeGenome genome, IBeeHousing housing) {
        return true;
    }

    public void registerGenomeTemplate(IAllele[] genome) {
        this.genomeTemplate = genome;
        BeeManager.beeRoot.registerTemplate(this.getUID(), genome);
    }

    public int getIconColour(int renderPass) {
        int value = 0xFFFFFF;
        if (renderPass == 0) {
            if (this.primaryColour == -1) {
                int hue = (int)(System.currentTimeMillis() >> 2) % 360;
                value = Color.getHSBColor((float)hue / 360.0f, 0.75f, 0.8f).getRGB();
            } else {
                value = this.primaryColour;
            }
        } else if (renderPass == 1) {
            if (this.secondaryColour == -1) {
                int hue = (int)(System.currentTimeMillis() >> 3) % 360;
                hue += 60;
                value = Color.getHSBColor((float)(hue %= 360) / 360.0f, 0.5f, 0.6f).getRGB();
            } else {
                value = this.secondaryColour;
            }
        }
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(EnumBeeType type, int renderPass) {
        return this.icons[type.ordinal()][Math.min(renderPass, 2)];
    }

    public int getComplexity() {
        return 1 + this.getMutationPathLength((IAllele)this, new ArrayList<IAllele>());
    }

    private int getMutationPathLength(IAllele species, ArrayList<IAllele> excludeSpecies) {
        int own = 1;
        int highest = 0;
        excludeSpecies.add(species);
        for (IMutation mutation : this.getRoot().getPaths(species, (IChromosomeType)EnumBeeChromosome.SPECIES)) {
            int otherAdvance;
            if (!excludeSpecies.contains(mutation.getAllele0()) && (otherAdvance = this.getMutationPathLength(mutation.getAllele0(), excludeSpecies)) > highest) {
                highest = otherAdvance;
            }
            if (excludeSpecies.contains(mutation.getAllele1()) || (otherAdvance = this.getMutationPathLength(mutation.getAllele1(), excludeSpecies)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest > 0 ? highest : 0);
    }

    public float getResearchSuitability(ItemStack itemStack) {
        if (itemStack == null) {
            return 0.0f;
        }
        for (ItemStack itemStack2 : this.products.keySet()) {
            if (!itemStack.func_77969_a(itemStack2)) continue;
            return 1.0f;
        }
        for (ItemStack itemStack3 : this.specialties.keySet()) {
            if (!itemStack3.func_77969_a(itemStack)) continue;
            return 1.0f;
        }
        if (itemStack.func_77973_b() == ForestryHelper.honeyDrop) {
            return 0.5f;
        }
        if (itemStack.func_77973_b() == ForestryHelper.honeydew) {
            return 0.7f;
        }
        if (itemStack.func_77973_b() == ForestryHelper.beeComb || itemStack.func_77973_b() == Config.combs) {
            return 0.4f;
        }
        if (this.getRoot().isMember(itemStack)) {
            return 1.0f;
        }
        for (Map.Entry entry : BeeManager.beeRoot.getResearchCatalysts().entrySet()) {
            if (!OreDictionary.itemMatches((ItemStack)itemStack, (ItemStack)((ItemStack)entry.getKey()), (boolean)false)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        ItemStack copy;
        Collection resultantMutations;
        System.out.println("Bounty level: " + bountyLevel);
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        if (world.field_73012_v.nextFloat() < 10.0f / (float)bountyLevel && (resultantMutations = this.getRoot().getCombinations((IAllele)this)).size() > 0) {
            IMutation[] candidates = resultantMutations.toArray(new IMutation[resultantMutations.size()]);
            bounty.add(AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.field_73012_v.nextInt(candidates.length)]));
        }
        for (ItemStack product : this.products.keySet()) {
            copy = product.func_77946_l();
            copy.field_77994_a = 1 + world.field_73012_v.nextInt(bountyLevel / 2);
            bounty.add(copy);
        }
        for (ItemStack specialty : this.specialties.keySet()) {
            copy = specialty.func_77946_l();
            copy.field_77994_a = world.field_73012_v.nextInt(bountyLevel / 3);
            if (copy.field_77994_a <= 0) continue;
            bounty.add(copy);
        }
        return bounty.toArray(new ItemStack[bounty.size()]);
    }

    public String getEntityTexture() {
        return "/gfx/forestry/entities/bees/honeyBee.png";
    }

    public void registerIcons(IIconRegister itemMap) {
        this.icons = new IIcon[EnumBeeType.values().length][3];
        String root = this.getIconPath();
        IIcon body1 = itemMap.func_94245_a(root + "body1");
        for (int i = 0; i < EnumBeeType.values().length; ++i) {
            if (EnumBeeType.values()[i] == EnumBeeType.NONE) continue;
            this.icons[i][0] = itemMap.func_94245_a(root + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".outline");
            this.icons[i][1] = EnumBeeType.values()[i] != EnumBeeType.LARVAE ? body1 : itemMap.func_94245_a(root + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body");
            this.icons[i][2] = itemMap.func_94245_a(root + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body2");
        }
    }

    private String getIconPath() {
        String value;
        switch (this) {
            case SKULKING: 
            case GHASTLY: 
            case SPIDERY: 
            case SMOULDERING: 
            case BIGBAD: 
            case TC_BRAINY: 
            case TC_WISPY: 
            case TC_BATTY: 
            case AM_VORTEX: 
            case AM_WIGHT: 
            case TE_BLIZZY: 
            case TE_GELID: 
            case TE_DANTE: 
            case TE_PYRO: {
                value = "magicbees:bees/skulking/";
                break;
            }
            case DOCTORAL: {
                value = "magicbees:bees/doctoral/";
                break;
            }
            default: {
                value = "Forestry".toLowerCase() + ":bees/default/";
            }
        }
        return value;
    }

    public boolean canWorkInTemperature(EnumTemperature temp) {
        IAlleleTolerance tolerance = (IAlleleTolerance)this.genomeTemplate[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()];
        return AlleleManager.climateHelper.isWithinLimits(temp, EnumHumidity.NORMAL, this.temperature, tolerance.getValue(), EnumHumidity.NORMAL, EnumTolerance.NONE);
    }

    public boolean canWorkInHumidity(EnumHumidity humid) {
        IAlleleTolerance tolerance = (IAlleleTolerance)this.genomeTemplate[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()];
        return AlleleManager.climateHelper.isWithinLimits(EnumTemperature.NORMAL, humid, EnumTemperature.NORMAL, EnumTolerance.NONE, this.humidity, tolerance.getValue());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(short texUID) {
        return this.icons[0][0];
    }

    private class BodyColours {
        static final int DEFAULT = 16743462;
        static final int ARCANE = 16751968;
        static final int ABOMINABLE = 9834240;
        static final int EXTRINSIC = 0xF696FF;
        static final int SKULKING = 14766646;
        static final int THAUMCRAFT_SHARD = 0x999999;
        static final int THAUMCRAFT_NODE = 6774481;
        static final int ARSMAGICA = 14919003;
        static final int BOTANIA = 0xFFB2BB;

        private BodyColours() {
        }
    }
}

