/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele.flowerProvider;

import forestry.api.genetics.IFlower;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import java.util.ArrayList;
import java.util.List;
import magicbees.bees.allele.flowerProvider.FlowerImpl;
import magicbees.bees.allele.flowerProvider.FlowerProvider;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.compat.ThaumcraftHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FlowerProviderAuraNode
extends FlowerProvider {
    public FlowerProviderAuraNode() {
        super(2);
        this.flowers.add(new FlowerImpl(ThaumcraftHelper.airy, ThaumcraftHelper.AiryBlockType.NODE.ordinal(), 1.0, false));
        this.flowers.add(new FlowerImpl(ThaumcraftHelper.airy, ThaumcraftHelper.AiryBlockType.ENERGIZED_NODE.ordinal(), 1.0, false));
    }

    @Override
    public boolean isAcceptedFlower(World world, IIndividual genome, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        for (IFlower flower : this.flowers) {
            if (flower.getBlock() != block || flower.getMeta() != Short.MAX_VALUE && flower.getMeta() != meta) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        return pollinatable.getPlantType().size() > 0;
    }

    @Override
    public boolean growFlower(World world, IIndividual genome, int x, int y, int z) {
        return true;
    }

    @Override
    public String getDescription() {
        return LocalizationManager.getLocalizedString("flowerProvider.node");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual genome, int x, int y, int z, ItemStack[] products) {
        if (this.isAcceptedFlower(world, genome, x, y, z)) {
            // empty if block
        }
        return products;
    }

    protected ItemStack[] addItemToProducts(ItemStack[] products, ItemStack itemStack) {
        for (ItemStack stack : products) {
            if (stack.func_77973_b() != itemStack.func_77973_b() || stack.func_77960_j() != itemStack.func_77960_j() || stack.field_77994_a >= stack.func_77973_b().getItemStackLimit(stack)) continue;
            stack.field_77994_a += itemStack.field_77994_a;
            itemStack.field_77994_a = Math.max(stack.field_77994_a - stack.func_77973_b().getItemStackLimit(stack), 0);
        }
        if (itemStack.field_77994_a > 0) {
            ItemStack[] newProducts = new ItemStack[products.length + 1];
            for (int i = 0; i < products.length; ++i) {
                newProducts[i] = products[i];
            }
            newProducts[products.length] = itemStack;
            products = newProducts;
        }
        return products;
    }

    @Override
    public List<IFlower> getFlowers() {
        return new ArrayList<IFlower>();
    }
}

