/*
 * Decompiled with CFR 0.152.
 */
package magicbees.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import magicbees.block.types.PlankType;
import magicbees.main.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWoodSlab
extends BlockSlab {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockWoodSlab(boolean doubleSlab) {
        super(doubleSlab, Material.field_151575_d);
        this.func_149711_c(2.5f);
        this.func_149752_b(6.0f);
        this.func_149663_c("tb.slab.wood");
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149713_g(doubleSlab ? 255 : 0);
        if (Config.areMagicPlanksFlammable) {
            Blocks.field_150480_ab.setFireInfo((Block)this, 5, 20);
        }
    }

    public Item func_149650_a(int id, Random rand, int par3) {
        return Item.func_150898_a((Block)Config.slabWoodHalf);
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)Config.planksWood, 1, meta & 7);
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a() + "." + PlankType.getType((int)meta).name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List itemsList) {
        for (PlankType type : PlankType.values()) {
            itemsList.add(new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[Math.max(0, Math.min(meta & 7, this.icons.length - 1))];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.icons = new IIcon[PlankType.values().length];
        for (PlankType t : PlankType.values()) {
            this.icons[t.ordinal()] = par1IconRegister.func_94245_a("magicbees:" + t.name);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return null;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, this.func_149643_k(world, x, y, z) & 7);
    }
}

