/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class APICustomEMCMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    public static APICustomEMCMapper instance = new APICustomEMCMapper();
    public static final int PRIORITY_MIN_VALUE = 0;
    public static final int PRIORITY_MAX_VALUE = 512;
    public static final int PRIORITY_DEFAULT_VALUE = 1;
    Map<String, Map<String, Integer>> customEMCforMod = new HashMap<String, Map<String, Integer>>();

    private APICustomEMCMapper() {
    }

    public void registerCustomEMC(ItemStack stack, int emcValue) {
        Map<Object, Object> modMap;
        ModContainer activeMod;
        String modId;
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        if (emcValue < 0) {
            emcValue = 0;
        }
        String string = modId = (activeMod = Loader.instance().activeModContainer()) == null ? null : activeMod.getModId();
        if (this.customEMCforMod.containsKey(modId)) {
            modMap = this.customEMCforMod.get(modId);
        } else {
            modMap = new HashMap();
            this.customEMCforMod.put(modId, modMap);
        }
        modMap.put(this.serializeToString(stack), emcValue);
    }

    protected String serializeToString(ItemStack stack) {
        String name = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        return String.format("%d@%s", stack.func_77960_j(), name);
    }

    protected NormalizedSimpleStack deserializeFromString(String s) {
        String[] splits = s.split("@", 2);
        return NormalizedSimpleStack.getFor((Item)Item.field_150901_e.func_82594_a(splits[1]), Integer.parseInt(splits[0]));
    }

    @Override
    public String getName() {
        return "APICustomEMCMapper";
    }

    @Override
    public String getDescription() {
        return "Allows other mods to set EMC values using the ProjectEAPI";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        final HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        for (String modId : this.customEMCforMod.keySet()) {
            if (modId == null) continue;
            priorityMap.put(modId, config.getInt(modId + "priority", "customEMCPriorities", 1, 0, 512, "Priority for Mod with ModId = " + modId + ". Values: " + this.customEMCforMod.get(modId).size()));
        }
        if (this.customEMCforMod.containsKey(null)) {
            priorityMap.put(null, config.getInt("modlessCustomEMCPriority", "", 1, 0, 512, "Priority for custom EMC values for which the ModId could not be determined. 0 to disable. Values: " + this.customEMCforMod.get(null).size()));
        }
        ArrayList<String> modIds = new ArrayList<String>(this.customEMCforMod.keySet());
        Collections.sort(modIds, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return -((Integer)priorityMap.get(a) - (Integer)priorityMap.get(b));
            }
        });
        for (String modId : modIds) {
            String modIdOrUnknown = modId == null ? "unknown mod" : modId;
            for (Map.Entry<String, Integer> entry : this.customEMCforMod.get(modId).entrySet()) {
                NormalizedSimpleStack normStack = this.deserializeFromString(entry.getKey());
                if (this.isAllowedToSet(modId, normStack, entry.getValue(), config)) {
                    mapper.setValueBefore(normStack, (Integer)((Comparable)entry.getValue()));
                    PELogger.logInfo(String.format("%s setting value for %s to %s", modIdOrUnknown, normStack, entry.getValue()));
                    continue;
                }
                PELogger.logInfo(String.format("Disallowed %s to set the value for %s to %s", modIdOrUnknown, normStack, entry.getValue()));
            }
        }
    }

    protected boolean isAllowedToSet(String modId, NormalizedSimpleStack stack, Integer value, Configuration config) {
        if (!(stack instanceof NormalizedSimpleStack.NSSItem)) {
            return false;
        }
        NormalizedSimpleStack.NSSItem item = (NormalizedSimpleStack.NSSItem)stack;
        String itemName = Item.field_150901_e.func_148750_c(Item.field_150901_e.func_148754_a(item.id));
        String modForItem = itemName.substring(0, itemName.indexOf(58));
        String permission = config.getString(modForItem, "permissions." + modId, "both", String.format("Allow '%s' to set and or remove values for '%s'. Options: [both, set, remove, none]", modId, modForItem), new String[]{"both", "set", "remove", "none"});
        if (permission.equals("both")) {
            return true;
        }
        if (value == 0) {
            return permission.equals("remove");
        }
        return permission.equals("set");
    }
}

